unit AE0 ;

{$B-}
{$I-}
{$S+}
{$V-}

{-----------------------------------------------------------------------------}
{ This unit contains the definitions of all constants, types                  }
{ and global variables                                                        }
{-----------------------------------------------------------------------------}

interface

uses Dos ;

const MaxNrOfWorkspaces = 3 ;     { maximum number of workspaces }
      WsBufSize         = 65534 ; { maximum size of workspace buffer }
      OnePercent        = 655 ;   { = 1% of WsBufSize. Used in status line }
      PasteBufSize      = 16384 ; { maximum size of paste buffer }
      MaxMacroLength    = 100 ;   { maximum number of keystrokes in a macro }
      NrOfMacros        = 10 ;    { number of macros }
      MacroStackDepth   = 10 ;    { maximum size of macro stack }
      PosStackDepth     = 10 ;    { maximum size of position stack }
      Inactive          = 0 ;     { generally used value }
      NrOfCursorTypes   = 4 ;     { number of cursor available types }
      UnderLineCursor   = 1 ;     { cursor type }
      HalfBlockCursor   = 2 ;     { cursor type }
      BlockCursor       = 3 ;     { cursor type }
      NoBlinkCursor     = 4 ;     { cursor type }
      NrOfColorSettings = 8 ;     { size of ScreenColorArray }
      LinesOnScreen     = 25 ;    { number of lines on a screen }
      NrOfTextLines     = 24 ;    { = LinesOnScreen - 1 }
      ColsOnScreen      = 80 ;    { number of columns on a screen }
      CharsOnScreen     = 2000 ;  { number of characters on a screen (25*80) }
      BkspKey           = 264 ;   { keynumber of Backspace key }
      TabKey            = 265 ;   { keynumber of Tab key }
      CtrlReturnKey     = 266 ;   { keynumber of Control-Return key }
      ReturnKey         = 269 ;   { keynumber of Return (= Enter) key }
      EscapeKey         = 283 ;   { keynumber of Escape key }
      LF                = #10 ;   { line feed character (ASCII value 10) }
      FF                = #12 ;   { form feed character (ASCII value 12) }
      CR                = #13 ;   { carriage return character (ASCII value 13) }
      EF                = #26 ;   { end-of-file character (ASCII value 26) }
      ConfigFilename    = 'AE.CFG' ; { name of file containing setup settings }
      Find              = 1 ;     { used to indicate search type }
      FindAndReplace    = 2 ;     { used to indicate search type }
      MaxFileListLength = 100 ;   { maximum number of files that can be in }
                                  { a file list }


type Position       = record Index       : word ;
                             Linenr      : word ;
                             Colnr       : word ;
                             end ;
                      { a position within a workspace buffer is stored in two }
                      { ways: an index for the array (of type WsBuftype) and }
                      { a line number plus column number }
     WsBuftype      = array [1..WsBufSize] of char ;
     WsBufPtr       = ^WsBuftype ;
     Workspacetype  = record Name            : PathStr ;
                             ChangesMade     : boolean ;
                             LastTimeSaved   : array [1..4] of word ;
                                               { hrs,mins,secs,1/100 secs }
                             CurPos          : Position ;
                                               { current position }
                             Mark            : word ;
                                               { index of block mark }
                             FirstVisiblePos : Position ;
                             FirstScreenCol  : word ;
                             VirtualColnr    : word ;
                                               { column nr that CurPos should }
                                               { be on when moving through    }
                                               { buffer vertivally            }
                             Buffer          : WsBufPtr ;
                             BufferSize      : word ;
                                               { number of chars in buffer }
                             PosStack        : array [1..PosStackDepth] of word;
                                               { position stack }
                             PosStackPointer : byte ;
                             end ;
     PasteBuftype   = array [1..PasteBufSize] of char ;
     SetupBlock     = record CursorType      : byte ;
                             Keyclick        : boolean ;
                             ScreenColors    : byte ;
                             SoundBell       : boolean ;
                             PageLength      : word ;
                             LeftMargin      : word ;
                             TopMargin       : word ;
                             PrintPageNrs    : boolean ;
                             WordWrapLength  : word ;
                             TabSpacing      : word ;
                             AutoIndent      : boolean ;
                             DotsForSpaces   : boolean ;
                             InsertMode      : boolean ;
                             SaveOnExit      : boolean ;
                             SaveInterval    : word ;
                             MakeBAKfile     : boolean ;
                             end ;
     MacroBlock        = record Contents      : array [1..NrOfMacros,
                                                       1..MaxMacroLength]
                                                       of word ;
                                Length        : array [1..NrOfMacros] of word ;
                                end ;
     ConfigBlock       = record Setup : SetupBlock ;
                                Macro : MacroBlock ;
                                end ;
     MacroStackElement = record Macronr : byte ;
                                Index   : byte ;
                                end ;
     { the following types are defined because most information is written }
     { directly into video memory }
     ScreenArray    = array[1..LinesOnScreen,1..ColsOnScreen] of word ;
     ScreenPtr      = ^ScreenArray ;
     ScreenBlock    = array[1..CharsOnScreen] of word ;
     ScreenBlockPtr = ^ScreenBlock ;
     ScreenElement  = record Contents  : char ;
                             Attribute : byte ;
                             end ;
     ColorSetting   = record NormAttr   : byte ;
                             BlockAttr  : byte ;
                             StatusAttr : byte ;
                             CursorAttr : byte ;
                             end ;
                      { contains the attributes used on the screen: NormAttr }
                      { for normal characters, BlockAttr for characters      }
                      { within the selected block, StatusAttr for characters }
                      { on the status line and in messages                   }
     FilenameStr    = string[12] ;
                      { contains the name of a file plus extension }


const DefaultSetup : { default setup, used if no setup file is found }
                     { in the current directory }
                     SetupBlock = (
                            CursorType      : UnderLineCursor ;
                            Keyclick        : False ;
                            ScreenColors    : 3 ;
                            SoundBell       : True ;
                            PageLength      : Inactive ;
                            LeftMargin      : 0 ;
                            TopMargin       : 0 ;
                            PrintPageNrs    : False ;
                            WordWrapLength  : Inactive ;
                            TabSpacing      : 0 ;
                            AutoIndent      : True ;
                            DotsForSpaces   : False ;
                            InsertMode      : True ;
                            SaveOnExit      : False ;
                            SaveInterval    : Inactive ;
                            MakeBAKfile     : False ) ;
      ScreenColorArray : { contains the screen color settings that can be }
                         { chosen from. Only the first two are available }
                         { for monochrome video adapters }
                         array [1..NrOfColorSettings] of ColorSetting =
                           {1} ((NormAttr : $07 ;     { LightGrey/Black }
                                 BlockAttr : $70 ;    { Black/LightGrey }
                                 StatusAttr : $0F ;   { White/Black }
                                 CursorAttr : $70) ,  { Black/LightGrey }
                           {2}  (NormAttr : $07 ;     { LightGrey/Black }
                                 BlockAttr : $70 ;    { Black/LightGrey }
                                 StatusAttr : $70 ;   { Black/LightGrey }
                                 CursorAttr : $70) ,  { Black/LightGrey }
                           {3}  (NormAttr : $17 ;     { LightGrey/Blue }
                                 BlockAttr : $3F ;    { White/Cyan }
                                 StatusAttr : $71 ;   { Blue/LightGrey }
                                 CursorAttr : $5F) ,  { White/Magenta }
                           {4}  (NormAttr : $17 ;     { LightGrey/Blue }
                                 BlockAttr : $5F ;    { White/Magenta }
                                 StatusAttr : $7E ;   { Yellow/LightGrey }
                                 CursorAttr : $3F) ,  { White/Cyan }
                           {5}  (NormAttr : $70 ;     { Black/LightGrey }
                                 BlockAttr : $17 ;    { LightGrey/Blue }
                                 StatusAttr : $4F ;   { White/Red }
                                 CursorAttr : $07) ,  { LightGrey/Black }
                           {6}  (NormAttr : $07 ;     { LightGrey/Black }
                                 BlockAttr : $70 ;    { Black/LightGrey }
                                 StatusAttr : $74 ;   { Red/LightGrey }
                                 CursorAttr : $47) ,  { LightGrey/Red }
                           {7}  (NormAttr : $02 ;     { Green/Black }
                                 BlockAttr : $70 ;    { Black/LightGrey }
                                 StatusAttr : $7F ;   { White/LightGrey }
                                 CursorAttr : $20) ,  { Black/Green }
                           {8}  (NormAttr : $03 ;     { Cyan/Black }
                                 BlockAttr : $17 ;    { LightGrey/Blue }
                                 StatusAttr : $74 ;   { Red/LightGrey }
                                 CursorAttr : $30)) ; { Black/Cyan }
      { frame constant used as border string in calls of PutFrame }
      Quasi3DFrame : string[8] = 'ķԳ' ;
      { definition of characters that can act as word separators }
      WordSeparators : set of char = [' ',',','.',':',';',CR,LF] ;
      { constants used for constructing the statusline }
      Status_Wrap   : string[4] = 'Wrap' ;   { indicates word wrap }
      Status_Ins    : string[3] = 'Ins' ;    { indicates insert mode }
      Status_Def    : string[3] = 'Def' ;    { on when defining a macro }
      Status_Indent : string[6] = 'Indent' ; { indicates autoindent }
      { basis for constructing the statusline }
      BasicStatusLine : string [80] =
                         '   L       C                            ' +
                         '                     Ovr               %' ;
      { string used to display CR/LF pair when entering search string }
      CRLFalias : string[2] = #17 + #217 ;

var Config             : ConfigBlock ;
    Workspace          : array [1..MaxNrOfWorkspaces] of Workspacetype ;
    NrOfWorkspaces     : byte ;
                         { actual number of workspaces. may be less than }
                         { MaxNrOfWorkspaces if not enough memory }
    CurrentWsnr        : byte ;
                         { contains number of the current workspace }
    PasteBuffer        : ^PasteBuftype ;
    PasteBufferSize    : word ;
                         { contains number of characters in paste buffer }
    MacroStack         : array [1..MacroStackDepth] of MacroStackElement ;
                         { macro stack is necessary because macros can call }
                         { other macros }
    MacroStackPointer  : byte ;
    MacroDefining      : byte ;
                         { number of the macro that is currently being }
                         { defined (when 0: not defining any) }
    FindString         : string ;
    ReplaceString      : string ;
    SearchOptions      : string[4] ;
    SearchType         : byte ;
    ColorCard          : boolean ;
                         { indicates whether video adapter is monochrome }
                         { or color }
    OldCursorPosAttr   : byte ;
                         { stores the original attribute for the screen }
                         { location where the cursor is on.             }
                         { (only for NoBlinkCursor)                     }
    OrigCursorType     : byte ;
    OrigTextAttr       : byte ;
                         { cursor type and video text attribute on startup }
                         { are kept for restoration on exiting program }
    KeyNumber          : word ;
    MessageRead        : boolean ;
                         { indicates if the message on the status line has }
                         { been read by the user }
                         { set by Message, reset by GetKeyNr }
    LoadfileName       : PathStr ;
                         { contains name of last file to be read or inserted }
    EscPressed         : boolean ;
                         { indicates whether last call of EnterString, }
                         { EnterWord, EnterBoolean, Answer or Choose was }
                         { terminated by user by pressing Escape }
    Found              : boolean ;
                         { indicates whether last search operation or }
                         { bracket matching was succesful }
    IgnoreCase         : boolean ;
    ReverseSearch      : boolean ;
    NoQuery            : boolean ;
    DiskError          : byte ;
                         { contains result of last disk or print operation }
                         { value 0: everything OK }
    DisplayPtr         : ScreenPtr ;
                         { points to begin of video memory }
    {$IFDEF DEVELOP }
    MinMemAvail        : longint ;
                         { used to compute minimum heap size needed }
    {$ENDIF }

implementation

begin
end.
