/*
 *	bclock.c  --  almost analog clock
 *
 *	26 sept 1989  Olle Olsson
 */

#include <stdio.h>
#include <time.h>
#include <conio.h>
#include <process.h>
#include <graphics.h>
#include <stdlib.h>
#include <dos.h>


/*
 * Text mode constants
 */

/* a Turbo C text window starts at row 1, column 1  (not 0) */

/* rows for the bars */
#define HOUR_ROW  5
#define MIN_ROW  10
#define SEC_ROW  15

/* start column for all bars (the length is 60) */
#define STARTCOL  10


/* characters */
#define BAR_CHAR '\xb2'		/* character to make bars with */
#define VLINE_CHAR '\xb3'		/* vertical line */

/*
 * EGA mode constants
 */

/* low y coordinates */
#define HOUR_Y 0
#define MIN_Y  125
#define SEC_Y  250

/* the x length is 600 pixels */
#define START_X	20			/*  < 40 to fit in 640 pixels */

#define TICK_LEN 5			/* tick length */

/* prototypes */
void main( int argc, char *argv[] );
void tx_bclock( int color );
void ega_bclock( int color );
void dobar( int startcol, int row, int length );
void hscale( int startcol, int row, int hscl );
int ega_mode( void );
void nobar( int left, int top, int right, int bottom );


void main( int argc, char *argv[] )
{
int color = 7;			/* default color */
int textmd = 0;			/* force text mode */

if (argc >= 2)
	{
	if ((color = atoi( argv[1] )) <= 0)
		color = 9;
	}

if (argc == 3) ++textmd;

printf(
"\nbclock  1 oct 1989  by  Olle Olsson                                     " );

if (textmd) tx_bclock( color );
else if (ega_mode())
	{
	ega_bclock( color );
	closegraph();
	}
else tx_bclock( color );

exit( 0 );
}


void tx_bclock( int color )
{
int hour = -1;
int min = -1;
int sec = -1;
int i;
int hs0 = -1;		/* hour scale 0/1 */

/* use color text mode (80 columns) if necessary */
if (color != LIGHTGRAY) textmode( C80 );
else textmode( MONO );

/* clear screen */
clrscr();

/* set color */
textcolor( color );

/* do some ticks and scales */
for (i = 0; i <= 60; i += 5)
	{
	char buf[10];

        sprintf( buf, "%d", i );

	gotoxy( STARTCOL + i - 1, HOUR_ROW + 1 );
	putch( VLINE_CHAR );

	gotoxy( STARTCOL + i - 1, MIN_ROW + 1  );
	putch( VLINE_CHAR );
	gotoxy( STARTCOL + i - 1, MIN_ROW + 2 );
	cputs( buf );

	gotoxy( STARTCOL + i - 1, SEC_ROW + 1  );
	putch( VLINE_CHAR );
	gotoxy( STARTCOL + i - 1, SEC_ROW + 2  );
	cputs( buf );
	}

/* show the time */
do
	{
	long now_s;
	struct tm *now;
	int hs1;

	/* get time */
	time( &now_s );
	now = localtime( &now_s );

        hs1 = now -> tm_hour >= 12;

	/* hour scale */
	if (hs0 != hs1)
		{
		hs0 = hs1;
		hscale( STARTCOL, HOUR_ROW + 2, hs0 );
		}

	/* use twelve hours to fit hours in 60 characters */
	now -> tm_hour %= 12;

	/* hours */
	if (now -> tm_hour < hour)
		{
		/* remove the bar */
		gotoxy( 1, HOUR_ROW );
		clreol();
	}

	if (now -> tm_hour != hour)
		{
		/* make the bar longer */
		hour = now -> tm_hour;
		dobar( STARTCOL, HOUR_ROW, hour * 5 );
		}

	/* minutes */
	if (now -> tm_min < min)
		{
		/* remove the bar */
		gotoxy( 1, MIN_ROW );
		clreol();
		}

	if (now -> tm_min != min)
		{
		/* make the bar longer */
		min = now -> tm_min;
		dobar( STARTCOL, MIN_ROW, min );
		}

	/* seconds */
	if (now -> tm_sec < sec)
		{
		/* remove the bar */
		gotoxy( 1, SEC_ROW );
		clreol();
		}

	if (now -> tm_sec != sec)
		{
		/* make the bar longer */
		sec = now -> tm_sec;
		dobar( STARTCOL, SEC_ROW, sec );
		}

	}
while (!kbhit());
getch();

textmode( LASTMODE );
}

void hscale( int startcol, int row, int hs )
{
int i;

for (i = 0; i <= 12; ++i)
	{
	char buf[10];

        sprintf( buf, "%d ", hs ? (i + 12) : i );

	gotoxy( startcol + i * 5 - 1, row );
	cputs( buf );
	}
}

void dobar( int startcol, int row, int length )
{
/* draw a bar */
gotoxy( startcol, row );
while (length-- > 0) putch( BAR_CHAR );
}


/*
 *	graphic mode routines
 */


/* globals */
int grmode;			/* graphic mode */
int max_x_coord;		/* max x */
int max_y_coord;		/* max y */


int ega_mode( void )
{
int g_driver, g_mode, g_error;

/* get the graphics driver linked in  (not loaded at runtime) */
if ((g_error = registerbgidriver( EGAVGA_driver )) < 0)
	{
	/*error( "Registerbgidriver: %s", grapherrormsg( g_error ) );*/
	return 0;
	}

/* any graphics hardware ? */
detectgraph( &g_driver, &g_mode );

if (g_driver < 0)
	{
	/*error( "No graphics hardware detected" );*/
	return 0;
	}

/* use EGA HI mode */
g_driver = EGA;
g_mode = EGAHI;
/*initgraph( &g_driver, &g_mode, "C:\\TURBOC\\BGI" );*/
initgraph( &g_driver, &g_mode, "" );
if ((g_error = graphresult()) < 0)
	{
	/*error( "Initgraph: %s", grapherrormsg( g_error ) );*/
	return 0;
	}

/* set some globals */
grmode = getgraphmode();
max_x_coord = getmaxx();
max_y_coord = getmaxy();

return 1;
}


void ega_bclock( int color )
{
int hour_len = 0;		/* bar length */
int min_len = 0;
int sec_len = 0;
int hour_y1;			/* high coordinate */
int min_y1;
int sec_y1;
int txth = textheight( "0" );	/* text height */
int i;


/* assume ega mode, cleared screen */

/* set color (for the bars) */
setfillstyle( SOLID_FILL, color );

/* make space for scales */
hour_y1 = MIN_Y - (TICK_LEN + txth + 5);
min_y1 = SEC_Y - (2 * TICK_LEN + txth + 2);
sec_y1 = getmaxy();

/* do some ticks and scales */

/* hours */
for (i = 0; i <= 24; ++i)
	{
	char buf[10];

        sprintf( buf, "%d", i );

	moveto( START_X + i * 25, hour_y1 + 1 );
	linerel( 0, TICK_LEN );
	moverel( -textwidth( buf ) / 2, 0 );
	outtext( buf );
	}

/* minutes and seconds */
for (i = 0; i <= 60; ++i)
	{
	char buf[10];
	int tl;			/* tick length */

	moveto( START_X + i * 10, min_y1 + 1 );

	/* short ticks except only every fifth */
	if (i % 5)
		{
		tl = TICK_LEN / 2;

		linerel( 0, tl );
		moverel( 0, tl + tl + txth + 1 );
		linerel( 0, tl );
		}
	else
		{
		tl = TICK_LEN;

		linerel( 0, tl );
		moverel( 0, txth + 1 );
		linerel( 0, tl );

	        sprintf( buf, "%d", i );

		moverel( -textwidth( buf ) / 2, -(txth + 1 + TICK_LEN) );
		outtext( buf );
		}
	}

/* show the time */
do
	{
	struct time *now, ns;
	int len;

	/* get time */
	gettime( now = &ns );

	/* hours */
	len = 25 * (now -> ti_hour +
			 (now -> ti_min + now -> ti_sec / 60.) / 60);
	if (len < hour_len)
		{
		/* remove the bar */
		nobar( START_X, HOUR_Y, getmaxx(), hour_y1 );
		}
	else if (len > hour_len)
		{
		/* make the bar longer */
		bar( START_X + hour_len, HOUR_Y, START_X + len, hour_y1 );
		}
	hour_len = len;

	/* minutes */
	len = 10 * (now -> ti_min + now -> ti_sec / 60.);

	if (len < min_len)
		{
		/* remove the bar */
		nobar( START_X, MIN_Y, getmaxx(), min_y1 );
		}
	else if (len > min_len)
		{
		/* make the bar longer */
		bar( START_X + min_len, MIN_Y, START_X + len, min_y1 );
		}
	min_len = len;


	/* seconds */
	len = 10 * (now -> ti_sec + now -> ti_hund / 100.);

	if (len < sec_len)
		{
		/* remove the bar */
		nobar( START_X, SEC_Y, getmaxx(), sec_y1 );
		}
	else if (len > sec_len)
		{
		/* make the bar longer */
		bar( START_X + sec_len, SEC_Y, START_X + len, sec_y1 );
		}
	sec_len = len;

	}
while (!kbhit());
getch();
}


void nobar( int left, int top, int right, int bottom )
{
struct fillsettingstype fis;

/* draw a bar in current background color */

/* get fill settings */
getfillsettings( &fis );

/* setup for erase */
setfillstyle( SOLID_FILL, getbkcolor() );

/* fill with the background color */
bar( left, top, right, bottom );

/* restore fill settings */
setfillstyle( fis.pattern, fis.color );
}

