/***************************************************************CLOCK.C
* name:		CLOCK - analog clock display
*
* function:	Displays analog clock (with hands) on screen
*
* description:	This is the main program that calls all the functions
*		and subroutines.  Essentially, all it performs is
*		the scheduling function that a multi-tasking operating
*		system would.  
*		It also sets up all the global memory areas.
*******************************************************************
* 11/22/86 -RBM- original design
*******************************************************************/

/***************************
 * MAIN PROGRAM
 ***************************/
#define XTRNALGLOBALS 0			/* globals defined in this module */
#include "E:CLKGBL.H"			/* setup global storage */

main ()
{
	int ch = 0;	/* character input from keyboard */

	clkizn();	/* one-time initialization */
	clksiz();	/* determine size, colors, and location */
	clkclr();	/* clear screen area for clock */
	clkfac();	/* paint clock's face */

	while (ch == 0)			/* check for any key pressed */
		{			/* loop till any key pressed */
		clktim();		/* get time */
		clkpnt();		/* paint hands */
		ch = clkkyb();		/* see if character at keyboard */
		clkhrh();		/* compute hour hand */
		clkmnh();		/* compute minute hand */
		clksch();		/* compute second hand */
		};
	

	sreg.ax = 0X0003;		/* restore screen mode */
	sreg.bx = sreg.cx = sreg.dx = 0;
	csysint(VIDEO, &sreg, &rreg);

}				/******* END OF PROGRAM **************/

