/***************************************************** CLKTIM.C
 * NAME:	CLKTIM
 *
 * FUNCTION:	Get current time.
 *
 * EXAMPLE:	CLKTIM();
 *
 * INPUTS:	Time obtained from system call.
 *
 * OUTPUT:	placed into global definitions
 *
 **************************************************************
 * 11/22/86 -RBM- original implementation
 **************************************************************/
#define XTRNALGLOBALS 1		/* globals externally defined	*/
#include "E:CLKGBL.H"		/* setup global storage */

#define  DBUGON   0 		/* 0=debug off, 1=debug on	*/

/**************************************************************
 * BEGIN ROUTINE
 **************************************************************/

CLKTIM()
{
static int doscall = SYSINTR;	/* system interrupt #               	*/

if (DBUGON == 0)
	{
	/*---- setup "lasts" -----------*/
	lasthr = thishr;
	lt24hr = th24hr;
	lastmn = thismn;
	lastsc = thissc;

	while (lastsc == thissc)
		{/*--- repeat continuously until time changes ---*/
		/*--- get true system time ---*/
		sreg.ax = GETTIME;
		csysint (doscall, &sreg, &rreg);
		thishr = rreg.cx / 256;
		thismn = rreg.cx & 0X00FF;
		thissc = rreg.dx / 256;
		};

	/*--- convert to 12 hour clock ----*/
	th24hr = thishr;
	if (thishr > 12) thishr -= 12;

	}
else
    {/*--- debugging, fake system time ----*/ 
    lasthr = thishr;
    lastmn = thismn;
    lastsc = thissc;
    if (++thissc >= 60)
	{ thissc=0;
	  if (++thismn >= 60) 
		{thismn=0;
		 if (++thishr >= 12) thishr=0;
		};
	};
    };
}				/***** end of routine ******/
