/***************************************************** CLKSIZ.C
 * NAME:	CLKSIZ
 *
 * FUNCTION:	Determines clock size, colors, and location
 *
 * EXAMPLE:	CLKSIZ();
 *
 * INPUTS:	determined from global definitions
 *
 * OUTPUT:	placed into global definitions
 *
 **************************************************************
 * 11/22/86 -RBM- original implementation
 **************************************************************/
#define XTRNALGLOBALS 1		/* globals externally defined	*/
#include "E:CLKGBL.H"		/* setup global storage */

/**************************************************************
 * BEGIN ROUTINE
 **************************************************************/

clksiz()
{
extern struct ACTIMAGE handef[8*HANDSZ]; /* hand definition table */
int	i,j;			/* loop counter, table pointers	  */

if (clocksize <= 100)
	{
	for (i=1; i<=8; i++)
		{
		j = i*HANDSZ-4; /* downsize clock face control*/
		handef[j-4].row = (handef[j].row * clocksize) / 100;
		handef[j-4].col = (handef[j].col * clocksize) / 100;

		j++;		/* downsize hour hand control	*/
		handef[j-4].row = (handef[j].row * clocksize) / 100;
		handef[j-4].col = ((handef[j].col * clocksize)/100) - 1;

		j++;		/* downsize minute hand control	*/
		handef[j-4].row = (handef[j].row * clocksize) / 100;
		handef[j-4].col = ((handef[j].col * clocksize)/100) - 1;

		j++;		/* downsize second hand control	*/
		handef[j-4].row = (handef[j].row * clocksize) / 100;
		handef[j-4].col = ((handef[j].col * clocksize)/100) - 1;

		};
	};

}				/***** end of routine ******/
