/***************************************************** CLKSCH.C
 * NAME:	CLKSCH
 *
 * FUNCTION:	Computes second hand
 *
 * EXAMPLE:	CLKSCH();
 *
 * INPUTS:	determined from global definitions
 *		lastsc, thissc, sccol, scwth
 *
 * OUTPUT:	placed into global definitions
 *		acbsc, acdsc
 **************************************************************
 * 11/22/86 -RBM- original implementation
 **************************************************************/
#define XTRNALGLOBALS 1		/* globals externally defined	*/
#include "E:CLKGBL.H"		/* setup global storage */

/**************************************************************
 * BEGIN ROUTINE
 **************************************************************/

CLKSCH()
{
int	blkhnd;			/* blanking hand (area to blank out)	*/
struct	ACTIMAGE *imgptr;	/* pointer to hand image structure	*/

if (lastsc != thissc)		/* active only when sec changes		*/
	{
	/*--- determine which hand to use ---*/
	actsc = thissc;

	/*--- determine what to blank --------*/
	blkhnd = actsc - 1;
	if (blkhnd < 0) blkhnd = 59;

	/*--- build minute hand images ---------*/
	imgptr = &acbsc[0];
	clkimgh (imgptr, blkhnd);	/* image blanking	*/
	imgptr = &acdsc[0];
	clkimgh (imgptr, actsc);	/* image drawing	*/
	};

}				/***** end of routine ******/
