/***************************************************** CLKPNT.C
 * NAME:	CLKPNT
 *
 * FUNCTION:	Paints hands onto display
 *
 * EXAMPLE:	CLKPNT();
 *
 * INPUTS:	determined from global definitions
 *
 * OUTPUT:	to screen.
 *
 **************************************************************
 * 11/22/86 -RBM- original implementation
 **************************************************************/
#define XTRNALGLOBALS 1		/* globals externally defined	*/
#include "E:CLKGBL.H"		/* setup global storage */

/**************************************************************
 * BEGIN ROUTINE
 **************************************************************/

CLKPNT()
{
static int lacthr;		/* last active hour hand		*/
static int lactmn;		/* last active minute hand		*/
int	i;			/* temporary counter			*/
struct	ACTIMAGE *imgptr;	/* pointer to hand image structure	*/
char	digtim[8];		/* digital time start column		*/
int	dtrow,dtcol;		/* digital time write row, column	*/
#define SCP 512 		/* set cursor position video command	*/

/* --- draw second blanking image -------*/
imgptr=&acbsc[0];			/* sec. hand blanking	*/
drawit (imgptr,bkcol);

/* --- draw hour blanking image -------*/
if (lacthr != acthr)
	{lacthr = acthr;
	 imgptr=&acbhr[0];		/* hour hand blanking	*/
	 drawit (imgptr,bkcol);
	};

/* --- draw minute blanking image -------*/
if (lactmn != actmn)
	{lactmn = actmn;
	 imgptr=&acbmn[0];			/* min. hand blanking	*/
	 drawit (imgptr,bkcol);
	};

/* --- draw hour hand image -------*/
imgptr=&acdhr[0];			 /* hr hand image	*/
drawit (imgptr,mncol);

/* --- draw minute hand image -------*/
imgptr=&acdmn[0];			/* min hand image	*/
drawit (imgptr,mncol);

/* --- draw second hand image -------*/
imgptr=&acdsc[0];			/* sec hand image	*/
drawit (imgptr,sccol);

/*--- draw digital time -----------------*/
if (digclock != 0)
    {
    dtrow = digrow;				/* row to write at	   */
    dtcol = digcol;				/* column to start writing */

    sreg.ax = SCP;				/* "set cursor position"   */
    sreg.bx = 0;				/* page #		   */
    sreg.cx = 0;				/* unused		   */
    sreg.dx = dtrow*256 + dtcol;		/* row, col		   */
    csysint(VIDEO, &sreg, &rreg);

    digtim[0] = '0' + (char)(lt24hr/10);	/* compute hrs tens digits */
    if (digtim[0]=='0') digtim[0]=' ';		/* blank out hrs leading 0 */
    digtim[1] = '0' + (char)(lt24hr%10);	/* compute hrs units digits*/
    digtim[2] = ':';
    digtim[3] = '0' + (char)(lastmn/10);	/* compute min tens digits */
    digtim[4] = '0' + (char)(lastmn%10);	/* compute min units digits*/
    digtim[5] = ':';
    digtim[6] = '0' + (char)(lastsc/10);	/* compute sec tens digits */
    digtim[7] = '0' + (char)(lastsc%10);	/* compute sec units digits*/

    for (i=0; i<=7; i++)
	{sreg.ax = 2304 + digtim[i];		/* char write command	   */
	 sreg.bx = digclr;			/* set color		   */
	 sreg.cx = 1;				/* write 1 char		   */
	 sreg.dx = 0;				/* unused		   */
	 csysint(VIDEO, &sreg, &rreg);

	 dtcol++;				/* move cursor over	   */
	 sreg.ax = SCP;
	 sreg.bx = sreg.cx = 0;
	 sreg.dx = dtrow*256 + dtcol;
	 csysint(VIDEO, &sreg, &rreg);
	};
    };
}				/***** end of routine ******/

/*--- subroutine to actually do the drawing ----------------------------*/
#define abs(x) ((x)<0?-(x):(x))	/* define absolute value function	*/


drawit (ptr,color)

struct ACTIMAGE *ptr;		/* pointer to hand image structure	*/
int	color;			/* color of dot to draw			*/

{
int	overdown;		/* over or down flag (+=over, -=down)	*/
int	width;			/* width of dots to draw (-tive is down)*/
int	i;			/* temporary counter			*/

for ( ; ptr->row != 0; ptr++)
	{sreg.ax = 12*256 + color;		/* color of dot 		*/
	 sreg.cx = ptr->col;			/* point to column		*/
	 sreg.dx = ptr->row;			/* row to draw on 		*/

	overdown = ptr->wth;		/* get over or down flag	*/
	width = abs(overdown);		/* get width of dots to draw	*/
	for (i=0; i<width; i++) 	/* step thru "wth" columns	*/
	    {if (overdown >= 0)
		{ /*--- stepping "over" ---*/
		 sreg.cx = ptr->col + i;	/* point to column		*/
		 csysint(VIDEO, &sreg, &rreg);	/* draw dot		*/
		}
	     else
		{ /*--- stepping "down" ---*/
		 sreg.dx = ptr->row + i;	/* point to row			*/
		 csysint(VIDEO, &sreg, &rreg);	/* draw dot		*/
		};

	    };
	};
} /*--- end subroutine -------------------------------------------------*/
