/***************************************************** CLKMNH.C
 * NAME:	CLKMNH
 *
 * FUNCTION:	Computes minute hand
 *
 * EXAMPLE:	CLKMNH();
 *
 * INPUTS:	determined from global definitions
 *		lastmn, thismn, mncol, mnwth	
 *
 * OUTPUT:	placed into global definitions
 *		acbmn, acdmn
 **************************************************************
 * 11/22/86 -RBM- original implementation
 **************************************************************/
#define XTRNALGLOBALS 1		/* globals externally defined	*/
#include "E:CLKGBL.H"		/* setup global storage */

/**************************************************************
 * BEGIN ROUTINE
 **************************************************************/

CLKMNH()
{
int	i;			/* temporary counter			*/
int	blkhnd;			/* blanking hand (area to blank out)	*/
struct	ACTIMAGE *imgptr;	/* pointer to hand image structure	*/

if (lastmn != thismn)		/* active only when min changes		*/
	{
	change = 1;		/* show change				*/

	/*--- determine which hand to use ---*/
	actmn = thismn;

	/*--- determine what to blank --------*/
	blkhnd = actmn - 1;
	if (blkhnd < 0) blkhnd = 59;

	/*--- build minute hand images ---------*/
	imgptr = &acbmn[0];
	clkimgh (imgptr, blkhnd);	/* image blanking	*/
	imgptr = &acdmn[0];
	clkimgh (imgptr, actmn);	/* image drawing	*/
	};

}				/***** end of routine ******/
