/********************************************************** CLKKYB.C
 * NAME:	CLKKYB
 *
 * FUNCTION:	Inputs character from keyboard, and deals with
 *		options selected.
 *
 * EXAMPLE:	CLKKYB();
 *
 * INPUTS:	none
 *
 * OUTPUT:	ch = character returned from keyboard. (=0 if none)
 *
 **************************************************************
 * 11/22/86 -RBM- original implementation
 **************************************************************/
#define XTRNALGLOBALS 1		/* globals externally defined	*/
#include "E:CLKGBL.H"		/* setup global storage */

/**************************************************************
 * BEGIN ROUTINE
 **************************************************************/

int CLKKYB()
{
int ch;				/* character input from keyboard */
ch = kbhit();
if (ch != 0) ch=options();	/* see if character is an option */
return(ch);
}				/***** end of routine ******/


/****************************************************************
* OPTIONS - checks to see if character is one of many that can
*		alter the setup of the clock display
*****************************************************************/
int options()

{
int	chr;			/* character actually input	*/
int	pozzible;		/* possibly useful character	*/
int 	repaint;		/* requests re-painting of clock*/

chr = getch();			/* get character from kybd 	*/

pozzible = 1;			/* show evaluating character	*/
repaint = 0;
while (pozzible != 0)
	{
	if ((chr == (int)'h') ||
	    (chr == (int)'H') ||
	    (chr == (int)'?')    )
		{/*-------------- help screen ------------------*/
		repaint = 1;	/* show have to re-paint screen	*/
		sreg.ax=0x0003;	/* clear screen			*/
		sreg.bx = sreg.cx = sreg.dx = 0;
		csysint(VIDEO, &sreg, &rreg);

		printf ("======= CLOCK HELP SCREEN ========\n");
		printf ("\n");
		printf ("H or ? displays this screen\n");
		printf ("0 - 9 sets size (1=10%%, 2=20%%, 0=100%%)\n");
		printf ("C = center clock in display\n");
		printf ("R = move clock to right side\n");
		printf ("L = move clock to left side\n");
		printf ("T = move clock to top half\n");
		printf ("B = move clock to bottom half\n");
		printf ("D = toggle digital clock on/off\n");
		printf ("<spacebar> to continue with no changes\n");
		printf ("\n");
		printf ("----- current values ------\n");
		printf ("row=%3d, col=%3d, size=%3d%%, digclock=%1d\n",
		         cntrow,  cntcol,  clocksize,  digclock);

		chr = getch();		/* get next character from kybd */

		}

	else if ((chr >= (int)'0') && (chr <= (int)'9'))
		{/*----------- adjust clock size --------------------*/
		if (chr == (int)'0') clocksize = 100;
		else  		     clocksize = (chr-(int)'0')*10;
		chr = (int)'H';
		}

	else if ((chr == (int)'c') ||
		 (chr == (int)'C')   )
		{/*----------- center clock in display --------------*/
		cntcol = CENTC;
		cntrow = CENTR;
		chr = (int)'H';
		}

	else if ((chr == (int)'r') ||
		 (chr == (int)'R')   )
		{/*----------- move clock to right hand side ---------*/
		cntcol = CENTC + 80;
		chr = (int)'H';
		}

	else if ((chr == (int)'l') ||
		 (chr == (int)'L')   )
		{/*----------- move clock to left hand side ----------*/
		cntcol = CENTC - 80;
		chr = (int)'H';
		}

	else if ((chr == (int)'t') ||
		 (chr == (int)'T')   )
		{/*----------- move clock to top half ----------------*/
		cntrow = CENTR - 50;
		chr = (int)'H';
		}

	else if ((chr == (int)'b') ||
		 (chr == (int)'B')   )
		{/*----------- move clock to bottom half -------------*/
		cntrow = CENTR + 50;
		chr = (int)'H';
		}

	else if ((chr == (int)'d') ||
		 (chr == (int)'D')   )
		{/*----------- toggle digital clock display ----*/
		if (digclock == 0) digclock=1;
		else 		   digclock=0;
		chr = 0;
		pozzible = 0;
		}
	else if (chr == (int)' ')
		{/*------------ spacebar out -------------------*/
		chr = 0;
		pozzible = 0;
		}
	else
		{/*------- input key not supported -------------*/
		chr = chr;		/* pass character thru	*/
		pozzible = 0;
		};
	};

if (repaint != 0)
	{	/*------- re-paint clock -----------------------*/
	clksiz();	/* determine size, colors, etc	*/
	clkizn();	/* initialization		*/
	clkclr();	/* clear screen			*/
	clkfac();	/* paint clock's face		*/
	clktim();	/* get time			*/
	};

return(chr);
} /*------------ end subroutine --------------------------------*/