/***************************************************** CLKIMGH.C
 * NAME:	CLKIMGH
 *
 * FUNCTION:	Images hands for clock program.
 *
 * EXAMPLE:	clkimgh (pointr, handnb)
 *
 * INPUTS:	type	name	description
 *		pointer	pointr	points to output structure
 *		int	handnb	hand number ("minute")
 *
 * OUTPUT:	type	name	description
 *		struct.	---	array of dots (see structure ACTIMAGE)
 *
 ****************************************************************
 * 12/04/86 -RBM- original implementation
 * 12/13/86 -RBM- converted to "ACTIMAGE" handef table
 * 12/20/86 -RBM- converted to singlelinewidth handef table
 ****************************************************************/

#define XTRNALGLOBALS 1	/* globals defined externally	*/
#include "E:CLKGBL.H"		/* setup global storage		*/
#include "E:CLKHN2.H"		/* include hands definition	*/

/****************************************************************
 * BEGIN ROUTINE
 ****************************************************************/

clkimgh (pointr, handnb)

struct	ACTIMAGE *pointr;	/* pointer to hand image structure	*/
int	handnb;			/* hand number (0 - 59)			*/

{
int	hstart;			/* entry in hand image table to start	*/
int	hstop;			/* entry in hand image table to stop	*/
int	hoct;			/* this hand's octant indicator		*/
int	hentr;			/* this hand's entry in "handef" table	*/
int	hwidth;			/* this hand's width			*/

int	tblidx;			/* index into handef table		*/

int	rowlocater;		/* used to locate center of clock	*/
int	collocater;		/* used to locate center of clock	*/
int	shifter;		/* shift row/col start by this much	*/

/*--- get hand's octant & entry from "handqud" table ------------*/
hoct  = hanqud[handnb].qoc;	/* get "octant"	 indicator	*/
hentr = hanqud[handnb].qhe;	/* get entry in "handef" table	*/

/*--- determine "start", "stop" entries in handef table ---*/
tblidx = hentr * HANDSZ;	/* point to first entry in handef	*/

if      ((pointr == &acbhr) || (pointr == &acdhr))
	{ /* we are doing the hour hand */
	hstart = tblidx + handef[(tblidx+HANDSZ-7)].row;
	hstop  = tblidx + handef[(tblidx+HANDSZ-7)].col;
	hwidth = hrwth;
	}
else if ((pointr == &acbmn) || (pointr == &acdmn))
	{ /* we are doing the minute hand */
	hstart = tblidx + handef[(tblidx+HANDSZ-6)].row;
	hstop  = tblidx + handef[(tblidx+HANDSZ-6)].col;
	hwidth = mnwth;
	}
else if ((pointr == &acbsc) || (pointr == &acdsc))
	{ /* we are doing the second hand */
	hstart = tblidx + handef[(tblidx+HANDSZ-5)].row;
	hstop  = tblidx + handef[(tblidx+HANDSZ-5)].col;
	hwidth = scwth;
	}
else	
	{ /* must be doing clock face */
	hstart = tblidx + handef[(tblidx+HANDSZ-8)].row;
	hstop  = tblidx + handef[(tblidx+HANDSZ-8)].col;
	hwidth = fcwth;
	};

rowlocater = cntrow - CENTR;	/* compute center shifter	*/
collocater = cntcol - CENTC;	/* compute center shifter	*/
shifter = hwidth/2;		/* account for hand's width	*/

/* --- build hand image ----------------------------------------*/

/*DEBUG printf ("<CLKIMGH>hentr=%5d hstart=%5d hstop=%5d tblidx=%5d\n",
                            hentr,    hstart,    hstop,    tblidx);
*/
tblidx = hstart;
while (tblidx <= hstop)
    {

    if (tblidx >= hstart)	/* see if building image yet		*/
	{
	switch (hoct)	/*--- image build based on octant  -------------*/
	    {
		case OCT1 : /* --- first octant ---*/
		    {
		    pointr->row = handef[tblidx].row;
		    pointr->col = handef[tblidx].col - shifter;
		    pointr->wth = hwidth;
		    break;
		    };
		case OCT2 : /* --- second octant ---*/
		    {
		    pointr->row = (260 - handef[tblidx].col) + shifter - hwidth;
		    pointr->col = 260 - handef[tblidx].row;
		    pointr->wth = -hwidth;
		    break;
		    };
		case OCT3 : /* --- third octant ---*/
		    {
		    pointr->row = handef[tblidx].col - 60 - shifter;
		    pointr->col = 260 - handef[tblidx].row;
		    pointr->wth = -hwidth;
		    break;
		    };
		case OCT4 : /* --- fourth octant ---*/
		    {
		    pointr->row = 200 - handef[tblidx].row;
		    pointr->col = handef[tblidx].col - shifter;
		    pointr->wth = hwidth;
		    break;
		    };
		case OCT5 : /* --- fifth octant ---*/
		    {
		    pointr->row = 200 - handef[tblidx].row;
		    pointr->col = (320 - handef[tblidx].col) + shifter - hwidth;
		    pointr->wth = hwidth;
		    break;
		    };
		case OCT6 : /* --- sixth octant ---*/
		    {
		    pointr->row = handef[tblidx].col - 60 - shifter;
		    pointr->col = 60 + handef[tblidx].row;
		    pointr->wth = - hwidth;
		    break;
		    };
		case OCT7 : /* --- seventh octant ---*/
		    {
		    pointr->row = (260 - handef[tblidx].col) + shifter - hwidth;
		    pointr->col = 60 + handef[tblidx].row;
		    pointr->wth = - hwidth;
		    break;
		    };
		case OCT8 : /* --- eighth octant ---*/
		    {
		    pointr->row = handef[tblidx].row;
		    pointr->col = (320 - handef[tblidx].col) + shifter - hwidth;
		    pointr->wth = hwidth;
		    break;
		    };



	    };

	pointr->row += rowlocater;	/* adjust location		*/
	pointr->col += collocater;	/* adjust location		*/
	pointr++;
	};

    tblidx++;			/* point to next entry			*/
    };

/*--- save last row/col/width in image table ---*/
pointr->row = 0;
pointr->col = 0;
pointr->wth = 0;

}				/*--- end of routine ---*/
