/***************************************************** CLKHRH.C
 * NAME:	CLKHRH
 *
 * FUNCTION:	Computes hour hand
 *
 * EXAMPLE:	CLKHRH();
 *
 * INPUTS:	determined from global variables
 *		acthr, hrwth, lasthr, thishr
 *
 * OUTPUT:	placed into global variables
 *		acbhr, acdhr
 *
 **************************************************************
 * 11/22/86 -RBM- original implementation
 * 10/25/87 -RBM- fixed bug imaging 12:00 hand
 **************************************************************/
#define XTRNALGLOBALS 1		/* globals externally defined	*/
#include "E:CLKGBL.H"		/* setup global storage */

/**************************************************************
 * BEGIN ROUTINE
 **************************************************************/

clkhrh()
{
int	i;			/* temporary counter			*/
int	blkhnd;			/* blanking hand (area to blank out)	*/
struct	ACTIMAGE *imgptr;	/* pointer to hand image structure	*/

if (lastmn != thismn)		/* active only when min changes		*/
	{
	change = 1;		/* show hands changed			*/
	/*--- determine which hand to use ---*/
	if (thishr == 12) i = 0;
	else i = thishr;
	acthr = ((int)(i*5)) + ((int)(thismn/10));
	if (acthr >= 60) acthr = 59;

	/*--- determine what to blank --------*/
	blkhnd = acthr - 1;
	if (blkhnd < 0) blkhnd = 59;

	/*--- build hour hand images ---------*/
	imgptr = &acbhr[0];
	clkimgh (imgptr, blkhnd);	/* image blanking	*/
	imgptr = &acdhr[0];
	clkimgh (imgptr, acthr);	/* image drawing	*/
	};

}				/***** end of routine ******/
