/*********************************************************** CLKHN2.H
* THIS TABLE DEFINES THE CLOCK HANDS
**********************************************************************/
struct ACTIMAGE handef[8*HANDSZ] /* 8 of 'em required			*/
				/* note: last seven entries of each	*/
				/*  hand's image are "start" draw and	*/
				/*  "stop" drawing indices.		*/
				/* 99 = second hand default		*/
				/* 98 = minute hand default		*/
				/* 97 = hour hand default		*/
				/* 96 = extension for # image default	*/
				/* 95 = second hand active  		*/
				/* 94 = minute hand active  		*/
				/* 93 = hour hand active  		*/
				/* 92 = extension for # image active  	*/

		/* format of each index's entry is: row,col,width	*/
      = { 	/*--- hand entry # 0  ---*/
           100,160,1,   99,160,1,   98,160,1,   97,160,1,   96,160,1, 
            95,160,1,   94,160,1,   93,160,1,   92,160,1,   91,160,1, 
            90,160,1,   89,160,1,   88,160,1,   87,160,1,   86,160,1, 
            85,160,1,   84,160,1,   83,160,1,   82,160,1,   81,160,1, 
            80,160,1,   79,160,1,   78,160,1,   77,160,1,   76,160,1, 
            75,160,1,   74,160,1,   73,160,1,   72,160,1,   71,160,1, 
            70,160,1,   69,160,1,   68,160,1,   67,160,1,   66,160,1, 
            65,160,1,   64,160,1,   63,160,1,   62,160,1,   61,160,1, 
            60,160,1,   59,160,1,   58,160,1,   57,160,1,   56,160,1, 
            55,160,1,   54,160,1,   53,160,1,   52,160,1,   51,160,1, 
            50,160,1,   49,160,1,   48,160,1,   47,160,1,   46,160,1, 
            45,160,1,   44,160,1,   43,160,1,   42,160,1,   41,160,1, 
            40,160,1,   39,160,1,   38,160,1,   37,160,1,   36,160,1, 
            35,160,1,   34,160,1,   33,160,1,   32,160,1,   31,160,1, 
            30,160,1,   29,160,1,   28,160,1,   27,160,1,   26,160,1, 
            25,160,1,   24,160,1,   23,160,1,   22,160,1,   21,160,1, 
            20,160,1,   19,160,1,   18,160,1,   17,160,1,   16,160,1, 
            15,160,1,   14,160,1,   13,160,1,   12,160,1,   11,160,1, 
            10,160,1,    9,160,1,    8,160,1,    7,160,1,    6,160,1, 
             5,160,1,
	   77, 89,0,	/* extension for hour # image 			*/
	    0, 36,0,	/* hour   hand "start", "stop" drawing indices	*/
	    0, 72,0,	/* minute hand "start", "stop" drawing indices	*/
	    0, 76,0,	/* second hand "start", "stop" drawing indices	*/

               /*--- hand entry # 1  ---*/
           100,160,1,   99,160,1,   98,160,1,   97,160,1,   96,160,1, 
            95,161,1,   94,161,1,   93,161,1,   92,161,1,   91,161,1, 
            90,161,1,   89,161,1,   88,161,1,   87,161,1,   86,161,1, 
            85,162,1,   84,162,1,   83,162,1,   82,162,1,   81,162,1, 
            80,162,1,   79,162,1,   78,162,1,   77,162,1,   76,163,1, 
            75,163,1,   74,163,1,   73,163,1,   72,163,1,   71,163,1, 
            70,163,1,   69,163,1,   68,163,1,   67,163,1,   66,164,1, 
            65,164,1,   64,164,1,   63,164,1,   62,164,1,   61,164,1, 
            60,164,1,   59,164,1,   58,164,1,   57,165,1,   56,165,1, 
            55,165,1,   54,165,1,   53,165,1,   52,165,1,   51,165,1, 
            50,165,1,   49,165,1,   48,165,1,   47,166,1,   46,166,1, 
            45,166,1,   44,166,1,   43,166,1,   42,166,1,   41,166,1, 
            40,166,1,   39,166,1,   38,167,1,   37,167,1,   36,167,1, 
            35,167,1,   34,167,1,   33,167,1,   32,167,1,   31,167,1, 
            30,167,1,   29,167,1,   28,168,1,   27,168,1,   26,168,1, 
            25,168,1,   24,168,1,   23,168,1,   22,168,1,   21,168,1, 
            20,168,1,   19,169,1,   18,169,1,   17,169,1,   16,169,1, 
            15,169,1,   14,169,1,   13,169,1,   12,169,1,   11,169,1, 
            10,169,1,    9,170,1,    8,170,1,    7,170,1,    6,170,1, 
             5,170,1,    4,170,1,
	    0, 36,0,	/* hour   hand "start", "stop" drawing indices	*/
	    0, 72,0,	/* minute hand "start", "stop" drawing indices	*/
	    0, 76,0,	/* second hand "start", "stop" drawing indices	*/

               /*--- hand entry # 2  ---*/
           100,160,1,   99,160,1,   98,160,1,   97,161,1,   96,161,1, 
            95,161,1,   94,161,1,   93,161,1,   92,162,1,   91,162,1, 
            90,162,1,   89,162,1,   88,163,1,   87,163,1,   86,163,1, 
            85,163,1,   84,163,1,   83,164,1,   82,164,1,   81,164,1, 
            80,164,1,   79,164,1,   78,165,1,   77,165,1,   76,165,1, 
            75,165,1,   74,166,1,   73,166,1,   72,166,1,   71,166,1, 
            70,166,1,   69,167,1,   68,167,1,   67,167,1,   66,167,1, 
            65,167,1,   64,168,1,   63,168,1,   62,168,1,   61,168,1, 
            60,169,1,   59,169,1,   58,169,1,   57,169,1,   56,169,1, 
            55,170,1,   54,170,1,   53,170,1,   52,170,1,   51,170,1, 
            50,171,1,   49,171,1,   48,171,1,   47,171,1,   46,171,1, 
            45,172,1,   44,172,1,   43,172,1,   42,172,1,   41,173,1, 
            40,173,1,   39,173,1,   38,173,1,   37,173,1,   36,174,1, 
            35,174,1,   34,174,1,   33,174,1,   32,174,1,   31,175,1, 
            30,175,1,   29,175,1,   28,175,1,   27,176,1,   26,176,1, 
            25,176,1,   24,176,1,   23,176,1,   22,177,1,   21,177,1, 
            20,177,1,   19,177,1,   18,177,1,   17,178,1,   16,178,1, 
            15,178,1,   14,178,1,   13,178,1,   12,179,1,   11,179,1, 
            10,179,1,    9,179,1,    8,180,1,    7,180,1,    6,180,1, 
             5,180,1,    4,180,1,
	    0, 36,0,	/* hour   hand "start", "stop" drawing indices	*/
	    0, 72,0,	/* minute hand "start", "stop" drawing indices	*/
	    0, 76,0,	/* second hand "start", "stop" drawing indices	*/

               /*--- hand entry # 3  ---*/
           100,160,1,   99,160,1,   98,161,1,   97,161,1,   96,161,1, 
            95,162,1,   94,162,1,   93,162,1,   92,163,1,   91,163,1, 
            90,163,1,   89,164,1,   88,164,1,   87,164,1,   86,165,1, 
            85,165,1,   84,165,1,   83,166,1,   82,166,1,   81,166,1, 
            80,166,1,   79,167,1,   78,167,1,   77,167,1,   76,168,1, 
            75,168,1,   74,168,1,   73,169,1,   72,169,1,   71,169,1, 
            70,170,1,   69,170,1,   68,170,1,   67,171,1,   66,171,1, 
            65,171,1,   64,172,1,   63,172,1,   62,172,1,   61,173,1, 
            60,173,1,   59,173,1,   58,174,1,   57,174,1,   56,174,1, 
            55,175,1,   54,175,1,   53,175,1,   52,176,1,   51,176,1, 
            50,176,1,   49,177,1,   48,177,1,   47,177,1,   46,178,1, 
            45,178,1,   44,178,1,   43,179,1,   42,179,1,   41,179,1, 
            40,179,1,   39,180,1,   38,180,1,   37,180,1,   36,181,1, 
            35,181,1,   34,181,1,   33,182,1,   32,182,1,   31,182,1, 
            30,183,1,   29,183,1,   28,183,1,   27,184,1,   26,184,1, 
            25,184,1,   24,185,1,   23,185,1,   22,185,1,   21,186,1, 
            20,186,1,   19,186,1,   18,187,1,   17,187,1,   16,187,1, 
            15,188,1,   14,188,1,   13,188,1,   12,189,1,   11,189,1, 
            10,189,1,    9,190,1,    8,190,1,    7,190,1,    6,191,1, 
             5,191,1,    4,191,1,
	    0, 36,0,	/* hour   hand "start", "stop" drawing indices	*/
	    0, 72,0,	/* minute hand "start", "stop" drawing indices	*/
	    0, 76,0,	/* second hand "start", "stop" drawing indices	*/

               /*--- hand entry # 4  ---*/
           100,160,1,   99,160,1,   98,161,1,   97,161,1,   96,162,1, 
            95,162,1,   94,163,1,   93,163,1,   92,164,1,   91,164,1, 
            90,164,1,   89,165,1,   88,165,1,   87,166,1,   86,166,1, 
            85,167,1,   84,167,1,   83,168,1,   82,168,1,   81,168,1, 
            80,169,1,   79,169,1,   78,170,1,   77,170,1,   76,171,1, 
            75,171,1,   74,172,1,   73,172,1,   72,172,1,   71,173,1, 
            70,173,1,   69,174,1,   68,174,1,   67,175,1,   66,175,1, 
            65,176,1,   64,176,1,   63,176,1,   62,177,1,   61,177,1, 
            60,178,1,   59,178,1,   58,179,1,   57,179,1,   56,180,1, 
            55,180,1,   54,180,1,   53,181,1,   52,181,1,   51,182,1, 
            50,182,1,   49,183,1,   48,183,1,   47,184,1,   46,184,1, 
            45,184,1,   44,185,1,   43,185,1,   42,186,1,   41,186,1, 
            40,187,1,   39,187,1,   38,188,1,   37,188,1,   36,188,1, 
            35,189,1,   34,189,1,   33,190,1,   32,190,1,   31,191,1, 
            30,191,1,   29,192,1,   28,192,1,   27,193,1,   26,193,1, 
            25,193,1,   24,194,1,   23,194,1,   22,195,1,   21,195,1, 
            20,196,1,   19,196,1,   18,197,1,   17,197,1,   16,197,1, 
            15,198,1,   14,198,1,   13,199,1,   12,199,1,   11,200,1, 
            10,200,1,    9,201,1,    8,201,1,    7,201,1,    6,202,1, 
             5,202,1,    4,203,1,
	    0, 36,0,	/* hour   hand "start", "stop" drawing indices	*/
	    0, 72,0,	/* minute hand "start", "stop" drawing indices	*/
	    0, 76,0,	/* second hand "start", "stop" drawing indices	*/

               /*--- hand entry # 5  ---*/
           100,160,1,   99,161,1,   98,161,1,   97,162,1,   96,162,1, 
            95,163,1,   94,163,1,   93,164,1,   92,165,1,   91,165,1, 
            90,166,1,   89,166,1,   88,167,1,   87,168,1,   86,168,1, 
            85,169,1,   84,169,1,   83,170,1,   82,170,1,   81,171,1, 
            80,172,1,   79,172,1,   78,173,1,   77,173,1,   76,174,1, 
            75,174,1,   74,175,1,   73,176,1,   72,176,1,   71,177,1, 
            70,177,1,   69,178,1,   68,178,1,   67,179,1,   66,180,1, 
            65,180,1,   64,181,1,   63,181,1,   62,182,1,   61,183,1, 
            60,183,1,   59,184,1,   58,184,1,   57,185,1,   56,185,1, 
            55,186,1,   54,187,1,   53,187,1,   52,188,1,   51,188,1, 
            50,189,1,   49,189,1,   48,190,1,   47,191,1,   46,191,1, 
            45,192,1,   44,192,1,   43,193,1,   42,193,1,   41,194,1, 
            40,195,1,   39,195,1,   38,196,1,   37,196,1,   36,197,1, 
            35,198,1,   34,198,1,   33,199,1,   32,199,1,   31,200,1, 
            30,200,1,   29,201,1,   28,202,1,   27,202,1,   26,203,1, 
            25,203,1,   24,204,1,   23,204,1,   22,205,1,   21,206,1, 
            20,206,1,   19,207,1,   18,207,1,   17,208,1,   16,208,1, 
            15,209,1,   14,210,1,   13,210,1,   12,211,1,   11,211,1, 
            10,212,1,    9,213,1,    8,213,1,    7,214,1,    6,214,1, 
             5,215,1,
	   77, 86,0,	/* extension for hour # image 			*/
	    0, 36,0,	/* hour   hand "start", "stop" drawing indices	*/
	    0, 72,0,	/* minute hand "start", "stop" drawing indices	*/
	    0, 76,0,	/* second hand "start", "stop" drawing indices	*/

               /*--- hand entry # 6  ---*/
           100,160,1,   99,161,1,   98,161,1,   97,162,1,   96,163,1, 
            95,164,1,   94,164,1,   93,165,1,   92,166,1,   91,167,1, 
            90,167,1,   89,168,1,   88,169,1,   87,169,1,   86,170,1, 
            85,171,1,   84,172,1,   83,172,1,   82,173,1,   81,174,1, 
            80,175,1,   79,175,1,   78,176,1,   77,177,1,   76,177,1, 
            75,178,1,   74,179,1,   73,180,1,   72,180,1,   71,181,1, 
            70,182,1,   69,183,1,   68,183,1,   67,184,1,   66,185,1, 
            65,185,1,   64,186,1,   63,187,1,   62,188,1,   61,188,1, 
            60,189,1,   59,190,1,   58,191,1,   57,191,1,   56,192,1, 
            55,193,1,   54,193,1,   53,194,1,   52,195,1,   51,196,1, 
            50,196,1,   49,197,1,   48,198,1,   47,199,1,   46,199,1, 
            45,200,1,   44,201,1,   43,201,1,   42,202,1,   41,203,1, 
            40,204,1,   39,204,1,   38,205,1,   37,206,1,   36,206,1, 
            35,207,1,   34,208,1,   33,209,1,   32,209,1,   31,210,1, 
            30,211,1,   29,212,1,   28,212,1,   27,213,1,   26,214,1, 
            25,214,1,   24,215,1,   23,216,1,   22,217,1,   21,217,1, 
            20,218,1,   19,219,1,   18,220,1,   17,220,1,   16,221,1, 
            15,222,1,   14,222,1,   13,223,1,   12,224,1,   11,225,1, 
            10,225,1,    9,226,1,    8,227,1,    7,228,1,    6,228,1, 
             5,229,1,    4,230,1,
	    0, 36,0,	/* hour   hand "start", "stop" drawing indices	*/
	    0, 72,0,	/* minute hand "start", "stop" drawing indices	*/
	    0, 76,0,	/* second hand "start", "stop" drawing indices	*/

               /*--- hand entry # 7  ---*/
           100,160,1,   99,161,1,   98,162,1,   97,163,1,   96,164,1, 
            95,165,1,   94,165,1,   93,166,1,   92,167,1,   91,168,1, 
            90,169,1,   89,170,1,   88,171,1,   87,172,1,   86,173,1, 
            85,174,1,   84,174,1,   83,175,1,   82,176,1,   81,177,1, 
            80,178,1,   79,179,1,   78,180,1,   77,181,1,   76,182,1, 
            75,183,1,   74,183,1,   73,184,1,   72,185,1,   71,186,1, 
            70,187,1,   69,188,1,   68,189,1,   67,190,1,   66,191,1, 
            65,192,1,   64,192,1,   63,193,1,   62,194,1,   61,195,1, 
            60,196,1,   59,197,1,   58,198,1,   57,199,1,   56,200,1, 
            55,201,1,   54,201,1,   53,202,1,   52,203,1,   51,204,1, 
            50,205,1,   49,206,1,   48,207,1,   47,208,1,   46,209,1, 
            45,210,1,   44,210,1,   43,211,1,   42,212,1,   41,213,1, 
            40,214,1,   39,215,1,   38,216,1,   37,217,1,   36,218,1, 
            35,219,1,   34,219,1,   33,220,1,   32,221,1,   31,222,1, 
            30,223,1,   29,224,1,   28,225,1,   27,226,1,   26,227,1, 
            25,228,1,   24,228,1,   23,229,1,   22,230,1,   21,231,1, 
            20,232,1,   19,233,1,   18,234,1,   17,235,1,   16,236,1, 
            15,237,1,   14,237,1,   13,238,1,   12,239,1,   11,240,1, 
            10,241,1,    9,242,1,    8,243,1,    7,244,1,    6,245,1, 
             5,246,1,    4,246,1,
	    0, 36,0,	/* hour   hand "start", "stop" drawing indices	*/
	    0, 72,0,	/* minute hand "start", "stop" drawing indices	*/
	    0, 76,0	/* second hand "start", "stop" drawing indices	*/
	};














/****************************************************************
* THIS TABLE DEFINES THE HAND'S QUADRANTS                     	*
* The entry # defines the "minute"				*
* The first column defines the "octant" in which the hand 	*
*   is drawn.							*
* The second column defines which hand entry to use		*
*****************************************************************/
#define OCT1 1		/* 1st octant				*/
#define OCT2 2		/* 2nd octant				*/
#define OCT3 3		/* 3rd octant				*/
#define OCT4 4		/* 4th octant				*/
#define OCT5 5		/* 5th octant				*/
#define OCT6 6		/* 6th octant				*/
#define OCT7 7		/* 7th octant				*/
#define OCT8 8		/* 8th octant				*/

struct HANQDX {
	int qoc;	/* octant				*/
	int qhe;	/* hand entry to use			*/
	} hanqud [60] = {
	/*00*/	OCT1,	0,
	/*01*/	OCT1,	1,
	/*02*/	OCT1,	2,
	/*03*/	OCT1,	3,
	/*04*/	OCT1,	4,
	/*05*/	OCT1,	5,
	/*06*/	OCT1,	6,
	/*07*/	OCT1,	7,

	/*08*/	OCT2,	7,
	/*09*/	OCT2,	6,
	/*10*/	OCT2,	5,
	/*11*/	OCT2,	4,
	/*12*/	OCT2,	3,
	/*13*/	OCT2,	2,
	/*14*/	OCT2,	1,

	/*15*/	OCT3,	0,
	/*16*/	OCT3,	1,
	/*17*/	OCT3,	2,
	/*18*/	OCT3,	3,
	/*19*/	OCT3,	4,
	/*20*/	OCT3,	5,
	/*21*/	OCT3,	6,
	/*22*/	OCT3,	7,

	/*23*/	OCT4,	7,
	/*24*/	OCT4,	6,
	/*25*/	OCT4,	5,
	/*26*/	OCT4,	4,
	/*27*/	OCT4,	3,
	/*28*/	OCT4,	2,
	/*29*/	OCT4,	1,

	/*30*/	OCT5,	0,
	/*31*/	OCT5,	1,
	/*32*/	OCT5,	2,
	/*33*/	OCT5,	3,
	/*34*/	OCT5,	4,
	/*35*/	OCT5,	5,
	/*36*/	OCT5,	6,
	/*37*/	OCT5,	7,

	/*38*/	OCT6,	7,
	/*39*/	OCT6,	6,
	/*40*/	OCT6,	5,
	/*41*/	OCT6,	4,
	/*42*/	OCT6,	3,
	/*43*/	OCT6,	2,
	/*44*/	OCT6,	1,

	/*45*/	OCT7,	0,
	/*46*/	OCT7,	1,
	/*47*/	OCT7,	2,
	/*48*/	OCT7,	3,
	/*49*/	OCT7,	4,
	/*50*/	OCT7,	5,
	/*51*/	OCT7,	6,
	/*52*/	OCT7,	7,

	/*53*/	OCT8,	7,
	/*54*/	OCT8,	6,
	/*55*/	OCT8,	5,
	/*56*/	OCT8,	4,
	/*57*/	OCT8,	3,
	/*58*/	OCT8,	2,
	/*59*/	OCT8,	1
	};