/*************************************************************** CLKGBL.H
* This module defines the global variables for the CLOCK program	*
* and subfunctions.							*
*************************************************************************
* It is the only place these variables are defined.  To allow for	*
* declaration in the main program and "external" defines in the		*
* subfunctions, a parameter is defined just before the #include.	*
* The constant "XTRNALGLOBALS" is defined as:				*
*	0 = variables declared (only in "main" program)			*
*	1 = variables externally defined (in subfunctions)		*
* EXAMPLE:								*
* 	#define XTRNALGLOBALS 1		(globals externally defined)	*
*	#include "E:CLKGBL.H"		(include defines)		*
************************************************************************/

/*------ setup "extern" prefix -----------------------------------------*/
#if XTRNALGLOBALS > 0 
#define XTRN extern			/* externally defined globals 	*/
#else
#define XTRN 				/* declared globals		*/
#endif

/*------ setup video i/o stuff -----------------------------------------*/
static char clrscr[5] = {'\33', '[', '2', 'J', '\0' };	/* clear screen string 	*/

	struct REGS {		/* structure defining bios call registers */
		int ax;		/* ax register				*/
		int bx;		/* bx register				*/
		int cx;		/* cx register				*/
		int dx;		/* dx register				*/
		};
XTRN 	struct REGS sreg;	/* source data registers		*/
XTRN 	struct REGS rreg;	/* returned data registers		*/

#define SYSINTR  0X0021		/* DOS system interrupt #		*/
#define GETTIME  0X2C00 	/* get time dos int function		*/
#define VIDEO 0X10		/* bioscal video interrupt # 		*/
#define BLK 0			/* color palette 1 background (black)	*/
#define GRN 1			/* color palette 1 green		*/
#define RED 2			/* color palette 1 red			*/
#define YEL 3			/* color palette 1 yellow		*/
XTRN	int 	kolor;		/* color of dot				*/

/*------- time ---------------------------------------------------------*/
XTRN	int	lasthr;			/* hour when last looked	*/
XTRN	int	lt24hr;			/* (for 24 hour digital clock)	*/
XTRN	int	lastmn;			/* minute when last looked	*/
XTRN	int	lastsc;			/* second when last looked	*/
XTRN	int	thishr;			/* this hour			*/
XTRN	int	th24hr;			/* (for 24 hour digital clock)	*/
XTRN	int	thismn;			/* this minute			*/
XTRN	int	thissc;			/* this second			*/
/*----------------------------------------------------------------------*/
#define	SHWTH 1				/* second hand default width	*/
#define	SHLTH 100			/* second hand default length	*/
#define MHWTH 5				/* minute hand default width	*/
#define MHLTH 75			/* minute hand default length	*/
#define HHWTH 9 			/* hour hand default width	*/
#define HHLTH 50			/* hour hand default length	*/
XTRN	int 	scwth = SHWTH;		/* second hand width		*/
XTRN	int 	sccol = RED;		/* second hand color		*/
XTRN	int	mnwth = MHWTH;		/* minute hand width		*/
XTRN	int	mncol = YEL;		/* minute hand color		*/
XTRN	int	hrwth = HHWTH;		/* hour hand width		*/
XTRN	int	hrcol = GRN;		/* hour hand color		*/
XTRN	int	fcwth = MHWTH;		/* face "hand" width		*/
XTRN	int	fccol = GRN;		/* face default color		*/ 
XTRN	int	bkcol = BLK;		/* background color		*/

#define	CENTC 320/2			/* center column loc. default	*/
#define	CENTR 200/2			/* center row location default	*/
XTRN	int	cntcol = CENTC;		/* center column location	*/
XTRN	int	cntrow = CENTR;		/* center row location		*/

XTRN	int	clocksize = 100;	/* size of clock (% fullsize)	*/

/*------ setup hand display arrays -------------------------------------*/
XTRN	int	actsc;			/* active second hand		*/
XTRN	int	actmn;			/* active minute hand		*/
XTRN	int	acthr;			/* active hour hand		*/
XTRN	int	change;			/* hand change, re-draw		*/

	struct ACTIMAGE {		/* defines image of hand	*/
		int row;		/*  start row			*/
		int col;		/*  start col			*/
		int wth;		/*  width to draw 		*/
					/*   +=step col +, -=step row + */
		};
#define HANDSZ 100		/* length of table req'd to define hand	*/
XTRN	struct ACTIMAGE acbsc[HANDSZ];	/* second hand blanking		*/
XTRN	struct ACTIMAGE acdsc[HANDSZ];	/* second hand draw		*/
XTRN	struct ACTIMAGE acbmn[HANDSZ];	/* minute hand blanking		*/
XTRN	struct ACTIMAGE acdmn[HANDSZ];	/* minute hand draw		*/
XTRN	struct ACTIMAGE acbhr[HANDSZ];	/* hour hand blanking		*/
XTRN	struct ACTIMAGE acdhr[HANDSZ];	/* hour hand draw		*/

/*------ control digital display of time -------------------------------*/
XTRN	int	digclock = 0;		/* controls display of digital	*/
					/* time... 0 = don't display,	*/
					/*         1 = display it.	*/
XTRN 	int	digrow = 0;		/* row to display it (on 40x25)	*/
XTRN 	int	digcol = 32;		/* col to display it (on 40x25)	*/
XTRN	int	digclr = GRN;		/* color to display it in	*/
