/***************************************************** CLKFAC.C
 * NAME:	CLKFAC
 *
 * FUNCTION:	Paint clock's face on screen.
 *
 * EXAMPLE:	CLKFAC();
 *
 * INPUTS:	determined from global definitions
 *
 * OUTPUT:	placed into global definitions
 *
 **************************************************************
 * 11/22/86 -RBM- original implementation
 **************************************************************/
#define XTRNALGLOBALS 1		/* globals externally defined	*/
#include "E:CLKGBL.H"		/* setup global storage */

/**************************************************************
 * BEGIN ROUTINE
 **************************************************************/

CLKFAC()
{
int	i;			/* temporary counter		*/
int	hour;			/* hour under consideration	*/
int	hourhand;		/* hour hand to draw		*/
struct	ACTIMAGE acnumbrs[100];	/* draw image structure		*/

/**** loop thru all 12 hours ******/
for (hour=1; hour<=12; hour++)
	{ /*--- build "hand" --- */
	  if (hour == 12) hourhand=0; else hourhand=hour;
	  clkimgh (&acnumbrs[0], hourhand*5);

	  /*--- draw "hand" -----*/
	  drawit (&acnumbrs[0], fccol);

	  /*--- locate, position and draw hour # ---*/
	  for (i=0; acnumbrs[i].row != 0; i++);
	  i--;  /* point to the last position in draw image	*/
	  drawnum (acnumbrs[i].row, acnumbrs[i].col, hour, fccol);

	};

}				/***** end of routine ******/

/************************************************************************
* drawnum - draws number on screen in graphics mode.			*
*************************************************************************/
drawnum (row, col, numbr, color)
int 	row;			/* row position of center of number 	*/
int	col;			/* column position of center of number	*/
int	numbr;			/* number to draw			*/
int	color;			/* color to draw it			*/
{
#define DRWWTH 15 		/* images are 15 lines wide		*/
#define DRWDPH 15 		/* images are 15 lines deep		*/ 
#define NIMGS   4		/* number of images			*/
static struct IMG { int image;	/* bit = 1 means draw dot		*/
		    int blank;	/* bit = 1 means blank background	*/
		    int num;	/* the number that this image draws	*/
		  }
		  imgary[NIMGS*DRWDPH]
		= {	/**** # 3 ***/
			0x0000,	0x0FF8,	3,  /* ............... */
			0x05C0,	0x0FF8,	3,  /* ....X.XXX...... */
			0x07E0,	0x0FF8,	3,  /* ....XXXXXX..... */
			0x0430,	0x0FF8,	3,  /* ....X....XX.... */
			0x0030,	0x0FF8,	3,  /* .........XX.... */
			0x0030,	0x0FF8,	3,  /* .........XX.... */
			0x01E0,	0x0FF8,	3,  /* ......XXXX..... */
			0x01C0,	0x0FF8,	3,  /* ......XXX...... */
			0x0060,	0x0FF8,	3,  /* ........XX..... */
			0x0030,	0x0FF8,	3,  /* .........XX.... */
			0x0430,	0x0FF8,	3,  /* ....X....XX.... */
			0x0670,	0x0FF8,	3,  /* ....XX..XXX.... */
			0x07E0,	0x0FF8,	3,  /* ....XXXXXX..... */
			0x05C0,	0x0FF8,	3,  /* ....X.XXX...... */
			0x0000,	0x0FF8,	3,  /* ............... */
			/**** # 6 ***/
			0x0000,	0x1FF0,	6,  /* ............... */
			0x03C0,	0x1FF0,	6,  /* .....XXXX...... */
			0x0660,	0x1FF0,	6,  /* ....XX..XX..... */
			0x0C00,	0x1FF0,	6,  /* ...XX.......... */
			0x0C00,	0x1FF0,	6,  /* ...XX.......... */
			0x0C00,	0x1FF0,	6,  /* ...XX.......... */
			0x0FC0,	0x1FF0,	6,  /* ...XXXXXX...... */
			0x0FE0,	0x1FF0,	6,  /* ...XXXXXXX..... */
			0x0E60,	0x1FF0,	6,  /* ...XXX..XX..... */
			0x0C20,	0x1FF0,	6,  /* ...XX....X..... */
			0x0C20,	0x1FF0,	6,  /* ...XX....X..... */
			0x0E60,	0x1FF0,	6,  /* ...XXX..XX..... */
			0x07C0,	0x1FF0,	6,  /* ....XXXXX...... */
			0x0380,	0x1FF0,	6,  /* .....XXX....... */
			0x0000,	0x1FF0,	6,  /* ............... */
			/**** # 9 ***/
			0x0000,	0x1FF0,	9,  /* ............... */
			0x0380,	0x1FF0,	9,  /* .....XXX....... */
			0x07C0,	0x1FF0,	9,  /* ....XXXXX...... */
			0x0CE0,	0x1FF0,	9,  /* ...XX..XXX..... */
			0x0860,	0x1FF0,	9,  /* ...X....XX..... */
			0x0860,	0x1FF0,	9,  /* ...X....XX..... */
			0x0CE0,	0x1FF0,	9,  /* ...XX..XXX..... */
			0x0FE0,	0x1FF0,	9,  /* ...XXXXXXX..... */
			0x07E0,	0x1FF0,	9,  /* ....XXXXXX..... */
			0x0060,	0x1FF0,	9,  /* ........XX..... */
			0x0060,	0x1FF0,	9,  /* ........XX..... */
			0x0060,	0x1FF0,	9,  /* ........XX..... */
			0x0CC0,	0x1FF0,	9,  /* ...XX..XX...... */
			0x0780,	0x1FF0,	9,  /* ....XXXX....... */
			0x0000,	0x1FF0,	9,  /* ............... */
			/**** # 12 ***/
			0x0000,	0x3FFE,	12,  /* ............... */
			0x0C38,	0x3FFE,	12,  /* ...XX....XXX... */
			0x1C7C,	0x3FFE,	12,  /* ..XXX...XXXXX.. */
			0x1CCC,	0x3FFE,	12,  /* ..XXX..XX..XX.. */
			0x0484,	0x3FFE,	12,  /* ....X..X....X.. */
			0x040C,	0x3FFE,	12,  /* ....X......XX.. */
			0x0418,	0x3FFE,	12,  /* ....X.....XX... */
			0x0430,	0x3FFE,	12,  /* ....X....XX.... */
			0x0460,	0x3FFE,	12,  /* ....X...XX..... */
			0x04C0,	0x3FFE,	12,  /* ....X..XX...... */
			0x04C0,	0x3FFE,	12,  /* ....X..XX...... */
			0x04C4,	0x3FFE,	12,  /* ....X..XX...X.. */
			0x1EFC,	0x3FFE,	12,  /* ..XXXX.XXXXXX.. */
			0x1EFC,	0x3FFE,	12,  /* ..XXXX.XXXXXX.. */
			0x0000,	0x3FFE,	12   /* ............... */
		  };
int	ntry;		/* table entry					*/
int	bitx;		/* bit being accessed (1=lsbit)			*/
int	mask;		/* bit mask					*/

/******* BEGIN PROCESSING ***********************************************/
/*DEBUG printf("<drawnum>%5d%5d%5d%5d\n",row,col,numbr,color);
*/
/*----- adjust row & col to point to upper right corner of char --------*/
row -= DRWDPH/2;
col += DRWWTH/2;
switch (numbr)		/* adjust for hand width */
	{
	case  3 : row += mnwth/2; break;
	case  6 : col += mnwth/2; break;
	case  9 : row += mnwth/2; break;
	case 12 : col += mnwth/2; break;
	};

/*----- find entry in table, exit if not found -------------------------*/
for (ntry=0; ntry<(NIMGS*DRWDPH); ntry++)
    {
/*DEBUG printf("found.. %5x%5x%5x%5d%5d%5d\n",imgary[ntry].image,
 imgary[ntry].blank, imgary[ntry].num, ntry, row, col);
*/
    if (imgary[ntry].num == numbr) 
	{
	sreg.bx = 0;			/* unused			*/
	sreg.cx = col;			/* setup column			*/
	sreg.dx = row;			/* setup row			*/

	/*--- get line entry, scan thru dots ---------------------------*/
	for (bitx=1; bitx<=DRWWTH; bitx++,sreg.cx--)
		{mask = 1;		/* build dot mask		*/
 		mask <<= bitx;
/*DEBUG printf("       bitx=3d%5d  mask=%4x\n",bitx,mask);
*/
		/*--- check blank, draw dot if so ----------------------*/
		if ((imgary[ntry].blank & mask) != 0)
			{
			/*--- if dot off (=0) color = bkgnd ------------*/
			/*    if dot on  (=1) color = color             */
			if ((imgary[ntry].image & mask) == 0)
				sreg.ax = 3072 + bkcol; /* =0, bkgnd	*/
			else	sreg.ax = 3072 + color; /* =1, dot colr */

			/*--- draw dot ---------------------------------*/
			csysint (VIDEO, &sreg, &rreg);
			};
		};
	row++;
	};
    };
}
