/***************************************************** CLKCLR.C
 * NAME:	CLKCLR
 *
 * FUNCTION:	Clear screen area for clock.
 *
 * EXAMPLE:	CLKCLR();
 *
 * INPUTS:	determined from global definitions
 *
 * OUTPUT:	placed into global definitions
 *
 **************************************************************
 * 11/22/86 -RBM- original implementation
 **************************************************************/
#define XTRNALGLOBALS 1		/* globals externally defined	*/
#include "E:CLKGBL.H"		/* setup global storage */

/**************************************************************
 * BEGIN ROUTINE
 **************************************************************/

CLKCLR()
{
sreg.ax = sreg.bx = sreg.cx = sreg.dx = 0;

/*--------- clear screen  --------------*/
printf(clrscr);

sreg.ax = 0X0004;		/* set mode = 320 X 200 color */
csysint(VIDEO, &sreg, &rreg);

sreg.ax = 11 * 256;		/* set color palette command 	*/
sreg.bx = BLK * 256;		/* background color = black	*/
csysint(VIDEO, &sreg, &rreg);

sreg.ax = 11 * 256;		/* color palette command	*/
sreg.bx =  1 * 256;		/* select color palette 1	*/
csysint(VIDEO, &sreg, &rreg);

}				/***** end of routine ******/
