.286
;-EQUALS----------------
CR		EQU	0DH
LF		EQU	0AH
BUF_LENR	EQU	10H
BUF_LEN		EQU	20H
P_DATA		EQU	278H
P_STAT		EQU	279H
P_CONT		EQU	27AH
P_DAC		EQU	378H
P_SDAC		EQU	37AH
P_NEST		EQU	40AH
TIMER_LOW	EQU	000H	; DSS
TIMER_HI	EQU	01H	; FREQUENCY

CSEG		SEGMENT
		ORG 100H
		ASSUME CS:CSEG,DS:CSEG
START:
		JMP	INIT_
;-INT-01H-HANDLER-------
INT01_HAND	PROC	NEAR
		PUSHF
		CMP	BYTE PTR CS:INT01_ACT,1
		JNZ	INT01_EX1
		PUSH	AX DX SI DS CS
		POP	DS
		CLD
		MOV	SI,WORD PTR DS:DSS_OFFTIM
		MOV	DX,P_SDAC	; USE THIS
		MOV	AL,3		; ON STEREO-IN-ONE
		OUT	DX,AL		; ONLY!
		MOV	DX,P_DAC
		OUTSB
		CMP	BYTE PTR DS:COUNT,0
		JZ	INT01_2
		DEC	BYTE PTR DS:COUNT
INT01_2:
		CMP	SI,OFFSET DSS_BUF+BUF_LEN
		JNZ	INT01_1
		MOV	SI,OFFSET DSS_BUF
INT01_1:
		MOV	WORD PTR DS:DSS_OFFTIM,SI
		CMP	SI,WORD PTR DS:DSS_OFFCAB
		JNZ	INT01_EX
	;-SET-OLD-TIMER-
		CLI
		MOV	AL,00110110B
		OUT	43H,AL
		MOV	DX,WORD PTR DS:OLD_TSPEED
		MOV	AL,DL
		OUT	40H,AL
		MOV	AL,DH
		OUT	40H,AL
		MOV	BYTE PTR DS:INT01_ACT,0
		STI
	;-INT-08H-EXIT--
INT01_EX:
		POP	DS SI DX AX
		POPF
		IRET
	;-FIX-TSPEED----
INT01_EX1:
		PUSH	AX
		CLI
		MOV	AL,00000110B
		OUT	43H,AL
		IN	AL,40H
		MOV	AH,AL
		IN	AL,40H
		XCHG	AH,AL
		MOV	WORD PTR CS:OLD_TSPEED,AX
		STI
		POP	AX
		POPF
		IRET
INT01_ACT	DB	0
OLD_TSPEED	DW	0
INT01_HAND	ENDP
;-CALLBACK-FUNCTION-----
CALLB_FUN	PROC	NEAR
		PUSH	DS CS
		POP	DS
		CMP	DX,P_DATA
		JZ	SEND_DATA
		CMP	DX,P_STAT
		JZ	GET_STAT
		CMP	DX,P_CONT
		JZ	SEND_STROB
		POP	DS
		STC
		RETF
SEND_DATA:
		OR	CL,CL
		JZ	CALLB_EX
		CMP	BYTE PTR DS:COUNT,BUF_LENR
		JG	CALLB_EX
		PUSH	DI
		MOV	DI,WORD PTR DS:DSS_OFFCAB
		MOV	BYTE PTR DS:[DI],AL
		POP	DI
		JMP	CALLB_EX
GET_STAT:
		OR	CL,CL
		JNZ	CALLB_EX
		CMP	BYTE PTR DS:COUNT,BUF_LENR
		JGE	NOT_READY
		MOV	AL,0
		JMP	CALLB_EX
NOT_READY:
		MOV	AL,40H
		JMP	CALLB_EX
SEND_STROB:
		OR	CL,CL
		JZ	CALLB_EX
		CMP	BYTE PTR DS:COUNT,BUF_LENR
		JG	CALLB_EX
		TEST	AL,8
		JNZ	CALLB_EX
		INC	BYTE PTR DS:COUNT
		PUSH	AX
		MOV	AX,WORD PTR DS:DSS_OFFCAB
		INC	AX
		CMP	AX,OFFSET DSS_BUF+BUF_LEN
		JNZ	SEND_1
		MOV	AX,OFFSET DSS_BUF
SEND_1:
		MOV	WORD PTR DS:DSS_OFFCAB,AX
		CMP	BYTE PTR DS:INT01_ACT,1
		JZ	ALR_ACT
	;-SET-NEW-SPEED-
		CLI
		MOV	AX,00110110B
		OUT	43H,AL
		MOV	AL,TIMER_LOW
		OUT	40H,AL
		MOV	AL,TIMER_HI
		OUT	40H,AL
		STI
		MOV	BYTE PTR INT01_ACT,1
ALR_ACT:
		POP	AX
CALLB_EX:
		POP	DS
		CLC
		RETF
DSS_OFFCAB	DW	OFFSET DSS_BUF
DSS_OFFTIM	DW	OFFSET DSS_BUF
COUNT		DB	0
DSS_BUF		DB	BUF_LEN DUP (80H)
CALLB_FUN	ENDP
;-GET-QEMM-API-ADDRESS--
INIT_		LABEL	NEAR
		MOV	DX,OFFSET LOGO
		CALL	FAST_EX
		MOV	AH,3FH
		MOV	CX,5145H	; 'QE'
		MOV	DX,4D4DH	; 'MM'
		INT	67H
		OR	AH,AH
		JZ	CONT_1
		MOV	DX,OFFSET ERR_1
		JMP	FAST_EX
CONT_1:
		MOV	WORD PTR DS:API_SEG,ES
		MOV	WORD PTR DS:API_OFF,DI
;-CHECK-QEMM-STATE------
		MOV	AH,0
		CALL	QEMM_API
		TEST	AL,1
		JZ	CONT_2
		MOV	DX,OFFSET ERR_2
		JMP	FAST_EX
CONT_2:
		TEST	AL,2
		JZ	CONT_3
		MOV	DX,OFFSET ERR_3
		JMP	FAST_EX
CONT_3:
		MOV	DX,OFFSET SUC_1
		CALL	FAST_EX
;-CHECK-PORTS-TRAP------
		MOV	CX,3
		MOV	SI,OFFSET PORT_LIST
CONT_6:
		LODSW
		XCHG	DX,AX
		MOV	BP,DX
		MOV	AX,1A08H
		CALL	QEMM_API
		OR	BL,BL
		JZ	CONT_5
		MOV	DX,OFFSET ERR_5
		JMP	FAST_EX
CONT_5:
;-TRAP-DSS-PORTS--------
		MOV	AX,1A09H
		MOV	DX,BP
		CALL	QEMM_API
		JNC	CONT_4
		MOV	DX,OFFSET ERR_4
		JMP	FAST_EX
CONT_4:
		LOOP	CONT_6
;-SET-CALLBACK-ADDRESS--
		MOV	AX,1A07H
		PUSH	CS
		POP	ES
		MOV	DI,OFFSET CALLB_FUN
		CALL	QEMM_API
;-SET-NEW-LPT2-ADDRESS--
		XOR	AX,AX
		MOV	ES,AX
		MOV	WORD PTR ES:P_NEST,P_DATA
;-SET-VECTORS-----------
		MOV	DX,OFFSET SUC_2
		CALL	FAST_EX
		MOV	AX,2501H
		MOV	DX,OFFSET INT01_HAND
		INT	21H
;-SET-386-BREAKPOINTS---
.386P
		MOV	EAX,08H*4
		MOV	DR0,EAX
		MOV	EAX,00000000000000110000001100000011B
		MOV	DR7,EAX
.286
;-LEAVE-TSR-------------
		MOV	DX,OFFSET INIT_
		INT	27H
;-CALL-QEMM-API---------
QEMM_API:
		DB	09AH		; CALL FAR
API_OFF		DW	0
API_SEG		DW	0
		RETN
;-FAST-EXIT-------------
FAST_EX:
		MOV	AH,9
		INT	21H
		RETN
;-PROGRAM-DATA----------
PORT_LIST	DW	P_DATA,P_STAT,P_CONT
LOGO		DB	'DSS Emulator 0.01 by SkullC0DEr',CR,LF,'$'
ERR_1		DB	'QEMM Not installed!',CR,LF,'$'
ERR_2		DB	'QEMM Is turned off!',CR,LF,'$'
ERR_3		DB	'QEMM Is in AUTO mode!',CR,LF,'$'
ERR_4		DB	'Error while trapping ports!$',CR,LF,'$'
ERR_5		DB	'Port already trapped!',CR,LF,'$'
SUC_1		DB	'QEMM Is OK.',CR,LF,'$'
SUC_2		DB	'Emulation installed to LPT2. Exiting.',CR,LF,'$'

CSEG		ENDS
		END	START
