;Lange Dateinamen unter nacktem DOS
;Noch zu tun:
;funktionierende Verzeichnis-Verlngerung ber Clustergrenzen
;CD-Linktable-Erstellung (als externes Programm fast fertig)
;Tunnel
;LoSA
;Speicherspar-Ladevariante ohne CDROM-Zugriff
;"verlngerte" Sektoren und Untersttzung von Sektorlnge 128..4096 Bytes
	include	prolog.asm
public COMentry		;damit's mit SoftICE klappt
	P386
	JUMPS
REQfunc		equ	7146h		;in AX
REQcode		equ	9877h		;in DX
ANScode		equ	8766h		;in AX; DX=Segmentadresse
;ResPara	equ	(ISRE-PSPOrg+0fh)/16	;Nein, variabel!!
DEFHEAPSIZE	=	5000		;zwei CD-Sektoren mssen da hinein!
FDChangeTime	=	3*18 ;Neue DPB einlesen nach 3 Sekunden Inaktivitt
CDChangeTime	=	7*18 ;dauert naturgem viel lnger,
	;auch das Einlesen der ersten CD-Sektoren und der Link-Tabelle
macro INT3
ifdef DEBUG
	INT 3
endif
endm

struc tExDPB		;{gltig ab DOS 4.0}
 Drive  db	?	;{0=A}
 UnitNo db	?	;{Nummer im Einheitentreiber}
 SecLen dw	?	;{Bytes pro Sektor}
 HiSec  db	?	;{Anzahl Sektoren pro Cluster -1, 2**n-1}
 Shift  db	?	;{Verschiebung n}
 ResSec dw	?	;{Reservierte Sektoren am Anfang des Laufwerks}
 FATs	db	?	;{Anzahl der FATs}
 RootEn dw	?	;{Anzahl Wurzelverzeichniseintrge}
 UsrSec dw	?	;{1. Sektor mit Userdaten}
 HiClus dw	?	;{Anzahl Cluster -1}
 SecFAT dw	?	;{Sektoren pro FAT}
 SecDir dw	?	;{Sektornummer 1.Dir}
 unused db	5 dup (?) ;Luft zum FAT32-DPB, der beginnt ab Ofs.24
 dpb_flags		db	?
 next_dpb		dd	?	;Pointer
 start_search_cluster	dw	?
 free_clusters		dd	?
 mirroring		dw	?
 file_system_info_sector dw	?
 backup_boot_sector	dw	?
 first_sector		dd	?
 max_cluster		dd	?
 sectors_per_fat	dd	?
 root_cluster		dd	?
 free_space_cluster	dd	?
 filler			db	?	;"gerade" Strukturlnge!
ends

struc tDirEnt	;{Verzeichniseintrag auf Platte (FAT12, FAT16, FAT32)}
		;{Quelle: Ralf Brown Interruptliste}
		;Beachte: 1. Zeichen=00: keine weiteren DirEnts,
		;		     05: 1. Zeichen = E5
		;		     E5: gelschter Eintrag
 FName 	db	11 dup (?); in FCB-Form
 Attr   db	?
 resv   db	?	;{Win95: Null}
 timeC10ms db	?	;{Win95: 10ms additiv zu timeC [0..199]}
 timeC	dd	?	;{Win95: Erstellungs-Zeit (lokale Zeit)}
 timeA	dw	?	;{Win95: Letzter Zugriff (nur Datum)}
 ClusH  dw	?	;{FAT32: High-Teil des Start-Clusters}
 timeM  dd	?
 ClusL	dw	?
 fsize	dd	?
ends

struc TLfnDirEnt
 count	db	?	;{Bit 0..5: lfd. Nummer (1+), Bit 6=Ende}
 Name1	dw	5 dup (?)
 Attr	dw	?	;{immer $000F}
 check	db	?	;{Prfbyte?}
 Name2	dw	6 dup (?)
 Clus1	dw	?	;{immer $0000}
 Name3	dw	2 dup (?)
ends

struc TCD_DirEnt
 r	db	?	;{the number of bytes in the record}
 ea	db	?	;{0 [number of sectors in extended attribute record]}
 sect	dd	?	;{Logical Block Number of file start}
 sectm	dd	?
 fsize	dd	?	;{file length in bytes}
 fsizem	dd	?
 year	db	?	;Jahre seit 1900
 month	db	?	;1=Januar
 day	db	?	;1=1.
 hour	db	?	;0..23
 minu	db	?	;0..59
 seco	db	?	;0..59, gewhnlich gerade unter DOS
 tz	db	?	;Zeitzone der Lokalzeit, vzb, 15min, +ost, -west
 flags	db	?	;Flags, Bit0=hidden, Bit1=Dir, Bit7=weitere DirEnts
 isiz	db	?	;fr Interleave
 igap	db	?	;fr Interleave
 vsn	dw	?	;volume sequence number
 vsnm	dw	?
 fnamelen db	?	;Name-Lnge in Bytes (bei Unicode immer gerade)
 fname	db	?	;Name (bei Unicode in Motorola-Bytefolge!)
ends

struc TSearchRec
 Drive	db	?	;{Bit7 gesetzt bei Netzlaufwerk und FAT32}
 SName	db	8 dup (?)
 SExt	db	3 dup (?)
 SAttr	db	?
 DirNo	dw	?
 union
  struc
   Clus	dw	?
   Res	dd	?
  ends
  struc
   Clus32 dd	?	;{bei FAT32}
   DirNoHi dw	?	;{vielleicht der High-Teil von DirNo?}
  ends
 ends
 Attr	db	?	;Ab hier dokumentierter Teil
 Time	dd	?
 fsize	dd	?
 FName	db	13 dup (?)	; in DOS-Form
ends
;Lnge "undokumentiert"=21 Bytes, "dokumentiert"=22 Bytes

struc TW32FindData
 attr	dd	?	;{0..6: DOS, 8: temporary}
 timec	dq	?	;file creation time	 10-ms-Schritte
 timea	dq	?	;last access time	 1-d-Schritte
 timem	dq	?	;last modification time, 2-s-Schritte
 sizeh	dd	?
 sizel	dd	?	;Dateilnge
 res	dq	?
 lname	db	260 dup (?)	;langer Name
 sname	db	14 dup (?)	;kurzer Name
ends

struc tRWRec
 sect	dd	?
 numb	dw	?
 addr	dd	?
ends

struc tFindInfo		;als interne Reprsentation von FindHandle
 usage	db	?	;MagicByte
 drive	db	?	;Laufwerk
 attr	dw	?	;Attribute
 entry	dw	?	;Eintrags-Nr. (DirEnt-Zeiger)
 sect	dd	?	;Sektor-Nummer
 cd_entry dw	?	;Joliet-DirEnt-Zeiger
 cd_sect dd	?	;Joliet-Sektor-Nummer
 fflags	db	?	;File_Flags (nur DotAtEnd wesentlich?)
			;anschlieend Maske
ends

struc tFB_FindInfo
 usage	db	?	;ein anderes MagicByte
 undoc	db	21 dup (?)	;"undokumentierter" DTA-Bereich
 mmattr	db	?	;Attribut (CX beim Aufruf)
 fflags	db	?	;wesentlich: File_Flag_DotAtEnd
			;anschlieend: Maske
			;(nur ntig wenn File_Flag_Is_LFN oder Char_High)
ends

struc tErrInfo		;fr Set_Error_Info Int21 AX=5D0A DS:DX=Zeiger
 err_AX	dw	?
 err_BX	dw	?
 err_CX	dw	?
 err_DX	dw	?
 err_SI	dw	?
 err_DI	dw	?
 err_DS	dw	?
 err_ES	dw	?
 res	dw	?
 cid	dw	?	;Computer-ID (0 fr lokal)
 pid	dw	?	;Prozess-ID (PSP)
ends

struc tSectorCacheEntry
 secnum	dd	?	;Sektor-Nummer
 count	db	?	;Anzahl Sektoren, Bit 7 = Dirty-Flag
 drive	db	?	;Laufwerk
 addr	dw	?	;Adresse im Heap (Gre notfalls via [addr-2])
ends

MAGIC_hFind	=0ACh	;Magic-Byte fr gltiges Find-Handle
MAGIC_FB_hFind	=0ADh	;dito fr Rckfallmodus

CTRL_Main	=80h	;Hauptschalter Aktivitt
CTRL_Write	=40h	;Schreibzugriffe (auer DELETE/UNLINK)
CTRL_Tilde	=20h	;Schlangen (HKLM/.../NameNumericTail)
CTRL_Tunnel	=10h	;Tunneleffekt
CTRL_ChkLnk	=08h	;Prfsummen-Verbindung
CTRL_ShLFN	=04h	;ShortName-API mit LFN (auer PWD und FindFirst/Next)
CTRL_RoBit	=02h	;Schreibschutz-Attribut fr CD-Dateien

		org	5Ch
CurSector	dd	?	;Momentan "aktiver" Sektor
ErrInfo	TErrInfo	<>	;berschreibt (im Fehlerfall) folgendes
		org	60h
FCB_Name	db	11 dup (?)
ShortName	db	13 dup (?)
;noch 8 Bytes Platz
		org	60h
DirEnt_Copy	TDirEnt	<>	;FCB-Name ist dann sowieso gleich!
;80h
longpos_s	dd	?	;wird von Locate_DirEnt (FAT) gesetzt
longpos_a	dw	?	;wird von Locate_DirEnt (FAT) gesetzt
;86h
CurPathComp	dw	?	;Momentan "aktive" Pfad-Komponente oder Maske
SearchAttr	dw	?	;Such-Attribut, enthlt im Low-Teil
	;die invertierten Attribut-Flags und im High-Teil die
	;Must-Match-Attribute. Das Attribut 88h dient (spter) dem
	;Aufsuchen gelschter Eintrge wie bei Novell-DOS
MatchPtr	dw	?	;"Virtuelle" Methode Match&Stop
;8Ch
SuchSektor	dd	?	;fr gegenseitige Suche auf Joliet-CD
	;Start-Sektor aktuelles Vrz. bei mkdir, creat und move
uppercase_table	dd	?	;Zeiger ins DOS fr Zeichen >=80h
		;Offset ist um 7Eh vermindert fr direktes XLAT
File_Flags	db	?
LFN_DirEnts	db	?	;Anzahl DirEnts beim Erstellen
;96h
num_cluster	dw	?	;Anzahl Cluster fr Verzeichnis

CD_SFN_Root	dd	?	;CD: Root-Sektor aus PVD
CD_LFN_Root	dd	?	;CD: Root-Sektor aus Joliet-SVD
CD_SFN_Cur	dd	?	;CD: Momentaner Sektor fr kurze Namen
CD_LFN_Cur	dd	?	;CD: Momentaner Sektor fr lange Namen
CD_SFN_DP	dw	?	;CD: DirEnt-Pointer ISO
CD_LFN_DP	dw	?	;CD: DirEnt-Pointer Joliet
CD_LFN_Vol	db	?	;CD: VTOC-Nummer fr Datentrgerbezeichnung
		org	98h
;98h
DPB_FAT1Sec	dd	?	;FAT: Startsektor 1. FAT
_DPB_FATLen	dd	?	;FAT: Lnge einer FAT [UNUSED]
;A0h
DPB_DirSec	dd	?	;{Sektor Hauptverzeichnis (nur FAT)}
DPB_UsrSec	dd	?	;{Sektor des 1. Clusters (mit Nr. 2)}
DPB_EndSec	dd	?	;{Letzter Sektor+1 der Partition}
DPB_Shift	db	?	;{Verschiebung fr Sektoren pro Cluster}
PFlags		db	?	;Programm-Steuerflags
DPB_Drive	db	?	;{Drive Parameter Block: Laufwerk, 0=A}
DriveType	db	?	;{Schalter fr Festplatten-Zugriffsart}
DT_BigDos	=1		;erweiterte INT25/26-Schnittstelle
DT_DrvPar	=2		;Wir haben Laufwerks-Info
DT_FAT32	=4		;grere nderungen (kein INT25/26)
DT_FAT16	=8		;wegen FAT-Zugriff
DT_CDFS		=16		;genauer: Joliet, gleichzeitig BIGDOS
DT_SmartOS	=32		;wenn das Betriebssystem den LFN lscht...
DT_Locked	=64		;wenn geschrieben wurde (MS-DOS7+)
DT_Dirty	=128		;Sektor muss geschrieben werden!
;In Abhngigkeit von DriveType arbeitet das Programm genaugenommen
;in 3 Modi (mehr sind nicht allgemein machbar, vielleicht noch RockRidge?):
;* FAT-Modus fr Disketten und Festplatten
;* Joliet fr Windows9x-typische CDs
;* Rckfallmodus fr alles andere: LFN_FindFirst u.a. wird mittels "normaler"
;  Funktionen nachgebildet (wie es sonst jedes Programm zu Fu tun mte,
;  und das ist beim Programmieren nervenaufreibend, verflixte DTAs und
;  das erweiterte Globbing)
;Sehr nett wre ja noch ein "Netzwerk-Modus", bspw. per NFS oder DOS-Samba,
;aber wer liefert mir den Quelltext?
;Weiterhin ein "lfnbk"-Modus, mit Abbildung der langen Dateinamen ber
;eine regulre Hilfsdatei
PF_Follow	=bit 0		;Sektor-Verfolgung nach DirScan
PF_LFN_Input	=bit 2		;LongName-API Namensinterpretation
;B0h
shortbuffer	db	3+64+13 dup (?)	;Puffer fr kurze 8.3-Dateinamen
;100h
LastAccessTime	dw	?

		org	100h
		jmp	transient
ctrl0		db	0DAh		;8 Ein/Aus-Schalter
		;Bit7: global ein/aus
		;Bit6: Schreiben e/a
		;Bit5: Schlangen e/a
		;Bit4: Tunneleffekt e/a
		;Bit3: Prfsummen-Link e/a
		;Bit2: ShortName-API mit LFN

proc NewInt21 far	;Neue INT21-Routine
		pushf
		cmp	ax,REQfunc      ;Installationscheck?
		jne	I21cont
		cmp	dx,REQcode
		jne	I21cont
		mov	ax,ANScode
		mov	dx,cs
		popf
		iret
I21cont:
		test	[cs:ctrl0],CTRL_Main
		jz	@@isrend
		cmp	ah,71h		;LFN-Funktionen?
		je	@@yes_lfn
		cmp	ah,3Ah		;rmdir?
		je	@@yes_sfn	;dann OldInt21 rufen!
		cmp	ah,41h		;unlink?
		je	@@yes_sfn	;dann OldInt21 rufen!
		cmp	ah,56h		;move?
		je	@@yes_sfn
		cmp	ah,4Eh		;normales FindFirst
		je	@@filter0F
		cmp	ah,4Fh		;normales FindNext
		je	@@filter0F
		cmp	ah,11h		;FCB-FindFirst
		je	@@filt_FCB_11
		cmp	ah,12h		;FCB-FindNext
		je	@@filt_FCB_12
;Fr die Tunnelfunktion mssen folgende weitere APIs
;angezapft werden (neben dem schon angezapften RENAME=56h):
;MKDIR=39h (nur beim Tunneln MIT Verzeichnissen)
;CREAT=3Ch (SFN darf nicht bereits vorher existieren)
;CRNEW=5Bh (erzeuge NEUE Datei)
;EXT_O=6Ch (sinnig nur wenn Bit 4 von DL gesetzt, SFN darf nicht existieren)
;Fr LFN-auf-SFN-API (LoSA) mssen folgende weitere UPs angezapft werden:
;CRTMP=3Ah (hier nur Pfad-Auswertung! Dateiname bleibt kurz)
;EXEC =4Bh
@@isrend:	popf
		JMPF			;jmp far
OldInt21	dd	?

@@filter0F:	;bei FindFirst/FindNext Rckgaben mit Attribut 0Fh auswerfen
		popf
		call	sfn_find
		jmp	@@iret

@@filt_FCB_11:	call	sfn_find_FCB
		mov	ah,11h		;zurckstellen (knnte 12h sein)
		jmp	@@RetFcb0

@@filt_FCB_12:	call	sfn_find_FCB
@@RetFcb0:	jmp	@@RetFcb

@@yes_lfn:	INT3
@@yes_sfn:
		push	fs ds es	;bp+14h .. bp+10h
		pusha		;ax=bp+0Eh, cx..dx..bx..sp..bp..si..di=BP+0
;		 push	ax
;		  mov	al,1
;		  call	ChangeInDosFlag
;		 pop	ax
		 mov	bp,cs
		 mov	ds,bp
		 mov	es,bp
		 mov	bp,sp
		 push	eax		;High-Teile retten fr PKZIP
		 pop	ax
		 push	edx
		 pop	dx
		 cld
		 mov	fs,[Client_DS]	;hufig bentigt
		 shr	[byte LOW Client_Flags],1	;CY ausschieben
		 cmp	ah,71h
		 je	@@yes_long
		 ;die beiden Lsch-APIs sind sowieso fast gleich
		 mov	al,[ctrl0]
		 mov	[PFlags],al	;PF_LFN_Input-Bit kopieren
		 call	sfn_unlink	;auch: rmdir und move (jeweils DS:DX)
		 jmp	@@no_func
@@yes_long:
		 BSET	[PFlags],PF_LFN_Input
		 mov	di,ofs verteiler
		 call	case
		 mov	ax,7100h	;fr "nicht untersttzt"
		 jc	@@no_func
		 inc	[counter_i2171]
		 call	[word di]
@@no_func:	 jnc	@@no_ax
		 cmp	ah,99h		;"eigener" Fehler?
		 jnz	@@k		;nein, Extended Error schon gesetzt
					;oder bei AH=71h nicht ntig
		 call	SetExtError
@@k:		 mov	[Client_AX],ax
		 stc
@@no_ax:	 rcl	[byte LOW Client_Flags],1	;CY einschieben
		 push	dx
		 pop	edx
		 push	ax
		 pop	eax
;		 mov	al,-1
;		 call	ChangeInDosFlag
		popa
		pop	es ds fs
@@RetFcb:	popf			;Flags poppen, CY kommt heraus
		IRET		;ein weiterer sinnloser Versuch mit PKZIP
@@iret:		sti
		ret	2
endp

proc noentry_sfn_find
;D: DirEnts with attribute 0Fh (LFN designator) must be wiped out.
;   (MS-DOS 7+ and Windows NT [DOS 5] do this;
;    this is necessary for all other DOS versions)
;I: registers unchanged, _without_ BP stack frame!
;F: INT21/4E&4F alter AX even if successful! 09/01, claude.caillet@free.fr
@@rept:	popf
	mov	ah,4Fh
sfn_find:
	call	CallOld
	jc	@@e
	pushf			;don't change other flags (esp. ZF)
	 push	ax bx es
	  DOS	2Fh		;get address of DTA
	  cmp	[(TSearchRec es:bx).attr],0Fh
	 pop	es bx ax
	 je	@@rept		;next iteration makes FindNext
	popf
@@e:	ret
endp

proc sfn_find_FCB
;FU: FindFirst/FindNext via FCB muss auch gefiltert werden
;    (so ein Laster, das von der COMMAND.COM aufgebrdet wird,
;     niemand sonst verwendet diese Funktionen heutzutage.)
;    (MS-DOS 7 und Windows NT [DOS 5] filtern selbst;
;     notwendig ist diese Aktion fr alle anderen DOS-Versionen)
@@rept:	call	callold
	or	al,al
	jnz	@@err
	push	bx es
	 DOS	2Fh
	 cmp	[byte es:bx],0FFh	;Extended FCB?
	 jne	@@1			;nein, bx nicht verschieben
	 add	bx,7
@@1:	 cmp	[byte es:bx+12],0Fh
	pop	es bx
	mov	ah,12h
	je	@@rept
@@err:	ret
endp

proc SFN_AL_CallOld
;FU: Aufruf des vorherigen INT21 mit DX=Zeiger auf ShortBuffer
;    Seiteneinstiege ohne Laden von AH und DX
	mov	ah,[Client_AL]
SFN_CallOld:
	mov	dx,ofs ShortBuffer
CallOld:
	pushf
	call	[cs:OldInt21]
	ret
endp

proc SetExtError
;DOS-Fehler (fr Int21 AH=59h) setzen (fr momentanes PSP)
;Tatschlich bentigt Win95 COMMAND.COM diese Funktion!
	mov	ah,0			;alles "kleine" Fehler
	push	ax
	 mov	di,ofs ErrInfo
	 mov	dx,di
	 stosw
	 mov	cx,(SIZE ErrInfo)/2 -2
	 xor	ax,ax
	 rep	stosw			;dazwischen lauter Nullen
	 DOS	62h			;PSP ermitteln
	 xchg	bx,ax			;als letztes
	 stosw
	 DOS	5D0Ah			;Fehler setzen
	pop	ax
	ret
endp
		align	2

String_Table	dw	ofs Texte_englisch
rwrec		tRWRec	<?,1,ofs Sektor>

;Die folgende Unicode-Tabelle kann berladen werden, so werden alle
;1-Byte-per-Zeichen-DOS-Versionen korrekt untersttzt. Nicht untersttzt
;bleiben Chinesisch, Koreanisch, Japanisch und Unicode-UTF-8.
label oem_uni_tab word		;hier: Codeseite 437
	dw	00C7h, 00FCh, 00E9h, 00E2h, 00E4h, 00E0h, 00E5h, 00E7h
	dw	00EAh, 00EBh, 00E8h, 00EFh, 00EEh, 00ECh, 00C4h, 00C5h
	dw	00C9h, 00E6h, 00C6h, 00F4h, 00F6h, 00F2h, 00FBh, 00F9h
	dw	00FFh, 00D6h, 00DCh, 00A2h, 00A3h, 00A5h, 20A7h, 0192h
	dw	00E1h, 00EDh, 00F3h, 00FAh, 00F1h, 00D1h, 00AAh, 00BAh
	dw	00BFh, 2310h, 00ACh, 00BDh, 00BCh, 00A1h, 00ABh, 00BBh
	dw	2591h, 2592h, 2593h, 2502h, 2524h, 2561h, 2562h, 2556h
	dw	2555h, 2563h, 2551h, 2557h, 255Dh, 255Ch, 255Bh, 2510h
	dw	2514h, 2534h, 252Ch, 251Ch, 2500h, 253Ch, 255Eh, 255Fh
	dw	255Ah, 2554h, 2569h, 2566h, 2560h, 2550h, 256Ch, 2567h
	dw	2568h, 2564h, 2565h, 2559h, 2558h, 2552h, 2553h, 256Bh
	dw	256Ah, 2518h, 250Ch, 2588h, 2584h, 258Ch, 2590h, 2580h
	dw	03B1h, 00DFh, 0393h, 03C0h, 03A3h, 03C3h, 03BCh, 03C4h
	dw	03A6h, 0398h, 03A9h, 03B4h, 221Eh, 03C6h, 03B5h, 2229h
	dw	2261h, 00B1h, 2265h, 2264h, 2320h, 2321h, 00F7h, 2248h
	dw	00B0h, 2219h, 00B7h, 221Ah, 207Fh, 00B2h, 25A0h, 00A0h

Invalid_Lfn_Chars db	'"<|>:\/'	;7 Stck

Invalid_Chars	db	0,' .+,;=[]'	;weitere 9 Stck fr "kurze" Namen
	;An sich ist das Leerzeichen fr kurze Dateinamen erlaubt,
	;aber das LFN-API wirft Leerzeichen aus dem SFN-Alias heraus.
CD_VD_ID	db	'CD001',1,0	;Erkennung fr ISO-Volume

;Statistik-Zhler
counter_read	dw	0
counter_write	dw	0
counter_i2171	dw	0

Client_DI	equ	word bp
Client_SI	equ	word bp+2
Client_BP	equ	word bp+4
Client_SP	equ	word bp+6
Client_BX	equ	word bp+8
Client_DX	equ	word bp+0Ah
Client_CX	equ	word bp+0Ch
Client_AX	equ	word bp+0Eh
Client_ES	equ	word bp+10h
Client_DS	equ	word bp+12h
Client_FS	equ	word bp+14h
;Client_Flags	equ	word bp+16h
Client_Flags	equ	word bp+1Ch

Client_DXBX	equ	dword bp+8
Client_CXDX	equ	dword bp+0Ah	;CX=High, DX=Low, in einem Schlag
Client_AXCX	equ	dword bp+0Ch

Client_AL	equ	byte LOW  Client_AX
Client_AH	equ	byte HIGH Client_AX
Client_BL	equ	byte LOW  Client_BX
Client_BH	equ	byte HIGH Client_BX
Client_CL	equ	byte LOW  Client_CX
Client_CH	equ	byte HIGH Client_CX
Client_DL	equ	byte LOW  Client_DX
Client_DH	equ	byte HIGH Client_DX

proc Check_CDFS
	test	[DriveType],DT_CDFS	;bytefressender Befehl
	ret
endp

proc ReadSec
;{Liest einen Sektor Nummer <CurSector> nach <Sektor>, PA: CY=1:Fehler}
;Liest nur, wenn's ein neuer Sektor ist!
;PE: CurSector=Sektor-Nummer
;PA: [Sektor] gefllt mit Sektor-Daten
;    CY=1: Fehler
;VR: alle (bedeutet hier und im folgenden EAX,BX,CX,EDX,SI und DI,
;	   nicht aber DS,ES,SS,SP und BP, werden dann extra gelistet)
   mov	eax,[CurSector]
ReadSecEAX:
   mov	[CurSector],eax
   cmp	[rwrec.sect],eax
   je	@@e		;nichts tun!
   call	FlushDirty
   cmp	eax,[CD_BackupSektor]
   je	@@restore_backup
   jmp	@@make_backup
@@nobackup:
   mov	[rwrec.sect],eax
   inc	[counter_read]

	mov	al,[DriveType]
	test	al,DT_CDFS
	jnz	@@cdfs
	xor	si,si		;lesen FAT32
	mov	di,ofs int25	;lesen FAT16
	jmp	Fat_RW
@@cdfs:
   mov	eax,[CD_BackupSektor]
   cmp	eax,[rwrec.sect]
   je	@@restore_backup
   mov	bx,ofs CD_Sektor
   mov	si,[word HIGH rwrec.sect]
   mov	di,[word LOW  rwrec.sect]
   movzx cx,[DPB_Drive]
   mov	dx,1		;nur 1 Sektor!
   MUX	1508h		;MSCDEX: Sektor lesen
@@e:
   ret
@@restore_backup:
   call	Check_CDFS
   jz	@@nobackup
   xchg	[rwrec.sect],eax
   mov	[CD_BackupSektor],eax
   mov	si,ofs CD_Sektor
   mov	di,ofs CD_Backup
   mov	cx,1024		;512 DWords = 2048 Bytes
@@swap:
   mov	ax,[si]
   xchg [di],ax
   mov	[si],ax
   cmpsw		;einfach si+=2 und di+=2
   loop	@@swap
   clc
   ret
@@make_backup:
   call	Check_CDFS
   jz	@@nobackup
   push	eax
    mov	eax,[rwrec.sect]
    mov	[CD_BackupSektor],eax
    mov	cx,512
    mov	si,ofs CD_Sektor
    mov	di,ofs CD_Backup
    rep	movsd
   pop	eax
   jmp	@@nobackup
endp

proc FlushDirty
	test	[DriveType],DT_Dirty
	jz	@@e
_WriteNow:
	INT3
	push	eax
	 call	WriteSec
	pop	eax
	and	[DriveType],not DT_Dirty
@@e:	ret
endp

proc WriteNow
	call	_WriteNow
ResetDrv:
	DOS	0Dh
	ret
endp

proc WriteSec
;{Schreibt Sektor <Sektor> nach Nummer <RWRec.Sect>, PA: Fehlercode}
;PE: RWRec.sect=Sektor-Nummer
;    [Sektor] gefllt mit Sektor-Daten
;PA: CY=1: Fehler
;VR: alle
   inc	[counter_write]
	mov	si,4001h	;schreiben: Verzeichnis-Bereich FAT32
	mov	di,ofs int26	;schreiben: FAT16
	bts	[word DriveType],6	;DT_Locked
	jc	Fat_RW		;Laufwerk ist bereits gesperrt
	mov	bl,[DPB_Drive]
	inc	bl
	mov	bh,0		;LOCK LEVEL
	mov	cx,084Ah
	mov	dx,1		;fr Schreibzugriff
	DOS	440Dh		;DOS7 LOCK
	;jmp	Fat_RW
endp

proc Fat_RW
;FU: Lesen und Schreiben von/auf FAT16 und FAT32
;PE: DI=Zeiger auf Prozeduren int25 oder int26 (FAT16)
;    SI=0 fr Lesen, 4001h fr Schreiben Verzeichnis-Daten (FAT32)
;    [DPB_Drive]=Laufwerk (0=A: usw.)
;    [DriveType]=Laufwerkstyp, FAT12/16/32,BIGDOS
;    [RWRec]=Sektor,Anzahl,Speicheradresse
;VR: alle
	mov	al,[DriveType]
	test	al,DT_FAT32
	jnz	Fat32_RW
	test	al,DT_BigDos
	jnz	@@b		;{gleich zu BIGDOS}
	mov	si,ofs RWRec	;3 Bytes
	lodsw			;je 1 Byte
	xchg	dx,ax		;DX=Sektornummer
	lodsw
	lodsw
	xchg	cx,ax		;CX=Anzahl
	lodsw
	xchg	bx,ax		;DS:BX=Sektor-Adresse
	push	di
	 call	@@pu
	pop	di
	jnc	@@e
	cmp	ax,0207h	;{zu BIGDOS wechseln? lt.RBIL}
	stc
	jnz	@@e		;{nein, sonstiger Fehler}
	or	[DriveType],DT_BigDos
@@b:
	lea	bx,[RWRec]
	mov	cx,0ffffh
@@pu:	mov	al,[DPB_Drive]
	push	bp		;zumindest DR-DOS zerstrt BP
	 call	di
	pop	bp
@@e:	ret
endp

proc Fat32_RW
;FU: Lesen und Schreiben von/auf FAT32
;    [DPB_Drive]=Laufwerk
;    [RWRec]=Sektor,Anzahl,Speicheradresse
	mov	dl,[DPB_Drive]
	inc	dl
	mov	cx,0FFFFh
	lea	bx,[RWRec]
	DOS	7305h
	ret
endp

proc int25
	int	25h
	pop	bp		;{Stack korrigieren}
	ret
endp

proc int26
	int	26h
	pop	bp		;{Stack korrigieren}
	ret
endp

proc GetDrvParams pascal
uses es,si
;{Ermittelt Laufwerksparameter fr <@drive> (1=A: usw.)
; und setzt die Variablen DPB_xxx sowie DriveType, PA: DriveType<>0 wenn OK}
; Von Laufwerken >=C: erfolgt die Bestimmung nur bei neuem Buchstaben,
; bei Disketten- und CD-Laufwerken nur nach Ablauf eines TimeOuts
;PE: AL=Laufwerksnummer (0=current, 1=A:)
	sub	al,1
	jnc	@@nodef
	DOS	19h		;Akt. Laufwerk beschaffen
@@nodef:
	cmp	al,[DPB_Drive]	;gleich?
	jne	@@readin	;bei Unterschied sofort lesen
	cmp	al,2
	mov	cx,FDChangeTime
	jc	@@chktick	;Laufwerke default:, A: und B:
	call	Check_CDFS
	mov	cl,CDChangeTime
	jnz	@@chktick
@@nc0:
	jmp	@@no_change	;etwas Jump-over-Jump
@@chktick:
	push	ax
	 call	GetTick
	 sub	ax,[LastAccessTime]
	 cmp	ax,cx
	pop	ax
	jc	@@nc0
@@readin:
  push	ax
   call	CD_Done		;Dynamische Datenstrukturen aufgeben
   test	[DriveType],DT_Locked
   jz	@@no_lock
   mov	bl,[DPB_Drive]
   inc	bl
   mov	cx,086Ah
   DOS	440Dh		;MS-DOS7 UNLOCK
@@no_lock:
  pop	ax
  mov	[DPB_Drive],al
  mov	[DriveType],0
;{Abfrage fr FAT12/FAT16}
  push	ds
   mov	dl,[DPB_Drive]
   inc	dl
   DOS	32h		;{liefert AL=0:OK, FFh=Fehler}
   mov	dx,ds
  pop	ds
  or	al,al
  jnz	@@test32
  mov	es,dx
  cmp	[(tExDPB es:bx).SecLen],200h	;{Standardmige Sektorlnge?}
  jnz	@@e
  or	[DriveType],DT_DrvPar
  mov	al,[(tExDPB es:bx).Drive]
  mov	[DPB_Drive],al
  movzx	eax,[(tExDPB es:bx).UsrSec]
  mov	[DPB_UsrSec],eax
  mov	ax,[(tExDPB es:bx).ResSec]
  mov	[DPB_FAT1Sec],eax
  mov	ax,[(tExDPB es:bx).SecDir]
  mov	[DPB_DirSec],eax
  mov	cl,[(tExDPB es:bx).Shift]
  mov	ax,[(tExDPB es:bx).HiClus]	;Letzter Cluster
  cmp	ax,0FF6h
  jbe	@@ok
  or	[DriveType],DT_FAT16
  jmp	@@ok
;{Abfrage fr FAT32}
@@test32:
	call	get_dpb_32		;now with own stack frame
        jnc	@@ok

@@test_cd:
;weitere Informationen per Sektorzugriff beschaffen!
;Solange Volume-Deskriptoren einlesen, bis Schluss-Deskriptor...
  mov	cl,[DPB_drive]
  mov	ch,0		;CX=Laufwerk (hier 0=A:)
  call	CD_Init
  jnc	@@e
  mov	[DriveType],0	;kein untersttzter Laufwerkstyp
  jmp	@@e

@@ok:	;Ansprung mit CL=Shift und EAX=LastCluster
  mov	[DPB_Shift],cl
  inc	eax
  shl	eax,cl				;1.nicht-adressierbarer Sektor
  mov	[DPB_EndSec],eax
  cmp	eax,10000h
  jc	@@e
  or	[DriveType],DT_BigDos
@@e:
  call	InvalSector
  mov	[fastopen_buf],0
@@no_change:
  call	GetTick
  mov	[LastAccessTime],ax
  ret
endp

proc CD_Init	;HIER GIBTS ARBEIT
;FU: CD (als solche) und Joliet-CD erkennen
;PE: CX=Laufwerk (0=A:)
;PA: CY=1: Fehler, kein MSCDEX, kein CD-Laufwerk oder eben kein Joliet
	mov	bx,ofs CD_Sektor
	xor	dx,dx		;beginnend mit erstem Volume-Deskriptor
@@scan_vtoc:
	stc
	MUX	1505h		;"read vtoc"
	jc	@@e		;nichts zu lesen! (oder keim MSCDEX o..)
	mov	si,ofs CD_Sektor
	lodsb
	mov	di,ofs CD_VD_ID
	push	cx
	 mov	cl,7		;CH (Laufwerk) sowieso 0
	 rep	cmpsb		;gleiche ID enthalten?
	pop	cx
	stc
	jne	@@e		;falscher Aufbau der VTOC
	dec	al
	jz	@@p
	dec	al
	jz	@@s
	sub	al,0FDh		;war FFh?
	jz	@@last		;so wie's ist raus!
@@next_vtoc:
	inc	dx		;nchstes VTOC
	jmp	@@scan_vtoc
@@p:	;PVD gefunden!
	mov	di,ofs CD_SFN_Root
	mov	al,DT_DrvPar
	jmp	@@gem		;zur gemeinsamen "Datenrettung"
@@s:	;SVD gefunden!
	cmp	[dword (CD_Sektor+88)],'@/%'	;Joliet-SVD?
	jne	@@next_vtoc			;nein, diesen ignorieren
	mov	[CD_LFN_Vol],dl		;hier steht das lange Volume Label
	mov	di,ofs CD_LFN_Root
	mov	al,DT_CDFS
@@gem:
	or	[DriveType],al
	mov	eax,[dword (CD_Sektor+158)]	;Hauptverzeichnis Little Endian
	stosd
	jmp	@@next_vtoc
@@last:
	cmp	[DriveType],(DT_CDFS or DT_DrvPar) ;Beide Deskriptoren OK?
	stc
	jne	@@e
	mov	eax,19
	call	ReadSecEAX ;Nachfolgenden Sektor lesen (ist Link-Tabelle!?)
	mov	si,ofs CD_Sektor+2Ch
	lodsd			;Anzahl Verzeichnisse
	push	ax cx
	 add	ax,ax		;immer zwei Eintrge pro Verzeichnis
	 inc	ax		;die Anzahl dazu...
	 ;add	ax,ax		;vielleicht reichen WORDs oder BYTEs?
	 call	LocalAlloc
	pop	cx ax
	jc	@@e		;Speichermangel!!
	mov	[LinkTable],di
	stosb
	mov	cx,ax
	jcxz	@@e		;Temporre Notbremse
	mov	bx,ax
@@l:
	lodsd			;Joliet
	mov	[di+bx],al	;hinten
	lodsd			;ISO
	stosb			;vorn
	loop	@@l		;Link-Tabelle OK
@@e:	ret
endp

proc CD_Done
	call	Check_CDFS
	jz	@@e
	mov	di,0
	xchg	[LinkTable],di
	call	LocalFree
@@e:	ret
endp

proc get_dpb_32 pascal
;I: [DPB_Drive]=drive to get info
;O: [DPB_Drive]=physical drive (changed if SUBSTed)
;   [DriveType], [DPB_FAT1Sec], [DPB_UsrSec], [DPB_DirSec] filled with values
;   EAX=max_cluster
;   CL=shift
;   CY=1 if error
;N: change 10/01: stack storage for tExDPB, never overwrite sector data
local @@DPB:TExDpb
        push	3Dh		;61 bytes space, marker below @@dpb
        mov	di,sp
	push	es
         LD	es,ss

	 mov	cx,3Fh			;{63 Bytes}
	 mov	dl,[DPB_Drive]
	 inc	dl
	 mov	si,0F1A6h
	 stc
	 DOS	7302h		;{get extended DPB}
        pop	es
	jc	@@e		;{Fehler: kein FAT32}
	cmp	[@@DPB.SecLen],200h
        stc
	jnz	@@e		;cannot yet accept other sector sizes
	or	[DriveType],(DT_FAT32 or DT_BigDos or DT_DrvPar)
				;{FAT32 ist immer BigDos}
	mov	al,[@@DPB.Drive]
	mov	[DPB_Drive],al
	movzx	eax,[@@DPB.ResSec]
	mov	[DPB_FAT1Sec],eax
	mov	eax,[@@DPB.first_sector]
	mov	[DPB_UsrSec],eax
;here bugfix 10/01: root directory is not always at cluster 2!
	mov	cl,[@@DPB.Shift]
	mov	eax,[@@DPB.root_cluster]
        sub	eax,2
        shl	eax,cl
	add	eax,[DPB_UsrSec]	;should CLC
	mov	[DPB_DirSec],eax
	mov	eax,[@@DPB.max_cluster]
@@e:	ret
endp

proc InvalSector
;FU: Gelesenen Sektor-Inhalt fr ungltig erklren
;    (weil Schreibzugriff auf Verzeichnis erfolgte u..)
	mov	[rwrec.sect],-1		;"falscher Sektor" laden
	ret
endp


;Ein bisschen Warten ist unter NT erforderlich; auerdem mu die Zeit
;beim Zugriff auf wechselbare Medien (A:, B: und CD-Laufwerke)
;erfasst werden...
proc GetTick
	push	ds
	 push	40h
	 pop	ds
	 mov	ax,[6Ch]	;55-ms-Timer abfragen (Aufwrtszhler)
	pop	ds
	ret
endp

proc WaitTick
;FU: Warten in 55-ms-Schritten, Aufruf von Idle-Interrupts
;PE: CX=Wartezeit
;VR: AX,DX
	call	GetTick
	xchg	dx,ax
@@l:	int	28h		;DOS Idle Interrupt
	MUX	1680h		;Windows Idle Interrupt (auch NT?)
	call	GetTick
	sub	ax,dx
	cmp	ax,cx
	jc	@@l
	ret
endp

proc strcpy
	lodsb
	stosb
	or	al,al
	jnz	strcpy
	ret
endp

proc fstrcpy pascal
;fast normale strcpy-Funktion, erwartet cld, verndert keine Register
;liefert in AX Anzahl kopierter Zeichen (ohne Null), also strlen
arg @dst:dword,@src:dword
uses ds,es,si,di
	lds	si,[@src]
	les	di,[@dst]
	call	strcpy
	lea	ax,[si-1]
	sub	ax,[word LOW @src]	;Anzahl Zeichen
	ret
endp

File_Flag_Wildcards	=01h		;? oder * enthalten
File_Flag_Is_LFN	=02h		;s.u.
File_Flag_Has_Star	=04h		;* enthalten
File_Flag_Has_Dot	=08h		;. (nicht am Anfang) enthalten
File_Flag_DotAtEnd	=10h		;20h ist schon vergeben
File_Flag_LowerCase	=40h		;Kleinbuchstaben a-z enthalten
File_Flag_Char_High	=80h		;codeseitenabhngige Zeichen

;Ist File_Flag_Has_DotAtEnd gesetzt, mu beim LFN-Vergleich zustzlich
;geprft werden, da der LFN-Name KEINE Extension hat!!!
;(Dazu gengt es einfach, Dirent.fname[8]==' ' zu testen)
;
;Ist File_Flag_Is_LFN gesetzt, kann entweder ein langer Name vorliegen,
;oder der (vielleicht kurze) Name enthlt die Zeichen ' .+,;=[]'
;Es bedeutet, dass der Name keinesfalls als FCB-Name zu finden ist.
;Beim Erstellen mit Schlangen-Zwang ist Schlange zu setzen
;In Verbindung mit File_Flag_Has_Star bedeutet es, dass der Win32-
;Namensvergleich stattfinden muss (d.h. im Rckfallmodus muss nach
;der Suche nach *.* noch einmal getestet werden)
;
;Zustzlich zu File_Flag_Lowercase ist auch File_Flag_Char_High gesetzt,
;wenn Umlaute (also Zeichen >=80h) enthalten sind.
;Auch bei nur groen Umlauten
;legt Win9x auch in diesem Fall LFN-Eintrge an,
;um Probleme mit Codeseiten zu umgehen
;Suche nach LFN-Dateinamen deshalb bei Is_LFN und/oder Char_High
;
;Ist weder File_Flag_Lowercase noch File_Flag_Is_LFN gesetzt,
;ist bei CREATE/MKDIR/MOVE keinerlei LFN-Eintrag zu erzeugen!

proc Copy_FCB_Part_Proc
;BE: Kopiert LFN in FCB, FCB sei mit SPACE vorgefllt
;PE: SI=LFN-Zeiger
;    BX=LFN-Ende (zeigt hinter Punkt), 0 fr Ende durch ASCII-Null
;    DI=FCB-Zeiger
;    DX=FCB-Ende-Zeiger+1
;    AH=Flags (File_Flag_Has_Dot)
;    CH=0
;    DS,ES=CS
;PA: AH=weitere Flags (File_Flag_Wildcards u..) gesetzt
;VR: AX,CL,DX(nur wenn kein Dot),SI,DI
@@l2:	mov	cl,al
	call	UpCase
	or	cl,cl		;>=80h
	js	@@is_lower
	cmp	al,cl		;verndert?
	jz	@@was_upper
@@is_lower:
	and	cl,80h
	or	ah,cl		;Bit 7 setzen (lassen)
	or	ah,File_Flag_LowerCase
@@was_upper:
	stosb
Copy_FCB_Part:			;Einsprung fr Erweiterung
@@l3:	lodsb
Copy_FCB_Part_1:		;Einsprung fr Name (AL ggf. E5->05)
	cmp	al,'?'
	je	@@qm
	cmp	al,'*'		;zu Fragezeichen machen?
	je	@@star
	push	di
	 mov	di,ofs Invalid_Chars	;0,' .+,;=[]'
	 mov	cl,9
	 repne	scasb
	pop	di
	jnz	@@cp
	or	al,al
	je	@@endl
	cmp	si,bx		;auf dem (letzten) Punkt?
	je	@@endl
	or	ah,File_Flag_Is_LFN
	cmp	al,' '		;Leerzeichen ist Durchlufer
	je	@@l3
	cmp	al,'.'		;Punkt ist Durchlufer
	je	@@l3
	mov	al,'_'		;'+,;=[]' durch '_' ersetzen
@@cp:	cmp	di,dx		;haben noch Zeichen und kein Platz?
	jne	@@l2		;Noch ist Platz
	or	ah,File_Flag_Is_LFN
@@endl:	ret

@@qm:	;falls Fragezeichen: Bit setzen und weiter
	or	ah,File_Flag_Wildcards
	jmp	@@cp
@@star:	;falls Stern: einige Extrawrste
	or	ah,(File_Flag_Wildcards or File_Flag_Has_Star)
	test	ah,File_Flag_Has_Dot
	jnz	@@q0
	mov	dx,ofs FCB_Name+11	;alles mit Fragezeichen!
@@q0:	mov	al,'?'
	jmp	@@f
@@q1:	stosb
@@f:	cmp	di,dx
	jne	@@q1
	jmp	@@l3		;zur Auswertung von File_Flag_Is_LFN
endp

proc Gen_Alias pascal
;Alias-Generierung, ersetzt Int21/AX=2900h
;Eine "Erweiterung" ist definiert als der String hinter dem letzten Punkt,
;welcher nicht in einer Kette am Anfang stehender Punkte ist, also
;".ab" oder "..exe" enthalten keine "Erweiterungen"
;
;TRUENAME mu schon dafr sorgen, da:
;- nachlaufende Leerzeichen und Punkte entfernt sind
;- max. 1 Punkt am Ende verbleibt, wenn davor ein "*" ist
;- Pfad-Trenner zusammengefasst zu '\' sind
;- keine ungltigen LFN-Zeichen enthalten sind
;- der Fall "xx*.*" bereits zusammengefasst zu "xx*" ist
;  (LFN "xx*.*" -> LFN "xx*" UND kein Dot UND FCB "xx?????????")
;
;Am Ende wird auch der lange Dateiname modifiziert, und zwar falls
;blabla*.  --> blabla* mit gesetztem Bit File_Flag_DotAtEnd
;
;Hier werden (noch) keine Schlangen zugesetzt, das macht Poke_Number...
;Setzt erstes Zeichen im FCB auf 05h wenn E5h

;PE: SI=Pfad-Komponente
;    DS,ES=CS
;PA: FCB gefllt
;    Pfad-Komponente ggf. modifiziert, Null-terminiert
;    SI=nchste Pfad-Komponente
;    [File_Flags]=File_Flags
;    [CurPathComp]=momentane Pfad-Komponente
;VR: AX,BX,CX,DX,SI
uses di
	mov	[CurPathComp],si
	;FCB lschen
	mov	di,ofs FCB_Name
	mov	cx,6		;CH bleibt 0
	mov	ax,'  '
	rep	stosw		;das Byte zuviel macht nichts

	xor	bx,bx
	;letzten nicht-ersten Punkt suchen
@@l1:	lodsb
	or	al,al
	jz	@@ende
	cmp	al,'\'
	jz	@@end
	cmp	al,'.'		;Punkt am Anfang (".login" o..)
	je	@@l1		;zhlt nicht als Erweiterung!
@@l2:	lodsb
	or	al,al
	jz	@@ende
	cmp	al,'\'
	jz	@@end
	cmp	al,'.'		;Punkt am Ende?
	jne	@@l2
	or	ah,File_Flag_Has_Dot
	mov	bx,si		;potentieller Ext-Zeiger (hinter Punkt)
	jmp	@@l2
@@end:	;Backslash erreicht
	mov	[byte si-1],0	;ordentlich terminieren
	inc	si
@@ende:	dec	si		;das ist die nchste Komponente!

	;LongName nachbearbeiten: xx*. beackern
	test	ah,File_Flag_Has_Dot
	jz	@@nicht_ackern
	;LFN-Name nachbearbeiten, wenn xx*.
	;LFN "xx*." -> LFN "xx*" UND DotAtEnd  UND FCB "xx??????___"
	cmp	[byte bx],0
	jnz	@@nicht_ackern
@@strip_point:
	mov	[byte bx-1],0
	or	ah,File_Flag_DotAtEnd
@@nicht_ackern:

	;Name in FCB kopieren
	push	si
	 mov	si,[CurPathComp]

	 mov	di,ofs FCB_Name
	 mov	dx,ofs FCB_Name+8
	 lodsb
	 cmp	al,0E5h
	 jne	@@nos
	 mov	al,05h
@@nos:	 call	Copy_FCB_Part_1	;Namensteil (8)
	 test	ah,File_Flag_Has_Dot
	 jz	@@keine_ext
	 mov	si,bx
	 mov	di,dx
	 add	dx,3
	 call	Copy_FCB_Part	;Erweiterung (3)
@@keine_ext:
	pop	si
	mov	[File_Flags],ah
	ret
endp

proc Poke_Number_Over_FCB_Name pascal
;BE: in [FCB_Name] wird die Zahl SI "eingepflanzt"
;    Evtl. verbleibende Leerzeichen werden durch Unterstriche ersetzt
;    (hier also wie WinNT, ansonsten wie Win95)
;    Es erfolgt kein Test auf SI=0
;PE: [FCB_Name] gefllt; da die Zahl sowieso nur grer wird, macht es
;    nichts, wenn da schon eine drin liegt
;    DS,ES=CS
;PA: [FCB_Name]
;VR: AX,DX
uses BX,DI
	mov	bx,10		;Zahlenbasis
	std
	mov	di,ofs FCB_Name+7
	mov	ax,si
@@l:	xor	dx,dx
	div	bx
	add	dl,'0'		;Reste entstehen von hinten!
	xchg	dx,ax
	stosb			;rcklufig!
	xchg	dx,ax
	or	ax,ax
	jnz	@@l		;nchste Ziffer
	mov	al,'~'		;...die geliebten Schlangen...
@@more:	stosb
	cmp	[byte di],' '
	mov	al,'_'
	je	@@more		;Leerzeichen plattbgeln
	cld
	ret
endp

proc Copy_Term_Spaces
;Hilfsroutine fr Copy_FCB_xxx
@@l:	lodsb
Copy_Term_Spaces_1:		;Einsprung fr modifiziertes AL
	stosb
	cmp	al,' '
	je	@@f
	mov	bx,di		;Mglicher Ende-Zeiger (vorrcken)
@@f:	loop	@@l
	mov	di,bx		;bei Trailing Spaces zurckstellen
	ret
endp

proc Copy_FCB_8P3
;Kopiert FCB-Dateiname in 8.3-Form nach DI, jetzt auch fr FCB mit Leerz.
;PE: BX=Zeiger auf Directory-Eintrag
;    ES:DI=Ziel (E5h am Anfang in '?', 05h in E5h wandelnd)
;    DS=CS (bentigt KEIN ES=DS wegen/fr ax=71A8h)
;PA: DI vorgerckt (auf die Null), String nullterminiert und ohne Backslash
;VR: AX,CX,SI,DI
	mov	si,bx
Copy_FCB_8P3_from_SI:
	push	bx
	 mov	cx,8
	 lodsb
	 mov	ah,0E5h
	 cmp	al,5		;1. Zeichen: Stellvertreter fr 0E5h
	 je	@@5
	 cmp	al,ah		;E5 sei Stellvertreter fr '?'
	 mov	ah,'?'
	 jne	@@6
@@5:	 xchg	ah,al
@@6:	 mov	bx,di		;Ein Leerzeichen vor dem Punkt zulassen
	 call	Copy_Term_Spaces_1
	 mov	al,'.'
	 stosb
	 mov	cl,3
	 call	Copy_Term_Spaces
	pop	bx
@@e:	mov	[byte es:di],0
	ret
endp


proc Pick_Sector_From_DirEnt
;PE: BX=DirEnt-Zeiger (nur FAT!)
;PA: EAX=[CurSector]=Sektor-Nummer
;VR: EAX
	xor	eax,eax
	test	[DriveType],DT_FAT32
	jz	@@1
	mov	ax,[(TDirEnt bx).ClusH]
	shl	eax,16
@@1:	mov	ax,[(TDirEnt bx).ClusL]
	;jmp	Cluster2Sector
endp

proc Cluster2Sector
;PE: EAX=Cluster-Nummer
;PA: EAX=[CurSector]=[SuchSektor]=Sektor-Nummer
;VR: CL
	or	eax,eax
	jz	@@rootdir
	mov	cl,[DPB_Shift]
	sub	eax,2
	shl	eax,cl	;Cluster->Sektor
	add	eax,[DPB_UsrSec]
	cmp	eax,[DPB_EndSec]	;berlaufprfung!?
	cmc
	jmp	_set_cur_and_such
@@rootdir:
_set_root_sector:
	mov	eax,[DPB_DirSec]
_set_cur_and_such:
	mov	[SuchSektor],eax
	mov	[CurSector],eax
	ret
endp

proc Cluster2FAT
;FU: Ldt zum Cluster EAX die FAT in den Puffer und stellt einen
;    Zeiger zur Verfgung (bei FAT12 muss ggf. ein weiterer Sektor
;    nachgelesen werden!)
;PE: EAX=Cluster-Nummer (2=erster Cluster)
;PA: EAX=Sektor-Nummer in 1. FAT
;    BX=Adresse FAT-Eintrag
;    DL Bit 0 = High-Nibble-Bit fr FAT12
;VR: EAX,BX,EDX
	xchg	edx,eax
	mov	ah,3		;Nibbles pro FAT-Eintrag
	mov	al,[DriveType]
	test	al,DT_FAT16
	jz	@@1
	mov	ah,4
@@1:	test	al,DT_FAT32
	jz	@@2
	mov	ah,8
@@2:	movzx	eax,ah		;4 Bytes?
	;nun in EAX Nibbles pro Cluster-Eintrag
	mul	edx		;EDX:EAX=Nibble-Nummer

	mov	bx,ax
	and	bx,03FFh	;%1024=Nibble-im-Sektor
	shrd	eax,edx,10	;/1024=Sektor-Nummer
	add	eax,[DPB_FAT1Sec]
	push	eax bx cx
	 call	ReadSecEAX
	pop	cx bx eax
	jc	@@e
	mov	dl,bl		;letztes Bit retten
	shr	bx,1		;Nibble->Byte
	add	bx,ofs Sektor
@@e:	ret
endp

proc Alloc_Cluster	;NOT TESTED
;FU: Clusterkette verlngern, neues Cluster lschen
;PE: ???
;PA: [sektor] geladen mit erstem Sektor des neuen Clusters
;    BX=Sektor-Zeiger
;    CY=1 bei Fehler (Festplatte voll o..)
;VR: [longname]-Puffer zerstrt
	mov	eax,[SuchSektor]
	sub	eax,[DPB_UsrSec]
	jc	@@e	;geht nicht im Hauptverzeichnis! (auer FAT32)
;Cluster-Kette des momentanen Vrz. kreuzverketten und verlngern!
	;Datei erzeugen und schlieen
	mov	eax,[dword ShortBuffer]	;Laufwerksbuchstabe:\
	mov	di,ofs longname
	mov	dx,di
	stosd
	dec	di
	mov	si,di		;SI fr Datei->FCB
	mov	ax,5A00h
	stosb
	mov	cx,6		;system, hidden
	DOS			;Temporre Datei erzeugen
	jc	@@e		;ging voll daneben!
	xchg	bx,ax
	DOS	3Eh		;Datei schlieen
	jc	@@e		;hm!
	call	ResetDrv
	;Datei aufsuchen
	mov	di,ofs longname+16
	DOS	2900h
	mov	eax,[DPB_DirSec]
	call	ReadSecEAX
	mov	bx,ofs Sektor
@@find_loop:
	mov	di,ofs longname+17
	call	Is_FCB_Equal_DI
	jz	@@found
	call	Next_DirEnt
	jnc	@@find_loop
	jmp	@@e
@@found:
	;DirEnt modifizieren
	movzx	eax,[num_cluster]
	mov	cl,[DPB_Shift]
	add	cl,9
	shl	eax,cl		;EAX=Bytes Verzeichnis
	shl	eax,9
	mov	[(TDirEnt bx).fsize],eax
	mov	eax,[SuchSektor]
	sub	eax,[DPB_UsrSec]
	shr	eax,cl		;Cluster draus
	add	eax,2
	mov	[(TDirEnt bx).ClusL],ax
	ror	eax,16
	mov	[(TDirEnt bx).ClusH],ax
	push	bx
	 call	WriteNow
	 jc	@@unhook
	;Datei ffnen, verlngern und schlieen
	 DOS	3D02h		;zum Schreiben ffnen
	 jc	@@unhook
	 xchg	bx,ax
	 xor	cx,cx
	 xor	dx,dx
	 DOS	4202h		;ans Ende seeken
	 xor	ax,ax
	 mov	di,ofs Sektor
	 mov	dx,di
	 mov	cx,100h
	 rep	stosw		;Sektor lschen
	 call	InvalSector

	 mov	di,1
	 mov	cl,[DPB_Shift]
	 shl	di,cl
	 mov	cx,200h		;sektorweise
@@wr_loop:
	 DOS	40h		;schreiben
	 jc	@@do_close
	 cmp	ax,cx
	 jc	@@do_close
	 dec	di
	 jnz	@@wr_loop	;wenn CY=0 und Z=0 springen
@@do_close:
	 adc	si,si
	 DOS	3Eh
@@unhook:
	 adc	si,si		;CY einschieben
	;Datei hart lschen (Cluster-Kette nicht freigeben)
	 call	ReadSec
	pop	bx
	mov	[byte bx],0E5h	;einfach lschen
	call	WriteNow
@@e:	ret
endp

proc Calc_Next_Cluster pascal
;Berechnung fr Next_Sektor, liest die FAT ein
;PE: EAX=(vorhergehender) Sektor (gerechnet ab UsrSec)
;    CL=Shift
;PA: EAX=nchster Sektor (erster Sektor des nchsten Clusters, ab UsrSec)
;    CY=1: Ende der Cluster-Kette, EAX=Cluster-Nr.
;VR: alle, [Sektor]-Inhalt zerstrt
	shr	eax,cl
	add	eax,2		;EAX ist nun CLUSTER
	call	Cluster2FAT
	jc	@@e
	mov	eax,[bx]
	mov	dl,[DriveType]
	test	dl,DT_FAT32
	jnz	@@3
	movzx	eax,ax
	test	dl,DT_FAT16
	jnz	@@3a
;dicke Extrawurst fr FAT12: Nachlese 2.Sektor, falls bx am Ende
	cmp	bx,ofs SektorEnde-1
	jnz	@@4
	inc	[CurSector]
	pusha
	 call	ReadSec
	popa
	jc	@@e
	mov	ah,[Sektor]	;2. Byte vom Anfang nachlesen
@@4:	test	dl,1		;Nibble-Bit gesetzt?
	jnz	@@5
	shr	ax,4
@@5:	and	ax,0FFFh
	cmp	ax,0FF7h
	jmp	@@3b
@@3a:
	cmp	ax,0FFF7h
	jmp	@@3b
@@3:	;nun wieder Cluster in Sektor umrechnen
	cmp	eax,0FFFFFF7h	;die obersten 4 Bit scheinen ungenutzt!
;Also bietet FAT32 max. 256 Mega-Cluster, bei heute blichen LBA-Laufwerken
;mit 28-bit-Sektoradresse (also max. 128 GB) reicht das fr 512-Byte-Cluster
@@3b:	cmc
	jc	@@e		;Ende der Clusterkette
	cmp	eax,2
	jc	@@e		;momentaner Cluster ist frei (falsch!)
	sub	eax,2
	shl	eax,cl
@@e:	ret
endp

proc Next_Sektor pascal
;liefert nchsten Sektor der Clusterkette bzw. des Hauptverzeichnisses
;PE: [CurSector]=momentaner Sektor
;PA: [CurSector]=nchster Sektor, bereits gelesen
;    BX=Zeiger auf Sektor-Anfang
;VR: alle
	mov	eax,[CurSector]
	inc	eax
	cmp	eax,[DPB_EndSec]
	cmc
	jc	@@e		;war User-Bereich: Ende!
	sub	eax,[DPB_UsrSec];Hauptverzeichnis-Ende?
	cmc
	jz	@@e		;war Hauptverzeichnis: Ende! (mit CY=1)
	jnc	@@er		;war Hauptverzeichnis: es gibt weitere
	mov	cl,[DPB_Shift]
	mov	bx,1		;Maske bauen (low-16bit reicht)
	shl	bx,cl
	dec	bx		;0->0, 1->1, 2->3, 4->7 usw.
	test	ax,bx
	jnz	@@er		;noch im gleichen Cluster: weiter!
	dec	eax
	call	Calc_Next_Cluster
	jc	@@e		;kein nchstes Cluster: Ende!
@@er:	add	eax,[DPB_UsrSec]
	call	ReadSecEAX	;Sektor lesen
	lea	bx,[Sektor]	;Zeiger an Anfang stellen
@@e:	ret
endp


proc Next_DirEnt pascal
;PE: BX=DirEnt-Zeiger
;PA: BX=vorgerckter DirEnt-Zeiger, ggf. mit neu gelesenem Sektor
;    CY=1: kein weiterer Sektor in Clusterkette
;VR: alle
	call	Check_CDFS
	jnz	@@cd
	add	bx,32		;Gre von DirEnt
	cmp	bx,ofs SektorEnde
	cmc
	jc	Next_Sektor	;CY durchreichen
@@e:	ret			;noch im gleichen Sektor: OK
CD_Next_DirEnt:
@@cd:	;test	[(TCD_DirEnt bx).flags],80h	;folgende?
	;stc
	;jz	@@e		;keine weiteren! (klappt nicht!!)
	add	bl,[(TCD_DirEnt bx).r]
	adc	bh,0
	cmp	bx,ofs CD_SektorEnde
	cmc
	jnc	@@e
	inc	[CurSector]	;hier keine FAT-rgernisse!
	call	ReadSec
	mov	bx,ofs CD_Sektor
	ret
endp

proc upcase
;konvertiert AL in Grobuchstaben, auch fr >=80h
;fr Dateinamensvergleich bei LFN
	cmp	al,80h
	jnc	@@a80
	cmp	al,'a'
	jb	@@1
	cmp	al,'z'
	ja	@@1
	bres	al,bit 5
@@1:	ret
@@a80:	push	ds bx
	 lds	bx,[uppercase_table]
	 xlat
	pop	bx ds
	ret
endp

proc Globbing
;FU: Dateinamen-Vergleich mit Suchmaske, OHNE Beachtung des Flags
;    File_Flag_DotAtEnd (d.h. die Maske habe hier kein Punkt am Ende!)
;PE: SI=Maske
;    DI=Name
;    DS,ES=CS
;PA: CY=0 bei Treffer
;VR: AX
@@r:	push	si di
@@l:	 lodsb			;Maske
	 mov	ah,[di]		;Name
	 or	al,al
	 jnz	@@1
	 cmp	al,ah		;Auch Null? CY=1 wenn ah<>0! (Stringenden
				; fallen nicht zusammen!)
	 jmp	@@e		;okay oder auch nicht!
@@1:
	 cmp	al,'*'
	 jnz	@@2
@@3:	 call	@@r		;rekursiv!
	 jnc	@@e
	 xor	al,al
	 scasb
	 jc	@@3
	 jmp	@@f		;Fehler
@@2:
	 inc	di
	 or	ah,ah
	 jz	@@f
	 cmp	al,'?'
	 jz	@@l
	 call	UpCase
	 xchg	ah,al
	 call	UpCase
	 cmp	al,ah
	 jz	@@l
@@f:	 stc
@@e:	pop	di si
	ret
endp

proc GlobbingEx
;FU: wie Globbing, testet jedoch auch noch bei Treffer, ob bei
;    File_Flag_DotAtEnd der Name keine Erweiterung hat
;    (Der Trick, im FCB das erste Zeichen der Erweiterung zu testen,
;     klappt bei CDs nicht, oder man msste da erst nach FCB konvertieren)
;PE: SI=Name (umgekehrt als bei Globbing!!)
;    [CurPathComp]=Maske (immer ohne '.' am Ende)
;    [File_Flags]=Punkt-Merker "File_Flag_DotAtEnd"
;    DS,ES=CS
;PA: Z=1 bei Treffer
;    CY=0 (immer)
;VR: AX,DI(=Maske)
	mov	di,[CurPathComp]
	xchg	si,di
	call	Globbing
	xchg	si,di
	jc	@@nc2z		;wenn kein Treffer
	test	[File_Flags],File_Flag_DotAtEnd
	jz	@@nc2z		;OK, Treffer ohne DotAtEnd
	push	si		;Hat Name eine Erweiterung?
@@1:	 lodsb
	 cmp	al,'.'		;Fhrende Punkte zhlen nicht
	 je	@@1
@@l:	 or	al,al
	 jz	@@raus		;mit CY=0: keine Erweiterung: Treffer!
	 lodsb
	 cmp	al,'.'
	 stc
	 jne	@@l		;sonst mit CY=1: Erweiterung: kein Treffer!
@@raus:	pop	si
@@nc2z:	mov	al,0
	adc	al,al		;Umwandlung NC->Z
	ret
endp


proc CD_Uni2Oem
;Konvertiert Unicode-Zeichen zu OEM-Zeichen anhand der oem_uni_tab
;PE: AX=Unicode-Zeichen
;PA: AL=Oem-Zeichen
;VR: AL
	xchg	ah,al
Uni2Oem:
	cmp	ax,80h
	jc	@@e
	push	di cx
	 lea	di,[oem_uni_tab]
	 mov	cx,80h
	 repne	scasw
	 jnz	@@u
	 mov	al,0FFh
	 sub	al,cl	;7F->80, 7E->81 usw. 0->FF
	 jmp	@@ue
@@u:	 mov	al,'_'	;nicht konvertierbares Zeichen
@@ue:	pop	cx di
@@e:	ret
endp

proc Oem2Uni
;FU: konvertiert OEM-Zeichen in Unicode
;PE: AL=Oem-Zeichen
;PA: AX=Unicode-Zeichen
;VR: EAX
	movzx	eax,al
	cmp	al,80h
	jc	@@e
	mov	ax,[oem_uni_tab-100h+eax*2]
@@e:	ret
endp

proc Copy_Uni_Oem
;PE: SI=Unicode-Zeichenkette
;    DI=Oem-Zeichenpuffer
;    CX=Anzahl Zeichen
;    DS,ES=CS
;PA: SI,DI vorgerckt
;VR; AX,CL
@@l:	lodsw
	call	Uni2Oem
	stosb
	loop	@@l
	ret
endp

proc Copy_Oem_Uni
;Kopiert CX OEM-Zeichen in Unicode-Puffer
;Zumindest WindowsNT erfordert FFFF-Eintrge nach einer terminierenden
;0000, deshalb arbeitet CH als Ende-Merker zum nchsten Aufruf
;PE: SI=Oem-Zeichenkette
;    DI=Unicode-Zeichenpuffer
;    CX=Anzahl Zeichen (CH=FFh: CL=Anzahl FFFF-Zeichen)
;    DS,ES=CS
;PA: SI,DI vorgerckt (SI bis max. hinter die Null)
;VR: AX,CX=0 (normal) oder CX=FFFF (Ende erreicht)
	xor	ax,ax		;auch als Vorbereitung fr FFFF
	inc	ch
	jz	@@f		;war FF
	dec	ch
@@l:	lodsb
	call	Oem2Uni
	stosw
	or	ax,ax
	loopnz	@@l
	jne	@@e
@@f:	dec	ax		;=FFFF
	rep	stosw
	dec	cx		;Kennung fr weitere
@@e:	ret
endp

proc calc_check
;FU: FCB-Prfsumme berechnen
;PE: SI=FCB-Zeiger
;PA: AH=Prfsumme
;VR: AX,CX=0
	mov	cx,11
	mov	ah,ch		;mit 0 vorbesetzen
@@l2:	ror	ah,1
	lodsb
	add	ah,al
	loop	@@l2
	ret
endp

proc Locate_DirEnt
;FU: von BX aus gltigen Nicht-LFN-DirEnt aufsuchen, dabei longname auffllen
;    Gelschte DirEnts werden einfach bergangen (hier noch kein Unerase)
;PE: BX=Zeiger in Sektorpuffer auf ein DirEnt oder LfnDirEnt
;    DS,ES=CS
;PA: BX=Zeiger auf DirEnt,
;    CY=1 wenn Ende
;    DL=1: LFN gltig,
;    DL=FF: LFN nur wegen Checksumme falsch (nicht wenn ausgeschaltet...)
;    [longname] gefllt mit langem Dateinamen, leer wenn DL<>1
;    [shortname] gefllt mit 8.3-Namen
;    [longpos_s] Position Startsektor LFN
;    [longpos_a] Zeiger BX in Sektor-Puffer
;VR: alle
;in der Schleife: DL=Sequenz-Nummer, DH=Prfsumme

	mov	dl,0
@@l:	mov	al,[(TLfnDirEnt bx).count]
	cmp	al,1
	jc	@@e		;Ende!
	cmp	al,0E5h
	je	@@3a		;nchste Runde, LFN-in-Aufbau lschen
	cmp	[(TLfnDirEnt bx).attr],0Fh	;LFN-Kennung?
	jne	@@exk		;BX ist OK, zeigt auf normalen DirEnt
	test	al,40h		;Letztes Stckel LFN?
	jz	@@2
	mov	dl,al
	and	dl,3Fh		;Sequenz-Nummer
	jz	@@3		;ungltig, 0
	cmp	dl,20
	ja	@@3		;ungltig, >20
	mov	eax,[CurSector]
	mov	[longpos_s],eax	;(mgliche) Adresse sichern fr's Lschen
	mov	[longpos_a],bx
	mov	dh,[(TLfnDirEnt bx).check]	;Prfsumme
@@2a:
	mov	al,13
	mul	dl
	lea	di,[longname-13]
	add	di,ax
	lea	si,[(TLfnDirEnt bx).name1]
	mov	cx,5
	call	Copy_Uni_Oem
	add	si,3
	mov	cl,6
	call	Copy_Uni_Oem
	add	si,2
	mov	cl,2
	call	Copy_Uni_Oem
	test	[(TLfnDirEnt bx).count],40h ;Letztes Stck?
	jz	@@3		;nein
	xor	ax,ax
	stosb			;terminieren!
	jmp	@@3
@@2:
	cmp	dl,2		;Sequenz noch Null oder bereits 1?
	jc	@@3a		;ungltiger LFN
	dec	dl
	and	al,3Fh
	cmp	dl,al
	jne	@@3a		;Reihenfolge falsch
	cmp	dh,[(TLfnDirEnt bx).check]	;Prfsumme gleich?
	je	@@2a		;Prfsumme gleich
@@3a:
	mov	ch,0
@@3:
	push	dx
	 call	Next_DirEnt
	pop	dx
	jnc	@@l
@@e:	ret
@@exk:	;BX zeigt auf kurzen Dateinamen, berprfung von Checksum
	cmp	dl,1
	jnz	@@nolong
	test	[ctrl0],CTRL_ChkLnk
	jz	@@e2		;Verbindung NICHT prfen
	mov	si,bx
	call	calc_check	;SI->AL
	cmp	ah,dh
	jz	@@e2
	mov	dl,0FFh
@@nolong:
	mov	[Longname],0	;auch: Eintrag lschen
@@e2:	mov	di,ofs shortname
	call	Copy_FCB_8P3
	clc
	ret
endp

proc noentry_StrIComp	;StringCompare mit UpCase
;PE: SI=Maske
;    DI=Name
;    CLD
;PA: CY=1: String DI grer als String SI
;    Z=0: Strings ungleich
;    Z=1: Strings gleich, AX=0
;    SI und DI zeigen hinter das erste ungleiche Zeichen
;    oder hinter die Null(en)
;VR: SI,DI,AX,Flags
@@2:
	or	ax,ax
	jz	@@e		;Beide Strings zu Ende
StrIComp:
	lodsb
	call	UpCase
	xchg	ah,al
	mov	al,[di]
	inc	di
	call	UpCase
	cmp	ah,al
	jz	@@2
@@e:
	ret
endp

proc Match_Attr
;Prft ob Attribut mit [SearchAttr] passt
;PE: AL=Attribut
;PA: Z=1: passt
;    CY=0 (immer)
;VR: AL
	test	al,[byte LOW  SearchAttr]
	jnz	@@e		;pat leider nicht
Match_MM_Attr:			;Einstieg: Nur Must-Match-Attribut testen
	not	al
	test	al,[byte HIGH SearchAttr]
@@e:	ret
endp

proc CD_check_updir
;FU: Ldt SI auf Name-Zeiger
;    Testet auf '.' und '..' (Lnge 1 und Name=(binr)0 bzw. (binr)1)
;PE: BX=CD_DirEnt-Zeiger
;    DI=wo der Name hin soll
;PA: CY=0: normales DirEnt,
;	AL=Lnge Name (in Bytes)
;	SI=Zeiger Name in CD_DirEnt
;	VR: SI,AL
;    CY=1: DirEnt='.' oder '..'
;	[DI] gefllt mit "." oder ".." (noch nicht nullterminiert!)
;	VR: SI,DI,AL=0
	lea	si,[(TCD_DirEnt bx).fnamelen]
	lodsb
	cmp	al,2		;Lnge 1?
	jnc	@@e
	cmp	[byte si],2	;Null oder Eins?
	jnc	@@e
	lodsb
	or	al,al		;Null?
	mov	al,'.'
	stosb
	jz	@@1
	stosb			;Zwei Punkte wenn's 1 war
@@1:	add	al,-'.'		;AL=0 und CY setzen
	;stosb
@@e:	ret
endp

proc CD_Prepare_CX
;FU: Hilfsroutine
;PE: AL=Zeichenzahl (ASCIIs oder UNICODEs)
;PA: CX=Zeichenzahl (bei Dateinamen gekrzt um 2 fr ";1"-Anhngsel)
	mov	ah,0		;gegenber CBW: Katastrophenschutz!
	xchg	cx,ax		;Zeichen-Zhler in CX
	test	[(TCD_DirEnt bx).flags],2	;Verzeichnis?
	jnz	@@e		;ja, nicht krzen!
	sub	cx,2
@@e:	ret
endp

proc CD_Longname
;Kopiert Joliet-Namen des Directory-Eintrags BX in [Longname]
;Vereinfachende Annahme: Verzeichnisse haben kein Anhngsel,
;Dateien haben immer das Anhngsel ";1" (Versionsnummer)
;PE: BX=CD_DirEnt-Zeiger
;PA: SI=ofs Longname (also fertig fr Vergleich)
;VR: AX,CX,SI,DI
	mov	di,ofs Longname
	push	di
	 call	CD_check_updir
	 jc	_termAL
	 shr	al,1		;bei CY=1 offensichtlich Fehler, ignorieren
	 call	CD_Prepare_CX
@@l:	 lodsw
	 call	CD_Uni2Oem	;hier: Motorola-Interpretation
	 stosb
	 loop	@@l
	 jmp	_terminate
endp

proc CD_Shortname
;Kopiert ISO-Namen des Directory-Eintrags BX in [ShortName]
;Da Zeichen >80h ohnehin nicht ISO-konform sind, werden sie vereinfachend
;als OEM angenommen
;Vereinfachende Annahme: Verzeichnisse haben kein Anhngsel,
;Dateien haben immer das Anhngsel ";1" (Versionsnummer), also 2 Zeichen
;PE: BX=CD_DirEnt-Zeiger
;PA: SI=ofs ShortName (also fertig fr Vergleich)
;VR: AX,CX,SI,DI
	mov	di,ofs ShortName
	push	di
	 call	CD_check_updir
	 jc	_termAL
	 call	CD_Prepare_CX
	 rep	movsb		;String einfach schaufeln
_terminate:
	 xchg	cx,ax		;effektiv AX=0
_termAL:
	 stosb			;Null-Terminierung
	pop	si
	ret
endp

proc CD_Get_Attr
;FU: Liefert DOS-Attribut fr CD-Verzeichniseintrag
;    Liefert nur die Bits DIRECTORY (10h), HIDDEN (02h) aus DirEnt
;    und READONLY (01h) aus ctrl0-Bit
;PE: BX=CD_DirEnt-Zeiger
;PA: AL=AX=Attribut
;VR: AX (AH=0)
	mov	al,[(TCD_DirEnt bx).flags]
	mov	ah,0
	shl	al,6
	add	ax,ax		;DIR-Bit einschieben
	shl	ah,2		;dazwischen 2 Bit Luft
	add	ax,ax		;HIDDEN-Bit einschieben, jetzt AL=0
	test	ah,8		;Directory?
	jnz	@@1		;niemals schreibgeschtzt wie MSCDEX
	bt	[word ctrl0],1	;CTRL_RoBit-->CY
@@1:	xchg	ah,al
	adc	al,al		;RO-Bit einschieben (je nach Vorgabe)
	ret
endp

proc shld_proc
	shl	edx,cl
	or	dl,al
	lodsb			;gleich nchstes Element holen
	ret
endp

proc CD_Get_Time
;FU: Liefert DOS-Zeit von CD (das ist i.d.R. die Zeit der letzten nderung)
;PE: BX=CD_DirEnt-Zeiger
;PA: EAX,DL=Zeit im DOS-Format (DH=Zeitzone)
;VR: EAX,EDX
	push	si bx cx
	 lea	si,[(TCD_DirEnt bx).year]
	 mov	bx,ofs shld_proc
	 lodsb			;Jahr (seit 1900)
	 sub	al,80		;1980-1900
	 mov	cl,7
	 call	bx		;7 Bits fr's Jahr
	 mov	cl,4		;Monat 4 Bits
	 call	bx
	 inc	cl		;Tag 5 Bits
	 call	bx
	 call	bx		;Stunde auch 5 Bits
	 inc	cl		;Minute 6 bits
	 call	bx
	 shr	al,1		;Sekunde in 2-s-Schritten
	 sbb	ah,ah		;CY in AH 8x retten
	 dec	cl		;Sekunde 5 bits
	 call	bx
	 xchg	ah,al
	 and	al,100		;entweder 0 oder 100 (dezimal!)
	 xchg	edx,eax
	pop	cx bx si
	ret
endp

;Folgende Routinen fallen jmmerlich ins Wasser, falls Verzeichnisse
;in Sektoren >255 untergebracht sind.
;Dieser (recht wahrscheinlich erscheinende Fall) konnte jedoch mangels
;einer gengend komplexen CD nicht erkundet werden.
;Weiterhin ist unklar, was bei Multi-Session herauskommt...
;
;Ergebnis: die Sektorzhlung erfolgt bei Multi-Session vllig transparent,
;d.h. auf einer niedrigeren Ebene, vermutlich im CD-Laufwerk
;Die CeQuadrat Link Table ist bedauerlicherweise wirklich nur bei
;WinOnCD-erstellten CDs dabei. Ein On-The-Fly-Match-Algorithmus ist wirklich
;schwer zu schreiben, und Win9x/NT "erfinden" kurzerhand kurze Dateinamen,
;statt sich mit einem solchen Algorithmus abzuqulen...

proc SetSuchSektor_LFN
;PE: BX=DirEnt-Zeiger ISO
;PA: [SuchSektor]=EAX=zu suchender Joliet-Sektor
;VR: EAX,CX
	mov	ch,0
	jmp	_SetSuchSektor
endp

proc SetSuchSektor_SFN
;PE: BX=DirEnt-Zeiger Joliet
;PA: [SuchSektor]=EAX=zu suchender ISO-Sektor
;VR: EAX,CX
	mov	ch,1
_SetSuchSektor:
	mov	eax,[(TCD_DirEnt bx).sect]
	cmp	eax,100h
	jnc	@@e		;zu hohe Nummer zur Konvertierung
	push	di
	 mov	di,[LinkTable]
	 mov	cl,[di]
	 inc	di
	 push	cx
	  or	ch,ch		;Nachbearbeitung?
	  jz	@@1		;nein, SFN->LFN
	 pop	cx
	 mov	ch,0
	 neg	cx		;am Ende subtrahieren statt addieren
	 push	cx
	  neg	cx		;aber mit der richtigen Zahl zhlen
	  add	di,cx		;und mit dem "Hinterteil" anfangen
@@1:	  repne	scasb		;Sektor-Suche
	 pop	cx
	 jne	@@2		;nicht gefunden
	 add	di,cx		;zum ISO-Eintrag runter
	 mov	al,[di-1]
@@2:	pop	di
@@e:	mov	[SuchSektor],eax
	ret
endp

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;++ Neue, "objektorientierte" FindFirst/FindNext-Routine ++
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;Match&Stop-Routinen mit folgenden Parametern:
;PE: BX=DirEnt-Zeiger fr aktuelles DirEnt
;    [CurSector]=Aktuelle Sektornummer
;    DX=User-Daten (frei verwendbar)
;PA: CY=1: Such-Ende einleiten (AX=Fehlercode 9912h)
;    Z=1: Treffer
;    DX=User-Daten (beim nchsten Aufruf wieder aktuell)
;VR: AX,CX,DX,SI,DI (BX darf auer bei CY=1 NICHT verndert werden!)

proc Match_CD_LFN_Proc
	mov	ax,ofs CD_LongName
	jmp	Match_CD_AX_Proc
endp

proc Match_CD_SFN_Proc
	mov	ax,ofs CD_Shortname
Match_CD_AX_Proc:
	cmp	[(TCD_DirEnt bx).r],SIZE TCD_DirEnt
	jc	_match_end
	call	ax
Match_Current:
	mov	di,[CurPathComp]
	call	StrIComp
	clc			;nie Fehler:-)
_match_end:
	ret
endp

proc Match_CD_Sectorpointer_Proc
;Nicht einfach DirEnts (DX) abzhlen!
	cmp	[(TCD_DirEnt bx).r],SIZE TCD_DirEnt
	jc	@@e
	mov	eax,[SuchSektor]
	cmp	eax,[(TCD_DirEnt bx).sect]	;Treffer?
	clc
@@e:	ret
endp

proc Glob_CD_LFN_Proc
;Bug oder Feature? Unter Win9x trifft der Suchausdruck "*1" sowohl
;"Programme von 1991" (LFN) als auch "WURSTE~1" (SFN fr "Wurstegal")
;Wegen der Bereitstellung beider Namen erfordert die Funktion
;FindFirst/FindNext das stndige wechselseitige Laden zweier Sektoren,
;oder aber man gnnt sich den Luxus von 2 KB mehr RAM fr's TSR...
;Aber leider ist die Reihenfolge der DirEnts nicht zwangsweise gleich:-(,
;sodass der Aufwand, um ein DirEnt nicht zweimal zu finden, immens steigt!
;(Da ist eine Liste zu fhren, welche Sektor-Zeiger schon abgearbeitet
; sind - pro Suchlauf!, und alles dynamisch!)
;Es wre immerhin zu testen, ob Windows95 berhaupt bei CDs so "matcht"
;wie auch bei Dateien, wie oben genannt, oder ob es auch den Aufwand scheut
	mov	ax,ofs CD_Longname
	cmp	[(TCD_DirEnt bx).r],SIZE TCD_DirEnt
	jc	_match_end
	call	ax
	call	CD_Get_Attr
	call	Match_Attr
	jnz	_match_end
	jmp	GlobbingEx
endp

proc Match_LFN_Proc
;FU: Sucht fr FAT lange UND kurze Namen
;    (zur Such-Abkrzung wird bei IS_LFN nur der "lange" Name verglichen)
;    Weil lange und kurze Namen stets verschieden voneinander sind,
;    ist ein Match_SFN_Proc eigentlich unntig
	call	Locate_DirEnt
	jc	@@e		;raus bei Fehler
	cmp	dl,1
	jne	@@cmpshort
	mov	si,ofs Longname
	call	Match_Current
	jz	@@e		;Treffer!
@@cmpshort:
	test	[File_Flags],File_Flag_Is_LFN	;Abkrzung?
	jnz	@@e		;Test 8.3 wre sinnlos
	mov	si,ofs ShortName
	call	Match_Current
@@e:	ret
endp

proc Glob_LFN_Proc
;Globbing fr FAT lange UND kurze Namen (hier gleich Win95-Verhalten)
	call	Locate_DirEnt
	jc	@@e		;raus bei Fehler
	mov	al,[(TDirEnt bx).attr]
	call	Match_Attr
	jnz	@@e		;raus, kein Treffer! (CY=0)
	cmp	dl,1
	jne	@@cmpshort
	mov	si,ofs LongName
	call	GlobbingEx	;LFN-Suche
	jz	@@e		;Treffer, raus!
@@cmpshort:
	mov	si,ofs ShortName
	call	GlobbingEx	;SFN-Suche mit LFN-Syntax
@@e:	ret
endp

proc DirScan pascal
;Allgemeine Routine zum "Scannen" eines Verzeichnisses
;dank Pointer zur Match&Stop-Routine
;PE: [CurSector]=Startsektor des Verzeichnisses
;    BX=MatchProc-Zeiger (bei NextDirScan muss dieser in [MatchPtr] stehen!)
;VR: AX,BX,CX,DX,SI,DI
	mov	[MatchPtr],bx
	call	ReadSec
	jc	@@e
	mov	bx,ofs Sektor	;der DirEnt-Zeiger
@@l:	call	[MatchPtr]
	jbe	@@e		;bei CY=1 (Fehler) oder Z=1 (gefunden)
NextDirScan:
	call	Next_DirEnt
	jnc	@@l
@@e:	ret
endp

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

proc Is_FCB_Equal
;FU: Testet momentanen DirEnt mit Gleichheit zu FCB_Name
;PE: BX=DirEnt-Zeiger
;PA: Z=1 wenn gleich
;VR: DI,CX
	lea	di,[FCB_Name]
Is_FCB_Equal_DI:
	mov	si,bx		;leider ist SMART zu doof
	mov	cx,11
	repe	cmpsb
	ret
endp

proc Append_Backslash
	mov	ax,'\'	;Backslash und Null
	stosw
	dec	di
	ret
endp

proc Make_Truename pascal
;DE: Kopiert DOS-Dateinamen in <longbuffer> und macht dabei ein TRUENAME:
;    * holt KEINE Laufwerksdaten
;    * ermittelt ggf. das aktuelle Verzeichnis
;    * lst ..-Referenzen auf
;    * schneidet nachlaufende Punkte und Leerzeichen von Komponenten ab,
;      auer bei "*." am Ende
;    * wandelt '/' in '\'
;    * fasst mehrere '\' '/' zusammen zu einem
;BUG: interpretiert Netzwerkpfad nicht
;BUG: interpretiert [PFlags]:PF_SFN_Input (noch) nicht
;
;PE: FS:SI=Quelladresse, CLD
;PA: <longbuffer> gefllt mit TRUENAME entspr. Int21/7160/CL=0
;    CY=1 bei Fehler
	mov	di,ofs longbuffer

	cmp	[byte fs:si+1],':'
	jne	@@NoDrv
	segfs	lodsw		;gleich si um 2 vorrcken
	call	upcase
	sub	al,'A'
	cmp	al,26
	jnc	@@err3		;kein Buchstabe!
	jmp	@@havedrv
@@NoDrv:
	DOS	19h
@@havedrv:
	inc	al
	mov	dl,al		;DL=Laufwerk (1=A) fr GetCurDir
	mov	ah,':'
	add	al,40h
	stosw			;Laufwerk ist nun da

	mov	al,[fs:si]
	cmp	al,'\'
	jz	@@root		;kein aktuelles Verzeichnis holen!
	cmp	al,'/'
	jz	@@root

	mov	al,'\'
	stosb
	xchg	si,di
	DOS	47h		;Aktuelles Vrz. nach <longbuffer>
	xchg	di,si
	jc	@@err3

	mov	al,0
	cmp	[di],al		;leer? (Ist Hauptverzeichnis?)
	jz	@@noseek
	mov	cx,64
	repne	scasb		;Terminierende Null suchen
	dec	di		;AUF die Null
	dec	si
@@root:
	inc	si
@@new_name:
	mov	al,'\'
	stosb			;und Backslash anhngen
@@noseek:
@@l1:	segfs	lodsb
	or	al,al
	jz	@@e
	cmp	al,'\'
	jz	@@l1
	cmp	al,'/'
	jz	@@l1		;mehrfache Slash/Backslash zusammenfassen
	cmp	al,'.'
	jz	@@scandot
@@l3:	;normaler Name
	cmp	di,ofs longbuffer_end-1
	jnc	@@err3
	stosb

	segfs	lodsb
	push	di
	 mov	di,ofs Invalid_Lfn_Chars
	 mov	cx,8
	 repne	scasb
	pop	di
	jnz	@@l3
	or	al,al
	jz	@@l2
	cmp	al,'\'
	jz	@@l2
	cmp	al,'/'
	jnz	@@err2
@@l2:	;Ende erreicht, rckwrts Punkte und Leerzeichen lschen
	;sowie *.* zu * verkrzen
	dec	di
	mov	ah,[di]
	cmp	ah,'.'
	je	@@tstar		;noch auf *. testen!
	cmp	ah,' '
	je	@@l2		;Leerzeichen sofort weg!
	cmp	ah,'*'		;*.* -> *
	je	@@t2		;zwei Vorgngerzeichen testen
	cmp	ah,'\'
	je	@@err3		;nur Leerzeichen gewesen: Fehler!
@@t2e:	inc	di
@@t2f:	or	al,al
	jnz	@@new_name
	jmp	@@e
@@t2:	cmp	[word di-2],'.*'
	jne	@@t2e
	dec	di		;nur 1x abschneiden
	jmp	@@t2f
@@tstar:;nachlaufenden Punkt (noch) NICHT abschneiden, wenn "*." am Ende
	cmp	[byte di-1],'*'	;Stern davor?
	jnz	@@l2		;nein, Punkt kann (und muss) weg
	jmp	@@t2e		;ja, dieser Punkt bleibt, und Ende

@@scandot:
;Name, der mit '.' anfngt, knnte nur aus Punkten bestehen, und ist
;dann aktuelles, bergeordnetes usw. Verzeichnis!
	mov	cx,0		;Punkte-Zhler
	mov	bx,si		;Startpunkt retten
@@scn:	inc	cx
	segfs	lodsb
	cmp	al,'.'
	je	@@scn
	cmp	al,'\'
	je	@@escan
	cmp	al,'/'
	je	@@escan
	or	al,al
	je	@@escan
	mov	al,'.'
	mov	si,bx
	jmp	@@l3		;ist ein "normaler" Name
@@escan:;Ende einer Punktkette erreicht, in CX=Anzahl Punkte

@@rmb:	dec	di
	cmp	[byte di],'\'
	jne	@@rmb
	cmp	di,ofs longbuffer+2
	jz	@@atroot
	loop	@@rmb
	or	al,al
	jnz	@@new_name
	jmp	@@e
@@atroot:
	cmp	cx,1
	jnz	@@err3
	or	al,al
	jnz	@@new_name
	inc	di		;!!!, Backslash stehenlassen!
@@e:	stosb
	;und als letztes alles vor dem letzten Backslash upcasen
	ret
@@err3:	stc
	mov	ax,9903h	;AH=99 als Kennung fr SetErrorInfo
	ret
@@err2:	stc
	jmp	SetFileNotFound
endp

proc start_stuff
;das langweilige TRUENAME und Laufwerksparameter beschaffen...
;PA: CY=1: da ging was schief, AX=DOS-Fehlercode
;    CY=0 && Z=1: OK, Wurzelverzeichnis
;    CY=0 && Z=0: OK, Unterverzeichnis, TRUENAME steht in longbuffer
;    SI=longbuffer+3
;    DI=shortbuffer+3 (Laufwerk:\ schon hineinkopiert)
;    [CurSector] gefllt mit Startsektor des Hauptverzeichnisses
	call	Make_Truename
	jc	@@e
	mov	al,[longbuffer]
	sub	al,40h
	call	GetDrvParams		;egal was dabei rauskommt!
	mov	si,ofs longbuffer
	mov	di,ofs shortbuffer
	movsd				;Laufwerk:\NULL
	dec	si			;bleiben im Ziel stehen
	dec	di
Set_Root:
;"Current"-Sektor(en) auf "Hauptverzeichnis" setzen, fr MakeLongName
	;call	reset_cache_ptr
	mov	[fastopen_ptr],ofs fastopen_buf
	or	[PFlags],PF_Follow	;immer mit Verfolgung ansetzen
	call	_set_root_sector
	call	Check_CDFS
	jz	@@nocd
	mov	eax,[CD_LFN_Root]
	mov	[CD_LFN_Cur],eax
	mov	eax,[CD_SFN_Root]
	mov	[CD_SFN_Cur],eax
@@nocd:	cmp	[byte si],0		;CY immer 0, Z setzen
@@e:	ret
endp

proc Check_Follow       ;lohnt erst ab 4 Aufrufen!
	test	[PFlags],PF_Follow	;bytefressender Befehl, leider!
	ret
endp
proc Reset_Follow
	and	[PFlags],not PF_Follow	;bytefressender Befehl, leider!
	ret
endp

proc same_stuff
;fr file_locate und path_locate
;Funktioniert auch im Rckfallmodus; da wird einfach der Dateiname in FCB_Name
;nach ShortBuffer (DI) kopiert, d.h. da wird ein echter 8.3-Name draus
;PE: PF_Follow=0: Cache umgehen und Sektor nicht "verfolgen"
;PA: CY=1 wenn nicht gefunden
;    DI=Short-Buffer-Zeiger vorgerckt (nur wenn nicht NIL gewesen)
	push	si di
	  cmp	[DriveType],1
	  jc	@@fallback
	  call	Check_Follow
	  jz	@@nocache		;ohne Follow nie in Cache gehen!
	  call	find_in_cache
	  jz	@@shortcut
@@nocache:
	  call	Check_CDFS
	  jnz	@@cdfs
	  mov	bx,ofs Match_LFN_Proc
	  call	DirScan
	  jc	@@e
	  call	Check_Follow
	  jz	@@catshort
	  call	Pick_Sector_From_DirEnt
	  jmp	@@catshort
@@e:	pop	di si
	mov	ax,9903h		;path not found
	ret
@@fallback:
	  mov	si,ofs FCB_Name
	  mov	di,ofs ShortName
	  call	Copy_FCB_8P3_from_SI
	  mov	[LongName],0		;nie langen Namen liefern
	  jmp	@@shortcut

@@cdfs:
	  test	[File_Flags],(File_Flag_Is_LFN or File_Flag_Char_High)
	  jz	@@test_short
	  mov	bx,ofs Match_CD_LFN_Proc
	  call	CD_Ping_DirScan
	  jnc	@@catshort		;gefunden!
@@test_short:
	  mov	bx,ofs Match_CD_SFN_Proc
	  call	CD_Pong_DirScan
	  jc	@@e			;Konsistenzfehler
@@catshort:
	  call	put_to_cache
@@shortcut:
	 pop	di
	 or	di,di
	 jz	@@skip_copy		;bei Ziel=NIL nicht kopieren!
	 mov	si,ofs ShortName
	 call	strcpy			;gewonnenen Namen nach DI (ShortBuffer)
	 dec	di
@@skip_copy:
	pop	si
	ret
endp

proc CD_LFN_Follow
	call	Check_Follow
	jz	@@1
	mov	eax,[(TCD_DirEnt bx).sect]
	mov	[CD_LFN_Cur],eax	;Joliet weiterverfolgen
@@1:	mov	[CD_LFN_DP],bx
	ret
endp

proc CD_SFN_Follow
	call	Check_Follow
	jz	@@1
	mov	eax,[(TCD_DirEnt bx).sect]
	mov	[CD_SFN_Cur],eax	;ISO weiterverfolgen
@@1:	mov	[CD_SFN_DP],bx
	ret
endp

proc CD_Ping_DirScan
;FU: Bei CDFS mu zweimal gesucht werden! Entweder von lang nach kurz
;    (Regel) oder von kurz nach lang (Sonderfall)
;PA: CY=1 fataler Fehler
;    CY=0 und Z=0: Nicht gefunden
;    CY=0 und Z=1: gefunden
	mov	eax,[CD_LFN_Cur]
	mov	[CurSector],eax
	call	DirScan
	jc	@@e
	call	CD_LFN_Follow
	mov	eax,[CD_SFN_Cur]
	mov	[CurSector],eax
	call	SetSuchSektor_SFN
	mov	bx,ofs Match_CD_Sectorpointer_Proc
	call	DirScan			;mit DX=Nummer
	jc	@@e			;Fehler! (Konsistenzfehler)
	call	CD_SFN_Follow
	call	CD_Shortname
	clc
@@e:	ret
endp

proc CD_Pong_DirScan
;PA: CY=1 fataler Fehler oder nicht gefunden
;    CY=0 gefunden
	mov	eax,[CD_SFN_Cur]
	mov	[CurSector],eax
	call	DirScan
	jc	@@e
	call	CD_SFN_Follow
	mov	eax,[CD_LFN_Cur]
	mov	[CurSector],eax
	call	SetSuchSektor_LFN
	mov	bx,ofs Match_CD_Sectorpointer_Proc
	call	DirScan			;mit DX=Nummer
	jc	@@e			;Fehler!
	call	CD_LFN_Follow
	call	CD_Longname
	clc
@@e:	ret
endp

proc file_locate
;verfolgt angegebenen Pfad bis zum Schluss
	call	start_stuff
	jc	@@e			;ist Fehler
	jz	@@e			;ist root (und OK)

@@l:	call	Gen_Alias
	call	same_stuff
	jc	@@e
	mov	ax,'\'			;Backslash und Null
	cmp	[si],ah			;Null?
	jz	@@e			;fertig gefunden!
	stosw
	dec	di
	jmp	@@l
@@e:	ret
endp

proc path_locate
;verfolgt angegebenen Pfad, aber nicht den Dateinamen
;PA: CY=1: Fehler (z.B. Pfad nicht gefunden), AX=Fehlercode
;    [ShortBuffer] gefllt mit 8.3-Pfad und abschlieendem Backslash
;    [CurPathComp]=Zeiger auf Dateiname
	call	start_stuff
	jc	@@e			;ist Fehler
	stc
	jz	@@e			;nur root ist hier auch Fehler!

@@l:	call	Gen_Alias
	cmp	[byte si],0
	jz	@@e			;fertig gefunden, in [CurPathComp]...
	call	same_stuff
	jc	@@e
	mov	ax,'\'			;Backslash und Null
	stosw
	dec	di
	jmp	@@l
@@e:	ret
endp

proc dirent_locate
;ermittelt DirEnt-Zeiger bx fr Datei
;PA: CY=1: Fehler
;    BX=DirEnt-Zeiger
;    [longpos_s]+[longpos_a]=LFN-DirEnt-Zeiger (auch bei CY=1 verndert!)
	call	path_locate
	jc	@@e
File_DirEnt_Locate:
	bt	[word File_Flags],0	;File_Flag_Wildcards
	jc	@@e			;an dieser Stelle nicht erlaubt
	call	Reset_Follow
	call	same_stuff		;jetzt ohne Cache!
SetFileNotFound:
	mov	ax,9902h		;file not found
@@e:	ret
endp

proc MakeLongName
;Erzeugt "langen" Dateinamen fr lfn_pwd und lfn_longname
;PE: SI=Zeiger auf kurzen Dateinamen (LW-Parameter schon geladen)
;    FS:DI=Ziel (langer Dateiname im Anwender-Adressraum)
;PA: CY=1: da ging was schief!
;VR: alle
	cmp	[byte si],0	;Sonderfall fr pwd und longname
	jz	@@ez		;nichts zu tun im Wurzelverzeichnis!
	call	Set_Root

@@l:	call	Gen_Alias
	push	di
	 xor	di,di		;hier: keinen "kurzen Pfad" bauen
	 call	same_stuff
	pop	di
	jc	@@e
	push	fs di
	push	ds
	mov	bx,ofs LongName
	cmp	[byte bx],1
	jnc	@@havelong
	mov	bx,ofs ShortName	;Zeiger auf kurzen Namen
@@havelong:
	push	bx
	call	fstrcpy		;Name kopieren
	cmp	[byte si],0
	jz	@@e
	add	di,ax
	mov	[word fs:di],'\'
	inc	di
	jmp	@@l
@@ez:	mov	[byte fs:di],0
@@e:	ret
endp

verteiler:	DVT	39h,lfn_mkdir	;w DS:DX
		DVT	3Ah,lfn_rmdir	;w DS:DX
		DVT	3Bh,lfn_chdir	;r DS:DX
		DVT	47h,lfn_pwd	;r DS:SI DL
		DVT	6Ch,lfn_creat	;? DS:SI    BX CX DX DI
		DVT	41h,lfn_unlink	;w DS:DX       CX SI
		DVT	43h,lfn_attr	;? DS:DX BL    CX SI DI
		DVT	4Eh,lfn_ffirst	;r DS:DX ES:DI CX SI
		DVT	4Fh,lfn_fnext	;r BX    ES:DI    SI
		DVT    0A1h,lfn_fclose	;r BX
		DVT	56h,lfn_move	;w DS:DX ES:DI
		DVT	60h,lfn_name	;r DS:SI ES:DI CX
		DVT    0A0h,lfn_volinfo	;- DS:DX ES:DI BX CX DX
		DVT    0A7h,lfn_timeconv;- DS:SI       BX CX DX
		DVT    0A8h,lfn_genshort;- DS:SI ES:DI DX
		db	0
		_CASE

;Programm-Verteiler-Tabelle fr <lfn_attr>
pvt_attr	dw	ofs attr_getattr	;via DOS
		dw	ofs attr_setattr	;via DOS
		dw	ofs attr_getphyssize
		dw	ofs attr_settimem
		dw	ofs attr_gettimem
		dw	ofs attr_settimea
		dw	ofs attr_gettimea
		dw	ofs attr_settimec
		dw	ofs attr_gettimec
;Programm-Verteiler-Tabelle fr <lfn_attr bei CDFS, nur Lesezugriffe>
cd_pvt_attr	dw	ofs attr_getattr	;via DOS
		dw	ofs cd_attr_getphyssize
		dw	ofs cd_attr_gettimem
		dw	ofs cd_attr_gettimea	;liefert 0
		dw	ofs cd_attr_gettimec	;liefert 0-0-0

;Alle Verteiler-Funktionen werden mit Stapelrahmen sowie vernderten
;Registern AX=7100h, DS=ES=CS, BP=Rahmenzeiger und DI=?? aufgerufen.
;Bei Aufruf ist das Richtungsflag gelscht (aufsteigend)
;Sie mssen in AX den Rckgabewert liefern und ansonsten auf den Stapel
;zugeifen.

proc lfn_mkdir
 INT3
	;1. Finden des LFN-Eintrags
	mov	si,dx
	call	path_locate
	jc	@@e		;Pfad nicht gefunden
	call	Check_CDFS
	jnz	@@e		;auf CD schlecht mglich:-)
	call	File_DirEnt_Locate
	jnc	@@e		;Existiert bereits: Fehler!
	;2. geeigneten, nicht bereits vorhandenen FCB-Namen ermitteln
	mov	si,1
	call	build_unique_fcb_name
	jc	@@e
	mov	dx,ofs ShortBuffer
	DOS	39h
	jc	@@e
	call	InvalSector
	;sollte an Cache angehangen werden! (hier noch nicht)
	call	ResetDrv
	;4. LFN dazubasteln
	call	install_long_filename
	jnc	@@eok
@@del:	and	[DriveType],not DT_Dirty ;Sektor doch nicht schreiben
	mov	ah,3Ah
	call	SFN_CallOld	;Verzeichnis lschen
	mov	ax,9905h	;und (spter) im Rckfallmodus arbeiten!
@@e:	stc
@@eok:	ret
endp

proc lfn_chdir
lfn_rmdir:			;Ahja, dasselbe!
	mov	si,dx		;noch unzerstrt...
	call	file_locate
	jc	__e
	jmp	SFN_AL_CallOld
endp

proc lfn_pwd
	lea	si,[ShortBuffer]
	DOS	47h
	jc	__e
	xchg	dx,ax		;Laufwerk nach AL
	call	GetDrvParams
	mov	di,[Client_SI]	;FS steht noch
	call	MakeLongName
__e:	ret
endp

;+++++++++++ 3 Unterprogramme fr LFN_Create ++++++++++++++++
proc build_unique_fcb_name
;FU: Erstellt eindeutigen FCB-Namen
;PE: [FCB_Name]=bereits vom LFN abgeleiteter kurzer Name ohne Schlange
;    [File_Flags]=Schalter fr Schlangen-Erzeugung (mit [ctrl0])
;    SI=Hint fr Schlange
;    [ShortBuffer] gefllt mit Pfad
;    DI=Zeiger ans ShortBuffer-Ende
;PA: [FCB_Name] geeignet modifiziert (garniert mit "~1" o..)
;    [Short_Buffer] voll gefllt
;    CY=1: Alias-berlauf, AX=9905h
;VR: AX,BX,CX,DX
	mov	bx,ofs FCB_Name	;Quelle fr Copy_FCB_8P3
	push	si di		;Alias-Hint und Ansatzstelle retten
	 call	Copy_FCB_8P3
	pop	di si
	mov	al,[File_Flags]
	test	al,(File_Flag_Is_LFN or File_Flag_Lowercase)
	jz	@@e		;gar nicht "typisch lang": fertig!
	test	al,File_Flag_Is_LFN
	jz	@@no_tilde	;nur wegen Kleinbuchstaben noch keine Tilde!
	test	[ctrl0],CTRL_Tilde
	jz	@@no_tilde	;nicht mit Tilde starten
@@put_tilde:
	call	Poke_Number_Over_FCB_Name
	inc	si
	push	si di		;Alias-Hint und Ansatzstelle retten
	 call	Copy_FCB_8P3
	pop	di si
@@no_tilde:
	mov	dx,ofs ShortBuffer
	DOS	4300h		;Dateiattribute holen (als Existenz-Test)
	cmc
	jnc	@@e		;nicht existent: fertig!
	cmp	si,1
	jnc	@@put_tilde	;nchster Versuch, sonst Umrundungs-Fehler
	mov	ax,9905h	;als einziger Fehlercode
@@e:	ret
endp

proc strlenp1
;FU liefert String-Lnge+1 (also Alloc-Lnge), max. 100h
;PE: ES:DI=Stringzeiger
;PA: AX=String-Lnge+1
;VR: DI,CX
	mov	ax,100h
	mov	cx,ax
	repne	scasb
	sub	ax,cx		;String-Lnge +1
	ret
endp

proc make_free_dirent_space
;FU: Freien Speicher im Verzeichnis finden bzw. bereitstellen
;PE: [CurPathComp]=ASCIIZ langer Dateiname
;    [SuchSektor]=Startcluster aktuelles Verzeichnis
;    [FCB_Name]=zu suchender kurzer Dateiname
;PA: CY=1 wenn kein freier Platz vorhanden
;    (DOS-Fehler oder Hauptverzeichnis voll oder Festplatte voll)
;    [longpos_s]=Sektornummer fr langen Dateinamen
;    [longpos_a]=Adresse in <Sektor> fr ersten DirEnt
;    [DirEnt_Copy]=Kopie des "kurzen" Verzeichnis-Eintrags
;    Verzeichnis-Eintrag gelscht (markiert) oder gelscht (geschrieben)
;    [LFN_DirEnts]=Anzahl ntiger LFN-Verzeichniseintrge
;VR: alle
	mov	di,[CurPathComp]
	call	strlenp1
	sub	ax,2		;String-Lnge -1
	mov	cl,13		;Unicode-Zeichen pro Eintrag
	div	cl		;Anzahl Eintrge in AL
	inc	al		;1..13->1, 14..26->2 usw.
	mov	[LFN_DirEnts],al
	;4.2: Freiraum suchen, dabei "eigenen" DirEnt herausrechnen
	;DH=Scan-Flags	Bit0	"eigenen" DirEnt gefunden
	;		Bit1	gengend Freiraum gefunden
	;		Bit2	Ende (00) gefunden, nur noch Freiraum suchen
	;		Bit3	Clusterketten-Ende wurde erreicht
	mov	eax,[SuchSektor]
	call	ReadSecEAX
	jc	@@e		;wenn's schief geht
	lea	bx,[Sektor]	;der DirEnt-Zeiger
	xor	dx,dx
@@l1:
	test	dh,4
	jnz	@@f_eol		;end-of-loop?
	mov	al,[bx]
	or	al,al		;Ketten-Ende
	jz	@@f_end
	cmp	al,0E5h
	jz	@@f_era
	call	Is_FCB_Equal
	jz	@@f_fcb
	mov	dl,0		;Schlu mit Leerraum
	jmp	@@to_next
@@f_fcb:
	bts	dx,8		;setzen, schon gesetzt?
	jc	@@e		;Fehler, wenn 2x gefunden (sollte nie sein)
	mov	si,bx
	mov	di,ofs DirEnt_Copy
	mov	cx,10h
	rep	movsw		;als Kopie sicherstellen
	mov	[byte bx],0E5h	;und lschen
	or	[DriveType],DT_Dirty
@@f_era:
	test	dh,2		;Schon gengend Freiraum gefunden?
	jnz	@@to_next
@@f_era1:
	or	dl,dl
	jz	@@f_newspace
	dec	dl
	jnz	@@to_next
	or	dh,2		;OK, gefunden
	jmp	@@to_next
@@f_newspace:
	mov	dl,[LFN_DirEnts]	;Zhler laden
	mov	eax,[CurSector]
	mov	[longpos_s],eax		;(potentiellen) Anfang merken
	mov	[longpos_a],bx
@@to_next:
	mov	al,dh
	not	al
	test	al,3		;Freiraum UND DirEnt gefunden?
	jz	@@e		;ja, fertig
	push	dx
	 call	Next_Dirent
	pop	dx
	jnc	@@l1		;nchste Runde
	or	dh,8
@@f_end:
	or	dh,4
@@f_eol:
	test	dh,1
	stc
	jz	@@e		;Fehler: FCB nicht gefunden!
	test	dh,2
	jnz	@@e		;Freiraum wurde schon gefunden!
	test	dh,8		;schon kein DirEnt mehr Platz im Cluster?
	jz	@@f_era1	;doch!
	push	dx
	 call	FlushDirty
	 call	Alloc_Cluster	;mit Nullen gefllt und bereitgestellt
	pop	dx
	jc	@@e		;z.B. wenn Festplatte rappelvoll
	and	dh,not 8	;weiter mit normalem Next_DirEnt
	jmp	@@l1
@@e:	ret
endp

proc install_long_filename
;FU: Baut langen Dateinamen in Verzeichniseintrag ein
;PE: [longpos_s]:[longpos_a]=LFN-Sektoradresse
	test	[ctrl0],CTRL_Write
	jz	@@e		;Bastelverbot
	test	[File_Flags],(File_Flag_Is_LFN or File_Flag_Lowercase)
	jz	@@e		;nicht basteln!
	;4.1: Anzahl der notwendigen LFN-Verzeichniseintrge berechnen
	call	make_free_dirent_space
	jc	@@e		;Fehler!
	;alles OK fr LFN-Eintragung
	mov	eax,[longpos_s]
	call	ReadSecEAX
	jc	@@e		;Fehler!
	mov	bx,[longpos_a]
	;4.3: Langen Dateinamen einsetzen
	mov	si,ofs FCB_Name
	call	calc_check
	xchg	dh,ah
	mov	dl,[LFN_DirEnts]
;Schleife mit DL=Eintrags-Nummer, DH=Checksumme
	mov	cx,40h		;fr den Anfang
@@l2:	mov	al,13
	dec	dl
	mul	dl
	inc	dl
	mov	si,[CurPathComp]
	add	si,ax		;1->+0, 2->+13 usw.
	mov	di,bx
	mov	al,dl
	or	al,cl		;am Anfang 40h, spter 0
	stosb
	mov	cl,5		;CH ist bereits 0
	call	Copy_Oem_Uni
	mov	ax,0Fh
	stosw			;Attribut
	mov	al,dh
	stosb			;Prfsumme
	mov	cl,6
	call	Copy_Oem_Uni
	xor	ax,ax
	stosw			;Startcluster 0
	mov	cl,2
	call	Copy_Oem_Uni
	or	[DriveType],DT_Dirty
	push	dx
	 call	Next_DirEnt
	pop	dx
	jc	@@e
	xor	cx,cx
	dec	dl
	jnz	@@l2
	;4.4: Kurzen Dateinamen (mit Creation_Time?) eintragen
	cmp	[DirEnt_Copy.timec],0
	jnz	@@k2
	mov	eax,[DirEnt_Copy.timem]
	mov	[DirEnt_Copy.timec],eax
@@k2:	mov	si,ofs DirEnt_Copy
	mov	di,bx
	mov	cx,10h
	rep	movsw
	call	WriteNow
@@e:	ret
endp

proc lfn_creat
	;1. Finden des LFN-Eintrags
	call	path_locate
	jc	@@e		;Pfad nicht gefunden
;Vermeidung von zuviel "locate_dirent", wenn der VC einfach seine
;drei DIRINFO-Dateien sucht...
	mov	al,[Client_DL]
	shr	al,4
	push	ax
	 test	[File_Flags],(File_Flag_Is_LFN or File_Flag_Char_High)
	 jnz	@@locate_dirent	;Suche muss sein
	 dec	al		;Create als Option?
	 jnz	@@pop_open_only	;nein, blo Name kopieren reicht
@@locate_dirent:
 INT3
	 call	File_DirEnt_Locate	;verndert [CurSector] auf momentanen
	pop	ax
	jnc	@@open		;Nur ffnen: ganz einfach!
	dec	al
	mov	ax,9902h	;"Datei nicht gefunden"
	jnz	@@err		;oberes Nibble muss 1 sein (sonst Code 2)!
	call	Check_CDFS
	jnz	@@err		;auf CD ist CREAT schlecht mglich:-)
	test	[ctrl0],CTRL_Write
	jz	@@open_only	;8.3-Name erzeugen lassen (ohne Schlange?!)
	;2. geeigneten, nicht bereits vorhandenen FCB-Namen ermitteln
	mov	si,1
	test	[Client_BH],4	;Wirklich DI als Hint benutzen?
	jz	@@no_DI_hint
	mov	si,[Client_DI]
@@no_DI_hint:
	call	build_unique_fcb_name
	jnc	@@creat
	jmp	@@e		;kommt wirklich ganz selten vor!
@@pop_open_only:
	pop	ax
@@open_only:
	mov	si,ofs FCB_Name
	call	Copy_FCB_8P3_from_SI
@@open:	;3. Aufruf des OldInt21
	mov	[File_Flags],20h	;"nicht basteln"-Code vermerken
@@creat:
	mov	si,ofs ShortBuffer
	mov	bx,[Client_BX]	;Access/Share-Flags
	mov	ax,[Client_CX]	;create-Attribut
	test	[File_Flags],(File_Flag_Is_LFN or File_Flag_Lowercase)
	jz	@@nopatch	;nicht R/O entfernen
	mov	[SearchAttr],ax
	BRES	al,bit 0	;zunchst ohne Schreibschutz erzeugen
@@nopatch:
	xchg	cx,ax
	mov	dx,[Client_DX]	;Aktion
	mov	ah,6Ch
	call	CallOld		;die Universalfunktion rufen
	jc	@@e		;bei Fehler
	mov	[Client_AX],ax	;Datei-Handle
	mov	[Client_CX],cx	;gemachte Aktion
	call	InvalSector
	;kann an Cache angehangen werden! (hier noch nicht)
	test	[File_Flags],(File_Flag_Is_LFN or File_Flag_Lowercase)
	jz	@@e		;nicht basteln!
	mov	bx,[Client_AX]
	DOS	4400h		;Ist es gar ein Zeichentreiber?
	jc	@@e		;sollte nie passieren
	test	dl,80h		;Datei oder Zeichentreiber-Bit
	jnz	@@e		;nicht basteln!
	;4. LFN dazubasteln, aber nicht an geffneter Datei!!
	mov	bx,[Client_AX]
	DOS	3Eh		;also Datei schlieen
	jc	@@del		;Irrlufer!
	call	ResetDrv
	call	install_long_filename
	jc	@@del
	;Noch mal ffnen
@@try_nt:
	mov	cx,[SearchAttr]	;(Neues) Attribut
	mov	ah,3Ch
	call	SFN_CallOld	;Datei noch einmal erzeugen (ffnen)
	mov	[Client_AX],ax
	jnc	@@e
	xor	bx,bx
	DOS	59h
	INT3			;gucken, was NT sagt
	mov	cx,4		;200ms
	call	WaitTick
	jmp	@@try_nt
@@del:	and	[DriveType],not DT_Dirty ;Sektor doch nicht schreiben
	mov	ah,41h
	call	SFN_CallOld	;Datei lschen (egal ob's funktioniert)
@@err5:	mov	ax,9905h
@@err:	stc
@@e:	ret
endp

proc lfn_move
;Vorgehensweise:
;Bildung des SFN fr beide Dateinamen (also zwei ShortBuffer
; erforderlich, dafr muss der Heap herhalten,
;Vormerken: Lschposition (wie bei SFN_unlink), FCB-Name und LFN
; fr neuen Namen
;Aufruf der DOS-Funktion RENAME
;alten DirEnt lschen; SFN-LFN-Verknpfung NICHT in Tunnel schieben!
;neuen DirEnt setzen
;Sonderfall:
;Bilden beide (unterschiedlichen) LFN den gleichen SFN,
;wird _nicht_ die DOS-Funktion gerufen, sondern alles von Hand gemacht!
;1. Quelldatei in SFN umwandlen
	call	Find_Longname_For_Deletion
;2. Quelldatei-SFN wegkopieren
	mov	di,ofs ShortBuffer
	call	strlenp1	;AX=Alloc-Lnge
	add	ax,6		;Platz fr Quell-LFN-Lsch-Info
	call	LocalAlloc
	jc	@@e		;kein Platz!
	mov	[SearchAttr],di	;ZWECKENTFREMDUNG
	mov	si,ofs longpos_s
	mov	cx,3
	rep	movsw
	mov	si,ofs ShortBuffer
	call	strcpy		;hinein in den Speicher!
;3. Zieldatei in SFN umwandeln
	mov	fs,[Client_ES]
	mov	si,[Client_DI]
	call	path_locate
	jc	@@em		;Pfad nicht gefunden
	call	Check_CDFS
	stc
	jnz	@@em		;auf CD schlecht mglich:-)
	call	File_DirEnt_Locate
	jnc	@@em		;Existiert bereits: Fehler!
;3. geeigneten, nicht bereits vorhandenen FCB-Namen ermitteln
	mov	si,1
	call	build_unique_fcb_name
	jc	@@em
;4. Sichern wichtiger Parameter fr nachher (welche??)
;   * LFN-Name (also CurPathComp)
;   * FCB-Name mit Schlange (zum Suchen des DirEnts)
;   * Startsektor des Verzeichnisses [SuchSektor]

;5. SFN-Funktion aufrufen; diese entfernt den LFN-FAT-Eintrag
;   und "vermatscht" eine Menge globaler Variablen (welche??)
	mov	dx,[SearchAttr]
	add	dx,6
	mov	di,ofs ShortBuffer

	mov	ah,56h
	call	callold
	jc	@@em		;bei Fehler muss alles so bleiben
;6. Ziel-LFN dazubasteln
	call	ResetDrv
	call	install_long_filename
;Was tun, wenn's schiefging?

;7. Quell-LFN entfernen
	mov	si,[SearchAttr]
	mov	di,ofs longpos_s
	mov	cx,3
	rep	movsw
	call	Loesch_longpos	;evtl. vorhandenen Dateinamen killen!
	clc

@@em:	pushf
	 mov	di,[SearchAttr]
	 call	LocalFree
	popf
@@e:	ret
endp

proc lfn_unlink
;Test auf Schreibzugriffsverbot nicht erforderlich wegen SmartOS-Mglichkeit
	mov	si,dx
	call	file_locate	;SOO einfach nur ohne Wildcard-Funktion!
	mov	dx,ofs ShortBuffer
	DOS	41h		;Verschwendung: Noch einmal file_locate()
	ret
endp

proc Find_Longname_For_Deletion
;FU: Kopf-Funktion fr SFN/LFN-unlink/rmdir/move
;PE: FS:DX=zu lschender Dateiname
;PA: [longpos_s]:[longpos_a]=Sektoradresse LFN-Eintrag
;    [ShortBuffer]=kurzer Dateiname
	mov	si,dx
	call	file_locate
	jc	@@w		;DOS arbeiten lassen!
	cmp	[longname],0	;wirklich mit langem Namen?
	jz	@@w		;nein
	test	[DriveType],DT_SmartOS	;hat das OS bereits einmal gelscht?
	jz	@@e		;nein, mssen's vielleicht selber tun
@@w:	mov	[longpos_a],0	;nichts anschlieend zu lschen
@@e:	ret
endp

proc sfn_unlink
;Unabhngig von der Stellung des Schalters "Schreiben" muss beim
;Lschen von Dateien und Verzeichnissen _immer_ der LFN-Eintrag
;mit gelscht werden!
;Ansonsten blieben im Verzeichnis LFN-Eintrge zurck, die das Lschen
;des Verzeichnisses verhindern, und das wre weitaus schlimmer.
;Glcklicherweise wird Int21 immer sequentiell (im Gnsemarsch)
;gerufen, dadurch sollten Reentranzprobleme unter Windows vom Tisch sein.
;Beim Lschen in der NT-DOS-Box kommt das NT zuvor (dieses lscht
; selbstndig den LFN-Teil, genauso auch das (nackte) MS-DOS7)
	;1. Finden des LFN-Eintrags
	call	Find_Longname_For_Deletion
	;2. Aufruf des OldInt21
	mov	ds,[Client_DS]
	mov	dx,[Client_DX]	;Client-Variablen via SS: kein Problem!
	mov	es,[Client_ES]	;nur fr move/rename
	mov	di,[Client_DI]	;nur fr move/rename
	mov	ah,[Client_AH]	;rmdir oder unlink oder rename
	call	callold
	mov	cx,cs
	mov	ds,cx
	mov	es,cx
	jc	@@e		;bei Fehler muss alles so bleiben
Loesch_longpos:
	call	terminate_cache	;evtl. vorhandenen Dateinamen killen!
	;Dieser muss genaugenommen in den "Tunnel" geschoben werden!
	;3. Lschen des LFN-Eintrags
	call	InvalSector	;ist nun auf jeden Fall ungltig!
	mov	bx,[longpos_a]
	or	bx,bx
	jz	@@e1		;nichts zu tun!
	mov	eax,[longpos_s]
	push	bx
	 call	ReadSecEAX
	pop	bx
	mov	al,[(TLfnDirEnt bx).count]
	cmp	al,0E5h		;Schlaues Betriebssystem am Werk?
	jne	@@nosmart
	or	[DriveType],DT_SmartOS	;nie mehr nachfummeln mssen!
@@nosmart:
	test	al,80h
	jnz	@@e1		;hat das OS (z.B. WinNT) schon gelscht o..!
	test	al,40h		;Letztes Stckel?
	jz	@@e1		;irgendwas ist faul
	and	al,3Fh		;Nummer
@@loesch:
	cmp	[(TLfnDirEnt bx).attr],0Fh
	jne	@@ep		;wieder ist was faul (aber doch schreiben)
	mov	[(TLfnDirEnt bx).count],0E5h
	or	[DriveType],DT_Dirty	;schreiben lassen
	dec	al
	jz	@@ep		;Ende erreicht
	push	ax
	 call	Next_DirEnt
	pop	ax
	jc	@@ep		;sollte eigentlich nie passieren
	cmp	al,[(TLfnDirEnt bx).count]	;Folge-Glied?
	je	@@loesch	;alles noch in Ordnung!
@@ep:	call	FlushDirty	;sicherheitshalber sofort schreiben (Diskette!)
@@e1:
	clc
@@e:	ret
endp

proc Check_NoRO
;FU: Testet aktuelles Laufwerk auf NoRO-Kandidat und, wenn ja, lscht
;    Schreibschutzattribut
;PE: CX oder CL = Attribut
;PA: CX oder CL = modifiziertes Attribut
;VR: CL,AL
	test	[ctrl0],CTRL_RoBit
	jnz	@@e		;alles belassen
	mov	al,[DriveType]
	cmp	al,1		;unbekannt: NORO
	jc	@@1
	test	al,DT_CDFS	;auf CDs sowieso NoRO
	jz	@@e
@@1:	and	cl,not 1	;Schreibschutz-Attribut weg!
@@e:	ret
endp

;<lfn_attr>-Unterprogramme
;PE: BX=DirEnt-Zeiger
;    CY=0
proc attr_getattr		;via DOS ohne spezielle (CD-)Verrenkungen
	mov	ax,4300h
	call	SFN_CallOld	;also GetAttr
	jc	@@e
	call	Check_NoRO
	mov	[Client_CX],cx
@@e:	ret
endp
proc attr_setattr
	mov	cx,[Client_CX]
	mov	ax,4301h
	jmp	SFN_CallOld
endp
cd_attr_getphyssize:
	mov	eax,[(TCD_DirEnt bx).fsize]
	mov	cl,11			;2^11=2048
	jmp	_getphyssize
proc attr_getphyssize
	mov	eax,[(TDirEnt bx).fsize] ;mit Clusterverschwendung...
	mov	cl,[DPB_Shift]		;fr max. 64K-Cluster
	add	cl,9			;2^9=512 Bytes pro Sektor
_getphyssize:
	mov	bx,1
	shl	bx,cl
	dec	bx
	test	ax,bx
	jz	@@FullCluster
	or	ax,bx
	inc	eax			;aufrunden
@@FullCluster:
	mov	[Client_AX],ax
	ror	eax,16
	mov	[Client_DX],ax
retu:
	clc
	ret
endp
proc attr_settimem
;Fehlt noch: Anpassung der Verzeichniseintrge "." und ".."
;im untergeordneten Verzeichnis (falls Verzeichnis), oder was macht Win9x?
	mov	ax,[Client_DI]
	rol	eax,16
	mov	ax,[Client_CX]
	cmp	[(TDirEnt bx).timem],eax
	je	retu
	mov	[(TDirEnt bx).timem],eax
Dirty_Sec:
	or	[DriveType],DT_Dirty
	ret
endp
cd_attr_gettimem:
	call	CD_Get_Time
	jmp	_attr_gettimem
proc attr_gettimem
	mov	eax,[(TDirEnt bx).timem]
_attr_gettimem:
	push	eax
	pop	[Client_CX]		;LOW
	pop	[Client_DI]		;HIGH
	ret
endp
proc attr_settimea
	mov	ax,[Client_DI]
	cmp	[(TDirEnt bx).timea],ax
	je	retu
	mov	[(TDirEnt bx).timea],ax
	jmp	Dirty_Sec
endp
proc attr_gettimea
	mov	ax,[(TDirEnt bx).timea]
cd_attr_gettimea:
	mov	[Client_DI],ax
	ret
endp
proc attr_settimec
	mov	ax,[Client_DI]
	rol	eax,16
	mov	ax,[Client_CX]
	mov	[(TDirEnt bx).timec],eax
	mov	ax,[Client_SI]
	mov	[(TDirEnt bx).timec10ms],al
	jmp	Dirty_Sec
endp
cd_attr_gettimec:
	call	CD_Get_Time
	jmp	_attr_gettimec
proc attr_gettimec
	mov	dl,[(TDirEnt bx).timec10ms]
	mov	eax,[(TDirEnt bx).timec]	;DWORD
_attr_gettimec:
	mov	[Client_CX],ax		;LOW
	shr	eax,16
	mov	[Client_DI],ax		;HIGH
	mov	dh,0
	mov	[Client_SI],dx
	ret
endp

proc lfn_attr
	mov	si,dx
	cmp	al,9
	jnc	@@e0		;Fehler: falsche Subfunktion
	mov	dx,ofs file_locate
	mov	al,[Client_BL]
	cmp	al,2
	jc	@@1		;immer erlaubt, weil Schreiben via DOS
	mov	dx,ofs dirent_locate
	test	[ctrl0],CTRL_Write
	jnz	@@1		;Schreiben erlaubt
	test	al,1
	jnz	@@e0		;verbotener Schreibzugriff!
@@1:	call	dx		;also je nach [Client_BL]
	jc	@@e
	mov	ax,ofs cd_pvt_attr
	mov	si,[Client_BX]
	and	si,0FFh
	call	Check_CDFS
	jnz	@@iscd
	mov	ax,ofs pvt_attr
	add	si,si
@@iscd:	test	si,1		;ungerade Nummer?
	jnz	@@e0
	add	si,ax
	xor	ax,ax
	jmp	[word si]
@@e0:	mov	ax,9901h	;Fehlercode
@@e:	stc
	ret
endp

proc InitFill
;FU: Win32_Find_Data-Record-Zeiger laden und EAX lschen; CH laden;
;    Client_CX lschen (return OEM oder?)
	mov	es,[Client_ES]
	mov	di,[Client_DI]
	mov	ch,[byte LOW Client_SI]
	xor	eax,eax
	mov	[(TW32FindData es:di).sname],al
	mov	[Client_CX],ax
	ret
endp

proc FillFD
;Routine fr FindFirst/FindNext: W32FindData-Record fllen
;PE: [Client_ES]:[Client_DI]=FindData-Zeiger
;    BX=DirEnt-Zeiger
;    [Client_SI]=DateTime_Format (Bit 0)
;PA: FindData gefllt; Zeitformat=DOS
;    [Client_CX]=0 (Unicode_Conversion_Flags)
;VR: ES,DI,SI,EAX,EDX,CH
	call	InitFill
	call	copy_attr_and_time
	xor	eax,eax
	stosd				;SizeH
	xchg	edx,eax
	stosd				;SizeL
	call	stosq0			;res
	mov	si,ofs LongName
	cmp	[byte si],al
	jz	@@short_only
	push	di
	 call	strcpy			;"Langer" Dateiname
	pop	di
	add	di,260			;auf "kurzen" Namen
@@short_only:
	mov	si,ofs ShortName
	jmp	strcpy
endp

proc PutValues
;Routine fr FindFirst/FindNext: Handle-Puffer fllen
;PE: DI=Handle-Puffer
;    DX=Such-Attribut
;    BX=DirEnt-Zeiger
;    [CurSector]=Sektornummer
;PA: Handle-Puffer gefllt
;VR: EAX,DX,SI,DI
	mov	al,MAGIC_hFind		;Magic fr "gltiges Handle"
	stosb
	mov	al,[DPB_Drive]
	stosb
	mov	ax,[SearchAttr]
	stosw
	mov	ax,bx
	stosw				;bei CD: ISO-DirEnt
	mov	eax,[CurSector]
	stosd				;bei CD: 1. ISO-DirEnt
	call	Check_CDFS
	jz	@@w
	mov	ax,[CD_LFN_DP]
	stosw
	mov	eax,[CD_LFN_Cur]
	stosd
@@w:	mov	si,[CurPathComp]
	call	strcpy			;den String hinterher!
	ret
endp

proc Check_Valid_BX
;Testet ob BX=FindFirst/FindNext-Handle gltig ist
;PA: CY=1 und AX=6 wenn ungltig, sonst CY=0
;    SI=BX+1
	or	bx,bx		;Nullhandle extra (wegen VC-Fehler)
	jz	@@f_vc		;AX (=7100h) belassen!
	mov	si,bx
	lodsb
	cmp	al,MAGIC_hFind
	jz	@@ok
	cmp	al,MAGIC_FB_hFind
	jz	@@ok_Z0
@@f_vc:	mov	ax,9906h	;invalid handle (s.a. Int21/AH=59)
	stc
	ret
@@ok_Z0:or	al,al
@@ok:	ret
endp

proc Alloc_Find_Handle
;FU: Speicherreservierung fr FindFirst
;PE: [CurPathComp]=Suchausdruck (wegen Speicherplatzbedarf spter!)
;PA: DI=[Client_AX]=Zeiger auf entsprechend Platz
;    CY=1: AX=9904=handle table full
	mov	di,[CurPathComp]
	call	strlenp1
	add	ax,SIZE TFindInfo	;z.Z. unabhnging FAT/Joliet
_Alloc_Find_Handle:		;Einstieg fr Rckfall...
	call	LocalAlloc
	mov	ax,9904h	;handle table full
	jc	@@e
	mov	[Client_AX],di	;return Handle
@@e:	ret
endp

proc CD_Make_Volume_Label
;Jede CD habe ein Volume Label... oder?
	call	InvalSector
	mov	bx,ofs CD_Sektor
	mov	dl,[CD_LFN_Vol]
	mov	dh,0
	mov	cl,[DPB_Drive]
	mov	ch,dh
	MUX	1505h		;"read vtoc"

	call	InitFill
	mov	al,8		;Attribut "Volume Label"
	stosd
	mov	al,ah
	mov	cx,20
	rep	stosw		;10 DWords nur Nullen
	mov	si,ofs CD_Sektor+28h
@@l:	lodsw
	call	cd_uni2oem	;"langes" Label (ist nullterminiert)
	stosb
	or	al,al
	jnz	@@l
	LD	es,ds
	call	Alloc_Find_Handle
	mov	eax,[CD_SFN_Cur]
	mov	[CurSector],eax
	mov	bx,ofs CD_Sektor	;zurckstellen!
	mov	[CD_LFN_DP],bx
	call	PutValues
	clc
	ret
endp

proc FB_Alloc_Find_Handle
;FU: Speicherreservierung fr FindFirst im Rckfallmodus
;PE: [CurPathComp]=Suchausdruck (wegen Speicherplatzbedarf spter!)
;PA: DI=[Client_AX]=Zeiger auf entsprechend Platz
;    CY=1: AX=9904=handle table full
	xor	ax,ax
	test	[File_Flags],File_Flag_Is_LFN
	jz	@@1		;keinen Dateinamen einbeziehen!
	mov	di,[CurPathComp]
	call	strlenp1
@@1:	add	ax,SIZE TFB_FindInfo
	jmp	_Alloc_Find_Handle
endp

proc FB_FillFD
	call	InitFill	;liefert CH(!)
	mov	cl,[DTA.attr]
	call	Check_NoRO
	xchg	cl,al
	stosd
	call	stosq0
	call	stosq0
	mov	eax,[DTA.time]
	call	evtl_time_dos_win_dl0	;verwendet CH
	xor	eax,eax
	stosd			;SizeHigh
	mov	eax,[DTA.fsize]
	stosd
	call	stosq0		;2 langweilige reservierte Felder
	lea	si,[DTA.fname]
	jmp	strcpy
endp

proc noentry_FB_Check_Found
;FU: Testet Dateinamen und Attribut im DTA gegen zu suchenden
;    "langen" Suchausdruck (der z.B. die Suche nach "*1" untersttzt)
;    sowie gegen das noch ausstehende Must-Match-Attribut.
;    Bei Fehltreffer Auslsung von FindNext bis zum Treffer oder CY=1
;    Das Attribut 0Fh wird hier extra herausgeworfen...(???)
;PE: DOS DTA auf [DTA] gesetzt und gefllt
@@l:	mov	al,[DTA.attr]
	cmp	al,0Fh		;ein LFN (auf FAT)?
	je	@@retry
	call	Match_MM_Attr
	jnz	@@retry
	test	[File_Flags],File_Flag_Is_LFN
	jz	@@e		;kein Dateiname zu vergleichen
	lea	si,[DTA.fname]
	call	GlobbingEx
	jz	@@e		;OK, Name geht durch
FB_Find_Next:			;Einstieg fr FB_fnext
@@retry:mov	ah,4Fh		;FindNext
FB_Find_First:			;Einstieg mit AH=4Eh
	call	CallOld
	jnc	@@l
@@e:	ret
endp

proc FB_ffirst
;FU: FindFirst im Rckfallmodus
	call	same_stuff	;hier: Suchmaske (meist ????????.???)

	call	DTA_Init

	mov	cx,[SearchAttr]
	not	cl
	mov	dx,ofs ShortBuffer
	mov	ah,4Eh
	call	FB_Find_First
	jc	DTA_Done	;wenn's nichts zu finden gab
	call	FB_Alloc_Find_Handle
	jc	DTA_Done	;kein Platz im Heap (pardon!)
	mov	al,MAGIC_FB_hFind
	stosb
	call	Store_DTA
	mov	al,[byte HIGH SearchAttr]
	stosb
	mov	al,[File_Flags]
	stosb
	test	al,File_Flag_Is_LFN
	jz	@@no_name
	mov	si,[CurPathComp]
	call	strcpy		;liefert CY=0
@@no_name:
	jmp	FD_Fill
endp

proc FB_fnext
;FU: FindNext im Rckfallmodus
;PE: BX=(SI-1)=Heap-Zeiger (Such-Handle)
	call	DTA_Init
	mov	di,ofs DTA
	mov	cx,21		;eigentlich knnte die DTA auch ganz gut
	rep	movsb		;im Heap residieren, aber ich bin ja geizig..
	lodsb
	mov	[byte HIGH SearchAttr],al
	lodsb
	mov	[File_Flags],al
	mov	[CurPathComp],si	;hier: egal ob Name gespeichert ist!
	call	FB_Find_Next
	jc      DTA_Done
	mov	di,bx		;BX (=Handle) bis dahin nicht gendert(?)
	inc	di
	call	Store_DTA	;die 21 Bytes als Aufhnger zum Weitersuchen
FD_Fill:
	call	FB_FillFD
	;jmp	DTA_Done
endp
proc DTA_Done
;VR: DX; Flags (speziell CY) werden gerettet!
	pushf
	push	ds ax
	 lds	dx,[old_dta]
	 DOS	1Ah
	pop	ax ds
	popf
	ret
endp

proc DTA_Init
;VR: AX,DX(=ofs dta)
	push	es bx
	 DOS	2Fh
	 SES	[old_dta],bx
	pop	bx es
	mov	dx,ofs dta
	DOS	1Ah
	ret
endp

proc Store_DTA
;FU: 21 Bytes des DTA nach ES:DI kopieren
;PA: DI entsprechend erhht
;VR: CX,SI,DI
	lea	si,[DTA]
	mov	cx,21
	rep	movsb		;die 21 "undokumentierten" Bytes der DTA
	ret
endp


proc lfn_ffirst
	mov	si,dx		;noch unzerstrt...
	call	path_locate
	jc	@@e
	call	Reset_Follow
	mov	ax,[Client_CX]	;Attribute
	cmp	al,8		;Nur Volume Label?
	jne	@@1
	mov	ah,al		;dann gilt hier eine Must-Match-Ausnahme!
@@1:	or	al,21h		;ARCHIVE und READONLY immer "durchlassen"
	not	al		;als "Auswerf-Maske" umdrehen
	mov	[SearchAttr],ax
	xchg	cx,ax		;fr's (lange) Label der CD

	mov	al,[DriveType]
	cmp	al,1
	jc	FB_ffirst	;das ganze im Rckfallmodus
	test	al,DT_CDFS
	jnz	@@oncd

	mov	bx,ofs Glob_LFN_Proc
	call	DirScan		;auf FAT ganz einfach!
	jmp	@@k
@@oncd:
	test	cl,8		;Volume Label?
	jnz	@@2
	call	CD_Make_Volume_Label
	jnc	@@e
@@2:
	mov	bx,ofs Glob_CD_LFN_Proc
	call	CD_Ping_DirScan	;auf CDFS ungleich komplizierter!
				;HIER keine Suche in der Gegenrichtung!
				;(das wre reichlich Luxus: 2K mehr RAM usw.)
	mov	eax,[CD_SFN_Cur]
	mov	[CurSector],eax
	mov	bx,ofs CD_Sektor	;zurckstellen!
@@k:	mov	ax,9902h	;file not found
	jc	@@e
@@f:	;Eintrag gefunden, mit bx=DirEnt-Zeiger
	call	Alloc_Find_Handle
	call	PutValues
	call	FillFD
@@e:	ret
endp

proc lfn_fnext
	call	Check_Valid_BX
	jc	@@e
	jnz	FB_fnext
	lodsb
	inc	al
	call	GetDrvParams	;tut meist nichts, wenn AL gleich geblieben
	lodsw
	mov	[SearchAttr],ax	;Attribute
	lodsw
	xchg	bx,ax		;Sektorzeiger
	lodsd			;Sektor-Nummer
	call	Check_CDFS
	jnz	@@cd
	;weiter mit FAT
	mov	[CurPathComp],si	;Maske folgt (Zeiger in Heap)
	push	bx
	 call	ReadSecEAX
	pop	bx
	jc	@@e

	mov	[MatchPtr],ofs Glob_LFN_Proc
	call	NextDirScan	;auf FAT ganz einfach!
	jmp	@@alldrives
@@cd:	;weiter mit CDFS (Joliet)
	mov	[CD_SFN_DP],bx
	mov	[CD_SFN_Cur],eax
	lodsw
	xchg	bx,ax
	lodsd
	mov	[CurPathComp],si	;Maske folgt (Zeiger in Heap)
	push	bx
	 call	ReadSecEAX
	pop	bx
	mov	[MatchPtr],ofs Glob_CD_LFN_Proc
	call	NextDirScan
	jc	@@alldrives
	mov	[CD_LFN_DP],bx
	mov	eax,[CurSector]
	mov	[CD_LFN_Cur],eax	;neuer Zeiger fr PutValues
	call	SetSuchSektor_SFN
	mov	eax,[CD_SFN_Cur]
	mov	[CurSector],eax
	mov	bx,ofs Match_CD_Sectorpointer_Proc
	call	DirScan			;immer von vorn!
	jc	@@e			;Konsistenzfehler!
	call	CD_Shortname
	mov	eax,[CD_SFN_Cur]
	mov	[CurSector],eax
	clc

@@alldrives:
	mov	ax,9912h	;no more files
	jc	@@e

	mov	di,[Client_BX]
	call	PutValues
	call	FillFD
	mov	ah,4Fh		;"undokumentierter" Returnwert
	mov	[Client_AX],ax
@@e:	ret
endp

proc lfn_fclose
	call	Check_Valid_BX
	jc	@@e
	mov	di,bx
	call	LocalFree	;Handle-Tabellen-Eintrag freigeben
@@e:	ret
endp

proc lfn_name
public lfn_name
	cmp	cl,3		;nur 0..2
	jnc	erre
	cmp	cl,1
	jc	lfn_truename
	jz	lfn_shortname
	jmp	lfn_longname
erre:	stc
	ret
endp

proc lfn_truename
	call	Make_Truename
	jc	@@e
	push	[Client_ES] [Client_DI]
	push	ds ofs longbuffer
	call	fstrcpy
@@e:	ret
endp

proc lfn_shortname
	call	file_locate
	jc	@@e
ShortToClient:
	push	[Client_ES] [Client_DI]
	push	ds ofs shortbuffer
	call	fstrcpy
@@e:	ret
endp


proc lfn_longname
	call	start_stuff
	jc	@@e
	mov	si,ofs longbuffer
	mov	fs,[Client_ES]
	mov	di,[Client_DI]
	lodsd
	mov	[fs:di],eax	;Laufwerk:\
	dec	si
	add	di,3
	call	MakeLongName
@@e:	ret
endp

proc lfn_genshort
;Aus Dateiname (ohne Pfad) kurzen Dateinamen (Alias) generieren
;Seiteneffekt: arbeitet bis zum Backslash (Pfad-Komponente)
	cmp	[Client_DL],11h		;nur OEM->OEM wird untersttzt!
	jne	erre
	cmp	[Client_DH],2		;nur 0 (FCB) oder 1 (8.3)
	jnc	erre
	mov	si,ofs longbuffer
	push	ds si
	push	[Client_DS] [Client_SI]
	call	fstrcpy			;lokal kopieren

	call	Gen_Alias		;nach FCB_Name

	mov	es,[Client_ES]
	mov	di,[Client_DI]
	cmp	[Client_DH],0
	mov	bx,ofs FCB_Name
	je	@@want_fcb

	call	Copy_FCB_8P3	;hier mit ES<>DS!
	ret

@@want_fcb:
	mov	si,bx
	mov	cx,11
	rep	movsb
	ret
endp

proc lfn_timeconv
public lfn_timeconv
	cmp	[Client_BL],1
	jc	@@todos
	jz	@@towin
	stc
	ret
@@todos:
	segfs	lodsd
	xchg	edx,eax
	segfs	lodsd
	xchg	edx,eax
	call	time_win_dos
	jc	@@e		;kann versagen...
	ror	eax,16		;Hi<->Lo
	mov	[Client_CXDX],eax
	mov	[Client_BH],dl
	clc
@@e:	ret
@@towin:
	mov	eax,[Client_CXDX]
	rol	eax,16		;Hi<->Lo
	mov	dl,[Client_BH]
	mov	es,[Client_ES]
	mov	di,[Client_DI]
	;jmp	time_dos_win	;versagt nie
endp

proc time_dos_win ;TODO
;FU: Zeit-Umwandlung DOS->WIN
;    Die Implementierung wre geradezu Luxus; deshalb einfach eine
;    "Abbildung", die zumindest eine korrekte Sortierung ermglicht,
;    und eine Rckkonvertierung zum vorhergehenden FAT-Format ermglicht
;PE: EAX=DOS-Dateizeit
;    DL=DOS-10-ms-Schritte
;    [TimeOffset]=Zeitzonen-Umrechnungszahl
;    ES:DI=Speicher zum Schreiben der Zeit (stosq)
;PA: EAX:EDX=Win-Dateizeit (100-ns-Schritte seit 1.1.1601)
;    CY=1: fehlerhafte Angaben (z.B. 13. Monat o..)
;VR: EAX,EDX
	xchg	edx,eax
	shl	eax,24		;stimmt ungefhr (Faktor 500)
stosq:
	stosd
	xchg	edx,eax
	stosd
	ret
endp

proc stosq0
	xor	eax,eax
	stosd
	stosd
	ret
endp

proc evtl_time_dos_win_dl0
;FU: Wandelt je nach CH die Dateizeit ins Win-Format
;    oder macht nichts auer EDX zu lschen; fr FindFirst/FindNext
;PE: EAX=DOS-Dateizeit
;    DL=DOS-10-ms-Schritte (nur bei Einsprung evtl_time_dos_win)
;    CH=Schalter DOS (<>0) oder Win (=0)
;    ES:DI=Speicherort fr Win32-Zeit
;PA: EDX:EAX=DOS- oder Win-Dateizeit
;VR: EAX,EDX,DI
	mov	dl,0
evtl_time_dos_win:
	or	ch,ch
	jz	time_dos_win
	xor	edx,edx
	jmp	stosq
endp

proc time_win_dos ;TODO
;FU: Zeit-Umwandlung WIN->DOS
;PE: EDX:EAX=Win-Dateizeit (100-ns-Schritte seit 1.1.1601)
;    [TimeOffset]=Zeitzonen-Umrechnungszahl
;PA: EAX=DOS-Dateizeit
;    DL=DOS-10-ms-Schritte
;    CY=1: auerhalb des Bereiches 1980..2107
;VR: EAX,EDX
;Zur Zeit einfach als "Komplementrfunktion" implementiert
	shr	eax,24
	xchg	edx,eax
	ret
endp

proc lfn_volinfo
public lfn_volinfo
;Laufwerks-Informationen beschaffen
	mov	si,dx
	call	start_stuff
	jc	@@e
	xor	eax,eax
	mov	[Client_DXBX],260*65536+4006h
		;Lnge Pfad (DX), BX=4007h wre mit case-sensitiver Suche
	dec	al			;255
	xchg	[Client_AXCX],eax	;Lnge Dateiname<->Lnge VolType
	cmp	ax,4			;zu kleiner Puffer?
	jc	@@novolinf		;Nicht einschreiben!
	mov	es,[Client_ES]
	mov	di,[Client_DI]
	call	Check_CDFS
	jnz	@@cd
	mov	eax,'TAF'		;lies: "FAT",0
	stosd
@@novolinf:
	clc
@@e:	ret
@@cd:	mov	eax,'SFDC'		;lies: "CDFS"
	stosd
	mov	al,0
	stosb
	ret
endp

proc copy_attr_and_time
;BE: Gemeinsame Routine fr FillFD (FindFirst/FindNext)
;    und GetFileInfoByHandle (wie auch immer der Dateiname zu ergattern ist)
;    Dummerweise geht nicht mehr, da "Datentrgernummer" dazwischen kommt
;    Fr FAT und CDFS (per Fallunterscheidung)
;PE: BX=DirEnt-Zeiger
;    ES:DI=Puffer fr attr,timec,timea,timem
;    CH=Schalter fr Zeit-Konvertierung, =0 fr Win-Dateizeit
;PA: DI vorgerckt
;    EDX=Datei-Gre
;VR: EAX,EDX,DI
	xor	eax,eax
	call	Check_CDFS
	jnz	@@cd
	mov	al,[(TDirEnt bx).attr]	;gefundenes Attribut
	stosd
	mov	eax,[(TDirEnt bx).timec];creation time
	mov	dl,[(TDirEnt bx).timec10ms]
	call	evtl_time_dos_win
	mov	ax,[(TDirEnt bx).timea]	;access time (nur Datum)
	shl	eax,16
	call	evtl_time_dos_win_dl0
	mov	eax,[(TDirEnt bx).timem];modification time
	call	evtl_time_dos_win_dl0
	mov	edx,[(TDirEnt bx).fsize];Dateigre (max. 2GB)
	ret
@@cd:
	call	CD_Get_Attr
	stosd
	call	CD_Get_Time		;auf 1 Sekunde genau
	call	evtl_time_dos_win	;creation time
	xchg	edx,eax
	push	eax
	 call	stosq0			;access time unbekannt
	pop	eax
	call	stosq			;modification time
	mov	edx,[(TCD_DirEnt bx).fsize];Dateigre (max. 2GB)
	ret
endp

;******************************************************************
;** FastOpen-Cache
;** hlt die Zuordnung "kurzer Name", "langer Name" und "Startsektor"
;** zur Vermeidung exzessiver Festplattenzugriffe
;**  reset_cache_ptr vor Dateinamen-Suche aufrufen
;**  fr jede Pfadkomponente find_in_cache aufrufen,
;**  bei jedem Versager und Auffindung put_to_cache aufrufen!
;******************************************************************
;Cache-Aufbau: ab Wurzel:
;<tiefe> mal
; ASCIIZ kurzer Dateiname (alias)
; ASCIIZ langer Dateiname (longname)
; DWORD Startsektor
;BYTE 0 Ende der Kette
;[fastopen_ptr] zeigt auf aktuellen Eintrag

;proc reset_cache_ptr
;	mov	[fastopen_ptr],ofs fastopen_buf
;	ret
;endp

proc find_in_cache
;Vergleicht [CurPathComp] mit [fastopen_ptr]
;Wenn das klappt, kopiert langen Dateinamen nach [longname] ???
; und CurPathComp nach shortbuffer (Anhngen an DI)
;Wenn nicht, vergleicht [CurPathComp] mit vorgercktem [fastopen_ptr]
;Wenn das klappt, kopiert Alias nach [shortbuffer] (Anhngen an DI)
;Wenn nicht, dann raus mit Z=0
;Startsektor nach [CurSector] schreiben
;PA: Z=1: gefunden
;	[CurSector]=Startsektor (FAT), [CD_?FN_Cur]=Startsektoren (Joliet)
;	[ShortName]=kurzer Dateiname
;	[LongName] =langer Dateiname
;	[fastopen_ptr] vorgerckt
;    Z=0: nicht gefunden
;	[fastopen_ptr]^=0 Endemarkierung gesetzt
;VR: EAX, SI, DI (nur bei Z=1)
	mov	di,[fastopen_ptr]
	cmp	[byte di],1	;Null als Kennung fr "kein Cache-Eintrag"
	jc	@@e
	mov	si,[CurPathComp]
	call	StrIComp
	jz	@@f
	;nicht "kurz" gefunden: "lang" suchen!
	dec	di		;zumindest AUF die Null zurck!
	mov	al,0
	push	cx
	 mov	cx,-1
	 repne	scasb		;DI hinter die Null von ShortName
	pop	cx
	mov	si,[CurPathComp]
	call	StrIComp
	jnz	terminate_cache
@@f:
	mov	si,[fastopen_ptr]
	mov	di,ofs ShortName
	call	strcpy		;kurz nach FCB_Name (dann nach "shortbuffer")

	mov	di,ofs LongName
	call	strcpy		;lang nach "longname" (ggf. leere Zeichenk.)

	lodsd
	call	_set_cur_and_such	;belanglos bei CDFS
	call	Check_CDFS
	jz	@@nocd
	mov	[CD_SFN_Cur],eax
	lodsd			;bei CD sind's 2 DWORDs, nicht nur einer!
	mov	[CD_LFN_Cur],eax
	cmp	al,al		;Z setzen
@@nocd:	mov	[fastopen_ptr],si
@@e:	ret
endp

proc terminate_cache
;FU: FastOpen-Kette terminieren
	mov	di,[fastopen_ptr]
	mov	al,0
	stosb			;Ende-Kennung hier eintragen
	ret
endp

proc put_to_cache
;Tut beide Dateinamen in Puffer mit Startsektor, Abschluss mit Doppelnull
;PE: [CurSector]=Startsektor (bei CDFS: [CD_SFN_Cur] und [CD_LFN_Cur])
;	ber die Link-Tabelle ist eigentlich nur das Speichern EINES Sektors
;	bei CD erforderlich!
;    [LongName] =langer Dateiname (ggf. leer)
;    [ShortName]=kurzer Dateiname (Zeiger)
;PA: [fastopen_ptr] vorgerckt
;    [fastopen_ptr]^=0 Endemarkierung gesetzt
;VR: SI,DI,EAX
	mov	di,[fastopen_ptr]
	mov	si,ofs ShortName
	call	strcpy		;liefert AL=0

	mov	si,ofs LongName
	call	strcpy		;ggf. nur die Null speichern, wenn kein LFN

	mov	eax,[CurSector]
	call	Check_CDFS
	jz	@@nocd
	mov	eax,[CD_SFN_Cur]
	stosd
	mov	eax,[CD_LFN_Cur]
@@nocd:
	stosd
	mov	[fastopen_ptr],di
	mov	al,0
	stosb			;Endekennung
	ret
endp
	align	2

;******************************************************************
;** LocalAlloc-Speicher (Heapverwaltung)
;** fr die kleineren Allozierungen bei FindFirst/FindNext usw.
;** Speichervergabe erfolgt in 4-Byte-Stckelung.
;** Der Freispeicher ist in einer verketteten Liste:
;** 1 WORD Next-Pointer
;** 1 WORD Gre dieses Freispeicher-Blocks (inkl. der beiden WORDs)
;** Belegter Speicher hat am Anfang:
;** 1 WORD Gre dieses belegten Blocks (inkl. dieses WORDs)
;** und zurckgegeben wird ein Zeiger DAHINTER
;******************************************************************
proc LocalAlloc pascal
;PE: AX=geforderte Speichermenge in Bytes
;PA: CY=1: kein Speicher mehr frei!
;    CY=0 und DI=Zeiger auf Speicherblock (fertig fr STOSx)
;VR: CX,DI,AX(=tatschliche Alloc-Gre inkl. Gren-WORD)
uses bx,si
;## auf 4-Byte-Stckelung aufrunden, dazu 2 Bytes fr Gren-Merker
	add	ax,5
	and	al,not 3
;## Freispeicher-Kette durchgehen, bis gengend freier Raum gefunden ist
	mov	di,ofs LocalHeap
@@l:	mov	bx,di
	mov	di,[bx]
	cmp	di,1
	jc	@@nomem
	mov	cx,[di+2]
	sub	cx,ax		;Block hat genug Platz?
	jc	@@l		;nein, nchsten Freispeicher suchen
	jz	@@ganz		;Block ganz aufbrauchen (aushngen)
;## Zeigerkette bearbeiten
	mov	si,di
	add	di,ax		;auf neue Position
	mov	[bx],di
	movsw			;Next-Pointer
	mov	[di],cx		;neue (kleinere) Gre
	lea	di,[si-2]
	jmp	@@1
@@ganz:	mov	si,[di]		;Next-Pointer holen
	mov	[bx],si		;am vorhergehenden Knoten einsetzen
@@1:	stosw			;Gre allozierter Block eintragen
@@nomem:ret
endp

proc JoinMem
;FU: Zwei Freispeicher zusammenziehen, wenn mglich
;PE: DI=Zeiger auf ersten Freispeicher
;VR: AX,SI
	mov	si,[di]
	mov	ax,[di+2]
	add	ax,di
	cmp	si,ax		;knnen zusammengezogen werden?
	jne	@@e		;nein (CY=1: fataler Fehler!)
	movsw			;Next-Pointer vorziehen
	lodsw
	add	[di],ax		;Gren addieren
@@e:	ret
endp

proc LocalFree pascal
;PE: DI=Speicherblock-Zeiger
;## "Freispeicher-Umgebung" auf mgliche "Blasenbildung" abtesten,
;## dabei ggf. nach vorn UND nach hinten verbinden!
;PA: CY=1: Versuch, freien Speicher freizugeben (m.a.W.: ungltiger Zeiger)
uses bx,si
	sub	di,2		;auf das Gren-WORD
	mov	cx,ofs LocalHeap
@@l:	mov	bx,cx
	mov	cx,[bx]
	jcxz	@@nomem		;wird einziger oder letzter Freispeicher!
	cmp	cx,di
	jc	@@l		;wenn hier Gleichheit rauskommt, wr's Fehler!
	stc
	jz	@@e
@@nomem:
	mov	ax,[bx+2]	;Gre des Vorblocks
	add	ax,bx
	cmp	di,ax		;DI muss nun grer/gleich AX sein
	jc	@@e		;sonst: Versuch der Freigabe von freiem Speicher
	mov	[bx],di
	xchg	[di],cx
	mov	[di+2],cx	;nun CX=Gre Speicherblock
	call	JoinMem
	mov	di,bx
	call	JoinMem
@@e:	ret
endp

proc LocalInit pascal
;PE: AX=Gre des lokalen Heaps in Bytes
	and	al,not 3	;in 4-Byte-Hppchen!
	std
	mov	di,ofs LocalHeap+6
	stosw
	xor	ax,ax		;NIL-Pointer
	stosw
	stosw			;(ungltige) Null-Lnge
;verhindert auf einfache Weise das ungewollte "Zusammenfassen nach links"
	lea	ax,[di+4]
	stosw			;auf den NIL-Pointer
	cld
	ret
endp

proc IncInDosFlag
	push	ax
	 mov	al,1
	 jmp	@@1
DecInDosFlag:
	push	ax
	 mov	al,-1
@@1:	 push	ds bx
	 pushf
	  lds	bx,[InDosFlagAddr]
	  add	[bx],al
	 popf
	 pop	bx ds
	pop	ax
	ret
endp

	align	2

InDosFlagAddr	dd	?

LinkTable	dw	?	;Link-Tabelle im Heap, Aufbau:
;1.WORD=Anzahl Verzeichnisse (n)
;2..n+1.WORD: ISO-Sektornummern
;n+2..2n+1.WORD: Joliet-Sektornummern

label Residente_Puffer byte
;fastopen_cache
fastopen_buf	db	280 dup (?)	;Lnge: 64+13 +256 +16*4: zu kurz!
fastopen_ptr	dw	?

;diverse Puffer
longname	db	256 dup (?)	;Puffer fr LFN von NextDirEnt()
longbuffer	db	260 dup (?)	;Zwischenpuffer fr Zerlegung/TRUENAME
label longbuffer_end byte

Sektor		db	512 dup (?)	;0.5K Platz fr Festplattensektor
label SektorEnde byte

;noch bentigt: Puffer fr Tunnel-Funktion (in fastopen_buf integrierbar)
;ShortName-Puffer fr RENAME (auf STACK belastend fr Aufrufer)
;	org Sektor
;cbsize		dw	?		;nur fr GetDrvParam (FAT32)
;dpb		TExDPB	<?>		;nur fr GetDrvParam (FAT32)
	org Sektor
;nur fr Rckfallmodus benutzt
old_dta		dd	?
dta		TSearchRec	<?>

	org Sektor
CD_Sektor	db	2048 dup (?)	;2K fr CDFS-Sektor
label CD_SektorEnde byte

CD_Backup	db	2048 dup (?)

CD_BackupSektor	dd	?

LocalHeap	dw	2 dup (?)
ISRE:

;==========================================================================
	org Residente_Puffer+1		;keine Null-Orgien!
;!! +1 weil 1. Byte von fastopen_buf auf 0 gesetzt wird whrend GetDrvParam

;all diese Routinen drfen SI (oder nur nach weiterer Parameter-
;Auswertung) und CH nicht verndern!
cmd_verteiler:	dvt	0dh,Install
		dvt	'?',help
		dvt	'H',help
		dvt	'U',UnInst
		dvt	'D',DisActiv
		dvt	'W',SetWrite
		dvt	'~',SetTilde
		dvt	'T',SetTunnel
		dvt	'C',SetChkLnk
		dvt	'A',SetShLFN
		dvt	'R',SetRoBit
		dvt	'Z',LoadUni
		dvt	'M',SetHeapSize
		dvt	'L',SetLang
		dvt	'S',ShowStatus
		db	0
LocalHeapSize	dw	DEFHEAPSIZE

proc transient
		print	Text0		;Meldung sofort
		call	InstChk		;setzt ggf. ES auf Fremdroutine
		;nun ch=Statusregister:
		;Bit0: Deinstallation nicht mglich
		;Bit7: Noch nicht installiert
		test	ch,bit 7
		jz	@@k		;Zeiger ist resident
		mov	dx,ofs UniLoadSpace
		DOS	3800h		;Land-Info holen
		jc	@@k
		xchg	bx,ax		;AX ist besser im Zugriff!
		or	ah,ah
		jnz	@@k
		cmp	al,41		;Schweiz
		je	@@de
		cmp	al,43		;sterreich
		je	@@de
		cmp	al,49		;Deutschland
		jne	@@k
@@de:		mov	[es:String_Table],ofs Texte_deutsch
@@k:
		mov	si,81h
		cld
@@scancl:	lodsb
		call	Upcase
		push	es
		 push	ds
		 pop	es
		 mov	di,ofs cmd_verteiler
		 call	case
		pop	es
		jc	@@scancl
		call	[word di]
		jmp	@@scancl
endp

	_INW3

proc skip_one_equal_colon_space
	lodsb
	cmp	al,':'
	je	@@e
	cmp	al,'='
	je	@@e
	cmp	al,' '
	je	@@e
	dec	si
@@e:	ret
endp

proc SetHeapSize
	mov	bl,27
	test	ch,bit 7	;Installiert?
	jz	@@err		;ja, kann HeapSize (noch) nicht verndern!
	call	skip_one_equal_colon_space
	call	InW3		;Zahl einlesen
	mov	bl,23
	jc	@@err
	cmp	ax,600		;1 Sektor und noch etwas Platz (nicht fr CD)
	jc	@@err
	cmp	ax,50000	;>50KB ist bei 64KB Segment kaum mglich
	ja	@@err
	mov	[LocalHeapSize],ax
	ret
@@err:	jmp	txtout
endp

proc LoadUni
;BE: Unicode-Tabelle im Volkov-Commander-Tabellenformat laden:
;    Nach einem Byte "1" (hinter irgendeinem Header) mssen noch genau
;    256 Bytes (=128 WORDs) Unicodes im INTEL-Format folgen
	call	skip_one_equal_colon_space
	mov	dx,si		;Dateiname (kurz)
@@l1:	lodsb
	cmp	al,21h		;Ende suchen
	jnc	@@l1
	mov	[byte si-1],0	;terminieren!
	cmp	al,0Dh		;war letztes Argument?
	jne	@@1
	mov	[si],al		;0Dh verschieben nach hinten
@@1:
	DOS	3D00h		;zum Lesen ffnen
	mov	bl,12		;"Kann nicht ffnen"
	jc	@@2		;Datei nicht gefunden o..
	xchg	bx,ax
	push	si cx
	 mov	si,ofs UniLoadSpace
	 mov	dx,si
	 mov	cx,200h		;wann kriege ich den SIZE-Operator hin?
				;(mit STRUC klappt's, mit DUP nicht)
	 DOS	3Fh		;lesen
	 push	ax
	  DOS	3Eh		;und schlieen
	 pop	ax
	 cmp	ax,cx
	 jz	@@err2		;Datei ungltig: zu lang
	 sub	ax,101h
	 jc	@@err2		;Datei ungltig: zu kurz
	 add	si,ax
	 lodsb
	 cmp	al,1
	 jnz	@@err2		;Datei ungltig: falsches Kennbyte
	 mov	di,ofs oem_uni_tab
	 mov	cx,80h
	 rep	movsw		;hineinkopieren (ggf. in residenten Bereich!)
	pop	cx si
	ret
@@err2:	mov	bl,13		;falscher Stack ist hier egal!
@@2:	xchg	dx,ax		;Dateiname (im Fall BL=12)
	jmp	TxtOut		;Raus mit Fehlermeldung
endp

proc SetWrite	;Schalter fr Schreibzugriff
	mov	cl,CTRL_Write
	jmp	SetPlusMinus
endp
proc SetTilde	;Schalter fr Schlangen
	mov	cl,CTRL_Tilde
	jmp	SetPlusMinus
endp
proc SetTunnel	;Schalter fr Tunneleffekt
	mov	cl,CTRL_Tunnel
	jmp	SetPlusMinus
endp
proc SetChkLnk	;Schalter fr Prfsummen-Verbindung
	mov	cl,CTRL_ChkLnk
	jmp	SetPlusMinus
endp
proc SetShLFN	;Schalter fr Prfsummen-Verbindung
	mov	cl,CTRL_ShLFN
	jmp	SetPlusMinus
endp
proc SetRoBit	;Schalter fr ReadOnly-Attribut bei CDFS
	mov	cl,CTRL_RoBit
	;jmp	SetPlusMinus
endp
proc SetPlusMinus
	lodsb
	cmp	al,'+'
	je	@@set
	cmp	al,'-'
	jne	help		;sonst Hilfeseite
	not	cl
	and	[es:ctrl0],cl
	jmp	@@e
@@set:	or	[es:ctrl0],cl
@@e:	or	ch,40h		;irgendein Schalter
	ret
endp

proc SetLang
	lodsb
	call	Upcase
	cmp	al,'D'
	mov	ax,ofs Texte_deutsch
	je	@@de
	mov	ax,ofs Texte_englisch
@@de:	mov	[es:String_Table],ax
	ret
endp

proc help	;Hilfe Option "H" oder "?", kein Return
	mov	bl,10
	jmp	TXTO1
endp

proc UnInst	;Deinstallation(sversuch) Option "U", kein Return
		mov	bl,7		;"noch nicht installiert"
		test	ch,80h
		jnz	TXTO1		;Wenn nicht ntig!
		test	ch,1
		jz	Raus
		mov	bl,5		;"deaktiviert"
		call	AusgabeStringNr
		inc	bl		;"Interrupt gestohlen"
disab:		and	[es:Ctrl0],not 80h	;lschen
		jmp	TXTOut
DisActiv:;Deaktivieren Option "D" oder Dirs ein/aus mit D+/D-
		test	ch,80h		;Schon installiert?
		mov	bl,7
		jnz	TXTO1
		mov	bl,5		;"deaktiviert"
		jr	disab
	;Deinstallation
Raus:		lds	dx,[es:ofs OldInt21]
		DOS	2521h
		DOS	49h		;den Speicher ab es freigeben
		push	cs
		pop	ds
		mov	bl,4		;"removed..."
TXTO1:		jmp	TXTOut
endp

proc InstChk
;Installationscheck, ES=Zeiger auf installierte Routine oder n.a.!,
;Bit7(CH)=0: Installationscheck erfolgreich, dann:
;ES: Segmentadresse der residenten Routine
;Bit0(CH)=0: Zeiger nicht von anderen verbogen
;Auerhalb von InstChk: Bit6(CH)=1 wenn irgendein Schalter akzeptiert
		mov	dx,REQcode
		DOS	REQfunc		;Install-Test
		xor	ch,ch
		cmp	ax,ANScode	;gleich?
		jz	@@T21I
		or	ch,80h		;Z-Flag "retten"
		mov	dx,ds
@@T21I:		push	dx		;Segment der TSR
	;Segment retten
		DOS	3521h		;Get Int21
		SES	<OldInt21>,bx
		cmp	bx,ofs NewInt21
		jnz	@@T21FLT
		mov	bx,es
		cmp	bx,dx
		je	@@T21OK
@@T21FLT:	inc	ch		;ch <>0 wenn andere TSR strt
@@T21OK:	pop	es
		ret
endp

proc Install	;Installation, kein Return
	test	ch,80h
	jnz	@@test
	mov	bl,3		;"reaktiviert"
	test	ch,40h		;irgendein Schalter auf Kommandozeile gewesen?
	jz	@@setab		;nein, "reaktiviert"
	mov	bl,9		;weniger irrefhrender Text
	jmp	@@setab
@@test:
	IS386
	mov	bl,8		;"Test386 versagt"
	jc	TXTOut
	push	es		;Brauch ich's?
	 DOS	34h		;InDOS-Flag-Adresse beschaffen
	 SES	[InDosFlagAddr],bx
	pop	es
	;Hand-Relokation im residenten Bereich
	mov	[word high rwrec.addr],cs
	mov	al,0
	mov	[DriveType],al	;Um Gottes Willen keinen Flush machen!
	call	GetDrvParams	;fr's momentane Laufwerk im voraus
	;Zeiger auf "filename uppercase table" beschaffen
	mov	bx,0FFFFh
	mov	cx,5
	mov	dx,bx
	mov	di,5Dh
	DOS	6504h
	mov	eax,[5Eh]
	sub	ax,7Eh
	mov	[uppercase_table],eax
	;Zeiger verbiegen
	mov	dx,ofs NewInt21
	DOS	2521h			;Set Int21
	;Environment freigeben
	mov	es,[2ch]	;Segment Environment
	DOS	49h		;ENV-Speicher ab es freigeben
	;Lokalen Heap initialisieren (oder das eigene Grab schaufeln)
	;Test des Hochladens
	mov	ax,cs
	mov	es,ax		;Eigenes Programm=Resident!
	cmp	ax,0a000h
	jc	@@NoHi		;unten
	mov	bl,1		;$HOCH
	call	AusgabeStringNr
@@NoHi:	mov	ax,[LocalHeapSize]
	call	LocalInit
	mov	bl,2		;Installiere
	;VB enabeln
@@setab:or	[es:Ctrl0],80h	;setzen
	mov	ax,offset ISRE+1Fh	;hier: inklusive MCB
	add	ax,[LocalHeapSize]
	and	al,not 0Fh
	;BL-numerierten Text ausgeben
TXTOut:	push	ax
	call	AusgabeStringNr	;Textausgabe
	pop	ax
	;Programm beenden
LFOut:	mov	bh,bl
	call	AusgabeNL
	cmp	bh,2		;Installierung? (etwas seltsam!)
	mov	ax,4C00h
	jnz	@@exi
	mov	ah,31h		;Resident
	mov	dx,offset ISRE+0Fh
	add	dx,[LocalHeapSize]
	shr	dx,4
@@exi:	DOS
endp

proc ShowStatus	;Status-Anzeige, kein Return
	test	ch,80h
	mov	bl,7		;"Noch nicht installiert"
	jnz	TXTOut
	mov	cl,[es:ctrl0]
	test	cl,80h
	mov	bl,5		;"deaktiviert"
	jz	TXTOut
	mov	bl,11
	call	AusgabeStringNr
	call	AusgabeNL
	call	AusgabeSchalter
	mov	bl,14
	mov	si,ofs counter_read
	seges	lodsw
	call	AusgabeZaehler
	inc	bl
	seges	lodsw
	call	AusgabeZaehler
	inc	bl
	seges	lodsw
	call	AusgabeZaehler
	DOS	4C00h
endp

proc AusgabeSchalter
;Alle Schalter ausgeben
	mov	cl,[es:ctrl0]
	mov	ch,40h
	mov	bl,17
@@l:	push	bx
	 call	AusgabeSch
	pop	bx
	ror	ch,1
	inc	bl
	cmp	bl,23
	jne	@@l
	ret
endp

proc AusgabeZaehler
;PE: BL=String-Nummer
;    AX=Zhlerstand
	push	bx
	 push	ax
	 call	AusgabeStringNr
	 pop	ax
	 call	AusgabeNL
	pop	bx
	ret
endp

proc GetOnOffPtr
;PE: Z=0=EIN, Z=1=AUS
;PA: SI=String-Zeiger
;VR: AX,CX,SI
	push	bx
	 mov	bl,24		;"EIN"
	 jnz	@@1
	 inc	bl		;"AUS"
@@1:	 call	LoadString
	pop	bx
	ret
endp

proc AusgabeSch
	push	bx cx
	 test	cl,ch
	 call	GetOnOffPtr
	 push	si
	 call	LoadString
	 push	si
	 mov	bl,26		;"%xxs %s\n"
	 call	AusgabeStringNr
	 pop	cx
	 pop	cx
	pop	cx bx
	ret
endp

proc LoadString
;FU: String-ID (BL) in String-Zeiger (SI) und Lngen-Info (CX) umsetzen
;VR: AX,BL,CX,SI
	push	es di
	 inc	bl
	 xor	al,al
	 mov	di,[es:String_Table]	;deutsch oder englisch
	 LD	es,ds
@@l:	 mov	si,di			;immer Anfang merken
	 mov	cx,-1
	 repne	scasb			;Null suchen und Lnge bestimmen
	 dec	bl
	 jnz	@@l
	 not	cx
	 dec	cx			;jetzt CX=String-Lnge
	pop	di es
	ret
endp

AusgabeNL:
	mov	bl,0
proc AusgabeStringNr c
;FU: String aus String-Tabelle mit Nummer BL ausgeben,
;    dabei Formatierung mit einer Mini-PRINTF-Funktion und 0A->0D0A-Expansion
local @@numberpuffer:BYTE:34,@@flags,@@space,@@preci
	pusha
	call	LoadString
	push	es
	 LD	es,ds
	 mov	di,offset UniLoadSpace
	 lea	bx,[bp+4]
@@l:	 lodsb
	 or	al,al
	 jz	@@e
	 cmp	al,'%'
	 je	@@esc
	 cmp	al,0ah
	 je	@@0a
	 stosb
	 jmp	@@l
@@0a:
	 mov	ax,0a0dh
	 stosw
	 jmp	@@l
@@esc:
	 xor	ax,ax
	 mov	[BP-6],ax
	 mov	[BP-4],ax
	 mov	[BP-2],ax
	 call	EasyPrintfHandler
	 jmp	@@l
@@e:
	 mov	cx,di
	 mov	dx,offset UniLoadSpace
	 sub	cx,dx			;Anzahl Zeichen
	 mov	bx,1			;stdout
	 DOS	40h			;schreiben (BlockWrite)
	pop	es
	popa
	ret
endp

;************ PRINTF: Komplette %-Behandllung ***************

SwitchChars	db	'LFNhl0.-+# '

proc PreprocessHandler
;NUR FR TINY-MODELL und 386
;verarbeitet eine Sequenz, zum Verketten gemacht!
;Kann alle Prprozessor-Sachen: #,0,-,*,Feldbreite,Przision,h,l,N,F
;
;PE: DS:SI=Eingabedaten
;    ES:DI=Ausgabedaten
;    SS:BP-8=PRINTF-Daten: OLen,Flags,Space,Precis
;    SS:BX=Externe Daten (hier: fr "*"-Feldbreiten-Platzhalter)
;PA: DS:SI->da geht's weiter
;    AL=(unbekanntes) Zeichen
;    CY=1 = konnte kein End-Zeichen umsetzen
@@l:	lodsb
	mov	cx,11
	push	di
	 mov	di,offset SwitchChars
	 repne	scasb	;any known switch character?
	pop	di
	jne	@@nf
	bts	[bp-6],cx
	jmp	@@l
@@nf:
	cmp	al,'*'
	je	@@st
	cmp	al,'0'
	jc	@@gu
	cmp	al,'9'
	ja	@@gu
@@nu:			;scan the number
	dec	si
	push	bx
	 mov	bx,10
	 call	inw	;DS:SI->AX, DS:SI moved forward
	pop	bx
	jmp	@@nu0
@@st:
	mov	ax,[bx]	;get number from arglist
	inc	bx
	inc	bx
@@nu0:
	test	[byte bp-6],bit 4
	jnz	@@pr
	mov	[bp-4],ax	;field width
	jmp	@@l
@@pr:
	mov	[bp-2],ax	;precision (not used if prec bit not given)
	jmp	@@l
@@gu:			;give up, unknown character (including zero)
	ret
endp

proc printf_FillChar
;PE: AX=number of characters
	xchg	cx,ax
	mov	al,' '
	test	[byte bp-6],bit 5
	jz	@@1
	mov	al,'0'
@@1:	rep	stosb
	ret
endp

proc printf_strlen
;PE: DS:SI=String, AX=MaxLen (=precis oder 0FFFFh)
	push	di
	 mov	di,si
	 mov	cx,ax
	 push	ax
	  mov	al,0
	  repne	scasb
	  inc	cx
	 pop	ax
	 sub	ax,cx
	pop	di
	ret
endp

proc printf_postfill
	xor	[byte bp-6],bit 3	;Bit kippen
endp
proc printf_prefill
;PE: AX=auszugebende Zeichenzahl
	test	[byte bp-6],bit 3
	jnz	@@e		;left aligned: do nothing!
fill0:
	push	ax
	 sub	ax,[bp-4]
	 jnc	@@e0
	 neg	ax		;free width
	 call	printf_FillChar
@@e0:	pop	ax
@@e:	ret
endp


proc printf_itoa
;BL=Zahlenbasis; negativ wenn Zahl vorzeichenbehaftet
;EAX=Zahl
;[BP-6]=Flags, Bit 15=1 fr groe Hex-Buchstaben
;DI=ASCII-Puffer
;PA:DI=Ende Puffer (nicht terminiert!)
	mov	dx,[bp-6]
	xchg	ecx,eax
	or	bl,bl
	jns	@@1
	neg	bl		;jetzt positiv machen
	or	ecx,ecx
	mov	al,'-'
	js	@@putn
	test	dl,bit 2	;Merker "+"
	mov	al,'+'
	jnz	@@put
	test	dl,bit 0	;Merker " "
	mov	al,' '
	jnz	@@put
	jmp	@@1
@@putn:	neg	cx
@@put:	stosb
@@1:	test	dl,bit 1	;Merker "#"
	jz	@@2
	cmp	bl,8
	mov	al,'0'
	jne	@@no_8
	stosb
@@no_8:	cmp	bl,2
	mov	ah,'b'
	je	@@do_2
	cmp	bl,16
	mov	ah,'x'
	jne	@@2
@@do_2:	stosw
@@2:	xchg	ecx,eax		;wieder zurck!
	xor	cx,cx		;Zhler der PUSHes
	movzx	ebx,bl
@@l1:	inc	cx
	xor	edx,edx
	div	ebx
	push	dx		;eine Ziffer
	or	eax,eax
	jnz	@@l1
@@l2:	pop	ax		;herausholen in umgekehrter Reihenfolge
	add	al,'0'		;(Alternative: Puffer von hinten fllen!)
	cmp	al,'9'
	jbe	@@3
	add	al,7
	test	[byte bp-5],bit 7
	jnz	@@3
	add	al,20h		;Kleinbuchstaben
@@3:	stosb
	loop	@@l2
	ret
endp

proc EasyPrintfHandler
	call	PreprocessHandler
	cmp	al,'%'		;muss als Extrawurst gebraten werden!
	je	@@perc
	push	si
	 cmp	al,'s'
	 je	@@s
	 lea	si,[bp-34-6]
	 cmp	al,'c'
	 je	@@c
	 mov	dl,-10
	 cmp	al,'d'
	 je	@@num
	 cmp	al,'i'
	 je	@@num
	 mov	dl,10
	 cmp	al,'u'
	 je	@@num
	 mov	dl,8
	 cmp	al,'o'
	 je	@@num
	 mov	dl,2
	 cmp	al,'b'		;Nicht Standard, aber sehr ntzlich!
	 je	@@num
	 mov	dl,16
	 cmp	al,'x'
	 je	@@num
	 or	[byte bp-5],bit 7
	 cmp	al,'X'
	 je	@@num
	 cmp	al,'p'		;Zeiger als groe Hex-Zahlen ausgeben
	 je	@@num
	pop	si
	dec	si
	stc
	ret

@@perc:	stosb
	ret

@@num:	 mov	eax,[bx]
	 test	[byte bp-6],bit 6
	 jnz	@@long
	 movzx	eax,ax
	 or	dl,dl
	 jns	@@nume
	 movsx	eax,ax
	 jmp	@@nume
@@long:	 inc	bx
	 inc	bx
@@nume:	 push	di bx
	  mov	di,si
	  mov	bx,dx
	  call	printf_itoa
	  sub	di,si		;Anzahl Zeichen
	  xchg	di,ax		;nach AX
	 pop	bx di
	 jmp	@@stout
@@c:
	 mov	si,bx		;Diese Adresse ist Quelle
	 mov	ax,1
	 jmp	@@stout
@@s:
	 mov	ax,[bx]
	 or	ax,ax		;NULL-Pointer?
	 jz	@@stout		;Dann nichts ausgeben!
	 xchg	si,ax
	 mov	ax,0FFFFh
	 test	[byte bp-6],4	;precis given?
	 jz	@@1
	 mov	ax,[bp-2]	;use precis as maximum length!
@@1:	 call	printf_strlen
@@stout:	;Einsprung mit DS:SI=Stringzeiger, AX=String-Lnge
	 inc	bx
	 inc	bx
	 call	printf_prefill
	 mov	cx,ax
	 rep	movsb
	 call	printf_postfill
	pop	si
	ret
endp


Text0	db	'DosLfn 0.32b (haftmann#software 10/01): $'

Texte_deutsch:
 dz	10							;0
 dz    'hoch'							;1
 dz    'geladen, Speicherbedarf %u Bytes.'			;2
 dz    'reaktiviert.'						;3
 dz    'vom Speicher entfernt.'					;4
 dz    'deaktiviert.'						;5
 dz    ' (Andere TSR stahl Int21)'				;6
 dz    'Noch nicht installiert!'				;7
 dz    'Bentigt mindestens einen 386er Prozessor!'		;8
 dz    'Schalter angenommen.'					;9
 db    '	(386+)	++ FREEWARE ++',10			;10
  db   'Programm fr lange Dateinamen unter nacktem DOS.',10
  db   'Aktionen:	- (nichts)	TSR laden oder aktivieren',10
  db   '		- h oder ?	diese Hilfe',10
  db   '		- d		DosLfn deaktivieren',10
  db   '		- s		Statusinfo',10
  db   '		- u		TSR entfernen',10
  db   'Schalter:	- w{+|-}	* Schreibzugriffe',10
  db   '		- ~{+|-}	* Tilde (ich hasse Schlangen)',10
  db   '		- t{+|-}	* Tunneleffekt',10
  db   '		- c{+|-}	* Prfsummen-Verknpfung',10
  db   '		- a{+|-}	* LFN fr ShortName-APIs (LoSA)',10
  db   '		- r{+|-}	* Schreibschutz-Attribut fr CD-Dateien',10
  db   '		- z[:|=]table	Unicode-Tabelle (Volkov-Format) laden',10
  db   '		- m[:|=]bytes	Gre des internen Heaps festlegen, 600..50000',10
  db   '		- l{d|e}	Sprache setzen (deutsch|englisch)',10
  db   'Umgebung: TZ=xxxNyyy		Zeitzone N fr Zeitumrechnung, ohne DST',10
  db   ': (noch) nicht implementiert',10
  db   'Email:    henrik.haftmann@e-technik.tu-chemnitz.de',10
  dz   'Download: http://www.tu-chemnitz.de/~heha/hs_freeware/doslfn.zip'

 dz    'aktiv'							;11
 dz 10,'Kann Unicode-Datei %s nicht finden/ffnen!'		;12
 dz    'Falscher Datei-Inhalt!'					;13
 dz    '%5u Lesezugriffe'					;14
 dz    '%5u Schreibzugriffe'					;15
 dz    '%5u Int21/AH=71-Aufrufe'				;16
 dz    'Schreibzugriffe'					;17
 dz    'Schlangen'						;18
 dz    'Tunneleffekt'						;19
 dz    'Prfsummen-Verknpfung'					;20
 dz    'LFN fr ShortName-APIs (LoSA)'				;21
 dz    'Schreibschutz-Attribut fr CD-Dateien'			;22
 dz    'Ungltige Heap-Gre'					;23
 dz    'EIN'							;24
 dz    'AUS'							;25
 dz    '%37s %s',10						;26
 dz    'Kann Heap-Gre nicht verndern',10,'Dazu vorher TSR entfernen'	;27

texte_englisch:
 dz	10							;0
 dz    'high '							;1
 dz    'loaded consuming %u bytes of memory.'			;2
 dz    'enabled.'						;3
 dz    'removed from memory.'					;4
 dz    'disabled.'						;5
 dz    ' (Another TSR grabbed Int21)'				;6
 dz    'Not yet installed!'					;7
 dz    'Requires at least a 386 processor!'			;8
 dz    'switch(es) taken'					;9
 db    '	(386+)	++ FREEWARE ++',10			;10
  db   'Program that supports long filenames in pure DOS.',10
  db   'USE THIS PROGRAM AT YOUR OWN RISK, DATA LOSS MAY BE POSSIBLE',10
  db   'Actions:	- (nothing)	load and/or enable TSR',10
  db   '		- h or ?	this help',10
  db   '		- d		disable DosLfn',10
  db   '		- s		show status',10
  db   '		- u		unload TSR',10
  db   'Switches:	- w{+|-}	* write access',10
  db   '		- ~{+|-}	* tilde usage (I hate snakes)',10
  db   '		- t{+|-}	* tunnel effect',10
  db   '		- c{+|-}	* checksum linkage',10
  db   '		- a{+|-}	* support of LFN for ShortName API (LoSA)',10
  db   '		- r{+|-}	* read-only bit for CD files',10
  db   '		- z[:|=]table	load Unicode table (format Volkov)',10
  db   '		- m[:|=]bytes	declare size of internal heap, 600..50000',10
  db   '		- l{d|e}	set language (german|english)',10
  db   'Environment: TZ=xxxNyyy	time zone N for time conversion, no DST usage',10
  db   ': not yet implemented',10
  db   'email:    henrik.haftmann@e-technik.tu-chemnitz.de',10
  dz   'Download: http://www.tu-chemnitz.de/~heha/hs_freeware/doslfn.zip'

 dz    'active'							;11
 dz 10,'Cannot open or load Unicode table file %s!'		;12
 dz    'Wrong file content!'					;13
 dz    '%5u read accesses'					;14
 dz    '%5u write accesses'					;15
 dz    '%5u Int21/AH=71 calls'					;16
 dz    'write access'						;17
 dz    'tilde usage'						;18
 dz    'tunnel effect'						;19
 dz    'checksum linkage'					;20
 dz    'LFN support on ShortName API (LoSA)'			;21
 dz    'Read-Only bit set on CD files'				;22
 dz    'invalid heap size'					;23
 dz    'ON'							;24
 dz    'OFF'							;25
 dz    '%35s %s',10						;26
 dz    'cannot resize heap - unload TSR first'			;27

UniLoadSpace	db	200h dup (?)

	endc
;**************************************************************************



proc Get_Start ;VERALTET
;Testet den String auf fhrenden (Back)Slash und liefert den Startsektor
;PE: DS:SI=Pfad-String
;PA: EAX=Start-Sektor ("/" oder ".")
;    SI ggf. vorgerckt
;    CY=1: "." lt sich nicht ermitteln
	call	ParseSlash
	jnz	GetDotSector
@@r:	call	ParseSlash
	jz	@@r		;beliebig viele /// bergehen
	mov	eax,[DPB_DirSec]
@@e:	ret
endp

proc Get_Drive
;Testet den String auf Laufwerk voran und setzt DL entsprechend
;PE: FS:SI=Pfad-String
;PA: DL=Laufwerk (1=A)
;    SI ggf. vorgerckt
;    CY=1: falscher Laufwerks-Bezeichner
;VR: AL,SI,DL
	mov	dl,0
	cmp	[byte si+1],':'
	clc
	jne	@@e
	segfs	lodsw
	call	upcase
	sub	al,'A'
	cmp	al,26
	cmc
	inc	al
	xchg	dl,al
@@e:	ret
endp

proc Match_DirEnt pascal
;vergleicht momentanen DirEnt mit FCB_Name
;PE: bx=DirEnt-Zeiger
;    FCB_Name=gefllt mit Name in Grobuchstaben
;    DS,ES=CS, CLD
;PA: Z=1 wenn bereinstimmung
;VR: SI,DI
uses cx
	mov	si,bx		;leider ist SMART zu doof
	lea	di,[FCB_Name]
	mov	cx,11
	repe	cmpsb
	ret
endp

proc Match_LfnDirEnt
;PE: [longname]=aufgesammelter langer Dateiname
;    [CurPathComp]=Zeiger auf gewnschten Namensbestandteil
;    DS,ES=CS, CLD
;PA: Z=1 wenn bereinstimmung
;VR: SI,DI
	mov	si,ofs longname
	mov	di,[CurPathComp]
	jmp	StrIComp	;luft hinein
endp

proc Client_Append_Backslash pascal
;ein Backslash bei CLIENT_ES:di dranhngen
uses ES
	mov	es,[Client_DS]
	call	Append_Backslash
	ret	;so lassen wegen USES!
endp


WRPM:	;Plus (Z=0) oder Minus (Z=1) ausgeben
		mov	dl,'+'
		jnz	wrpm1
		mov	dl,'-'
wrpm1:		DOS	2
		ret

proc ParseSlash ;VERALTET
;langweilige Pfadtrenner-bergehung
;PA: Z=1 wenn Pfad-Trenner, dann
;    SI um 1 vorgerckt
	lodsb
	cmp	al,'\'		;Pfad-Trenner bergehen
	je	@@e
	cmp	al,'/'
	je	@@e
	dec	si
@@e:	ret
endp

proc ParseToFCB pascal ;VERALTET
;Noch beta wegen bergehung illegaler Zeichen
;PE: SI=Zeiger auf Namensteil (in ShortBuffer)
;    DS,ES=CS
;PA: FCB_Name enthlt Name mit Leerzeichen usw.
;    SI=auf nchstes Element vorgerckt
;    Trenn-Slash/Backslash durch Dummy ersetzt
;    letzte Zeichen ='.' durch Dummy ersetzen
;    [CurPathComp] speichert SI von vor dem Aufruf
;    bei '*' am Ende Fragezeichen als Extension einsetzen
;VR: SI,AX
uses DI
	mov	[CurPathComp],si
	lea	di,[FreeSpace]
	DOS	2900h		;Parse zu FCB, Laufwerk usw. uninteressant
	inc	di
	cmp	[byte di],0E5h	;Sigma?
	jne	@@ne5
	mov	[byte di],005h	;anstelle
@@ne5:	lodsb
	or	al,al
	jz	@@5
	cmp	al,'\'		;hier nur Backslash
	jnz	@@ne5
@@5:	dec	si		;auf den Terminator
	mov	di,si
@@l2:	dec	di
	cmp	[byte di],'.'
	jne	@@2
	mov	[byte di],0
	jmp	@@l2
@@2:	cmp	[byte di],'*'
	jne	@@ee
	cmp	[byte FCB_Name+8],' '	;schon Extension erfat?
	jne	@@ee
	mov	[dword FCB_Name+8],'???'
@@ee:
@@l:	call	ParseSlash
	jnz	@@e
	mov	[byte si-1],0	;Pfad-Trenner lschen
	jmp	@@l
@@e:	ret
endp

proc IsInvalidLfn pascal ;VERALTET
;PE: [CurPathComp]=Zeiger auf Namensbestandteil
;PA: Z=1: kein gltiger LFN (ungltiges Zeichen, leer oder Leerzeichen)
;VR: AX,CX
uses si,di
	mov	si,[CurPathComp]
	lodsb
	mov	cx,10	;inklusive Dummy am Anfang
@@l:	mov	di,ofs Invalid_Lfn_Chars-2
	repne	scasb
	jz	@@f
	mov	ah,al		;merken
	lodsb
	or	al,al
	mov	cx,9	;die "normalen" verbotenen Zeichen
	jnz	@@l
	cmp	ah,' '		;letztes Zeichen=' '?
@@f:	ret
endp

proc Locate_Both_Names	;VERALTET
	stc			;ohne Cache
	jmp	same_stuff
;bentigt fr das Verfolgen von PFADEN(?)
	call	Is_SFN
	jz	Locate_FCB_Name	;sofort kurzen Namen suchen
	push	[CurSector]	;32-bit-Push
	 call	Locate_LFN_Name
	 jnz	@@e1		;nicht gefunden
	add	sp,4
	ret			;als LFN gefunden
@@e1:
	pop	[CurSector]
	;call	Locate_FCB_Name	;hineinlaufen
	;ret
endp

proc Locate_FCB_Name pascal	;VERALTET
;Sektoren abklappern, bis FCB_Name gefunden
;PA: Z=1: gefunden,
;    DL=1: LFN vorhanden,
;    BX=DirEnt-Zeiger,
;    CY=1: nicht gefunden
;VR: AX,BX,CX,DX
uses si,di
	call	ReadSec
	jc	@@e
	lea	bx,[Sektor]	;der DirEnt-Zeiger
@@l:	call	Locate_DirEnt
	jc	@@e		;kein weiterer DirEnt
	call	Is_FCB_Equal
	jz	@@e
	call	Next_DirEnt
	jnc	@@l
@@e:	ret
endp

proc Locate_LFN_Name pascal	;VERALTET
;wie oben, jedoch Verwendung von [CurPathComp] als PE
;Ist kein LFN-Eintrag vorhanden, witd nicht "gematcht",
;es sei denn, der gegebene LFN war "kurz"
uses si,di
	call	ReadSec
	jc	@@e
	lea	bx,[Sektor]		;der DirEnt-Zeiger
@@l:	call	Locate_DirEnt
	jc	@@e
	cmp	dl,1
	jne	@@1
	mov	si,ofs longname
	mov	di,[CurPathComp]
	call	StrIComp
	jmp	@@2
@@1:	test	[File_Flags],File_Flag_Is_LFN ;FCB-Match berhaupt erlaubt?
	jnz	@@3
	call	Is_FCB_Equal
@@2:	jz	@@e
@@3:	call	Next_DirEnt
	jnc	@@l
@@e:	ret
endp

proc FindFirstLoop	;VERALTET
;mit BX=Sektorzeiger und [SearchAttr]=Attribute
@@l:	call	Locate_DirEnt
	jc	@@e1		;raus bei Fehler
	cmp	dl,1
	jne	@@cmpshort
	lea	di,[LongName]
	mov	si,[CurPathComp]
	call	Globbing	;LFN-Suche (mit etwas UNIX-Stil)
	jnc	@@f
	jmp	@@1
@@cmpshort:
	mov	[LongName],0	;"kein LFN" vermerken
	lea	si,[FCB_Name]	;FCB-Name (ohne Punkt), mit 05 statt E5
	mov	di,bx		;kurzer Name im DirEnt
	mov	cx,11
@@ls:	lodsb
	scasb			;bei '?' nur zum DI inkrementieren
	je	@@match
	cmp	al,'?'
@@match:
	loope	@@ls
	jz	@@f
FindNextLoop:
@@1:
@@n:	call	Next_DirEnt
@@e1:
	jnc	@@l
	mov	ax,9912h	;no more files
	ret
@@f:	;noch Attribut testen
	mov	al,[(TDirEnt bx).attr]
	call	Match_Attr
	jnz	@@1
	ret

proc Max_CX_OK_Chars ;VERALTET
;Hilfsroutine fr Is_LFN
;PE: SI=Zeiger Test-Zeichenkette
;    CX=Anzahl zu testender Zeichen
;    DS,ES=CS
;PA: AL="verbotenes" oder CX+1. Zeichen
@@l:	lodsb
	push	cx
	 mov	cx,9
	 mov	di,ofs Invalid_Chars
	 repne	scasb
	pop	cx
	loopnz	@@l
	jz	@@e
	lodsb
@@e:	or	al,al
	ret
endp

proc Is_SFN pascal	;VERALTET
;PE: [CurPathComp]=Zeiger auf Namensbestandteil
;PA: Z=1: SFN, keine Indizien auf LFN (abgesehen von Kleinbuchstaben)
;VR: AL,CX
uses si,di
	mov	si,[CurPathComp]
	mov	cx,8
	call	Max_CX_OK_Chars	;mu Null oder Punkt liefern fr SFN
	jz	@@e
	cmp	al,'.'
	jnz	@@e
	mov	cx,3
	call	Max_CX_OK_Chars	;mu Null liefern fr SFN
@@e:	ret
endp

